/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethodMap;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.MemberKey;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.Annotations;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AnnotatedClass
extends Annotated
implements TypeResolutionContext {
    private static final AnnotationMap[] NO_ANNOTATION_MAPS = new AnnotationMap[0];
    protected final JavaType _type;
    protected final Class<?> _class;
    protected final TypeBindings _bindings;
    protected final List<JavaType> _superTypes;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final TypeFactory _typeFactory;
    protected final ClassIntrospector.MixInResolver _mixInResolver;
    protected final Class<?> _primaryMixIn;
    protected AnnotationMap _classAnnotations;
    protected boolean _creatorsResolved = false;
    protected AnnotatedConstructor _defaultConstructor;
    protected List<AnnotatedConstructor> _constructors;
    protected List<AnnotatedMethod> _creatorMethods;
    protected AnnotatedMethodMap _memberMethods;
    protected List<AnnotatedField> _fields;

    private AnnotatedClass(JavaType javaType, Class<?> clazz, TypeBindings typeBindings, List<JavaType> list, AnnotationIntrospector annotationIntrospector, ClassIntrospector.MixInResolver mixInResolver, TypeFactory typeFactory, AnnotationMap annotationMap) {
        this._type = javaType;
        this._class = clazz;
        this._bindings = typeBindings;
        this._superTypes = list;
        this._annotationIntrospector = annotationIntrospector;
        this._typeFactory = typeFactory;
        this._mixInResolver = mixInResolver;
        this._primaryMixIn = this._mixInResolver == null ? null : this._mixInResolver.findMixInClassFor(this._class);
        this._classAnnotations = annotationMap;
    }

    @Override
    public AnnotatedClass withAnnotations(AnnotationMap annotationMap) {
        return new AnnotatedClass(this._type, this._class, this._bindings, this._superTypes, this._annotationIntrospector, this._mixInResolver, this._typeFactory, annotationMap);
    }

    public static AnnotatedClass construct(JavaType javaType, MapperConfig<?> mapperConfig) {
        AnnotationIntrospector annotationIntrospector = mapperConfig.isAnnotationProcessingEnabled() ? mapperConfig.getAnnotationIntrospector() : null;
        Class<?> clazz = javaType.getRawClass();
        return new AnnotatedClass(javaType, clazz, javaType.getBindings(), ClassUtil.findSuperTypes(javaType, null, false), annotationIntrospector, mapperConfig, mapperConfig.getTypeFactory(), null);
    }

    public static AnnotatedClass construct(JavaType javaType, MapperConfig<?> mapperConfig, ClassIntrospector.MixInResolver mixInResolver) {
        AnnotationIntrospector annotationIntrospector = mapperConfig.isAnnotationProcessingEnabled() ? mapperConfig.getAnnotationIntrospector() : null;
        Class<?> clazz = javaType.getRawClass();
        return new AnnotatedClass(javaType, clazz, javaType.getBindings(), ClassUtil.findSuperTypes(javaType, null, false), annotationIntrospector, mixInResolver, mapperConfig.getTypeFactory(), null);
    }

    public static AnnotatedClass constructWithoutSuperTypes(Class<?> clazz, MapperConfig<?> mapperConfig) {
        if (mapperConfig == null) {
            return new AnnotatedClass(null, clazz, TypeBindings.emptyBindings(), Collections.emptyList(), null, null, null, null);
        }
        AnnotationIntrospector annotationIntrospector = mapperConfig.isAnnotationProcessingEnabled() ? mapperConfig.getAnnotationIntrospector() : null;
        return new AnnotatedClass(null, clazz, TypeBindings.emptyBindings(), Collections.emptyList(), annotationIntrospector, mapperConfig, mapperConfig.getTypeFactory(), null);
    }

    public static AnnotatedClass constructWithoutSuperTypes(Class<?> clazz, MapperConfig<?> mapperConfig, ClassIntrospector.MixInResolver mixInResolver) {
        if (mapperConfig == null) {
            return new AnnotatedClass(null, clazz, TypeBindings.emptyBindings(), Collections.emptyList(), null, null, null, null);
        }
        AnnotationIntrospector annotationIntrospector = mapperConfig.isAnnotationProcessingEnabled() ? mapperConfig.getAnnotationIntrospector() : null;
        return new AnnotatedClass(null, clazz, TypeBindings.emptyBindings(), Collections.emptyList(), annotationIntrospector, mixInResolver, mapperConfig.getTypeFactory(), null);
    }

    @Override
    public JavaType resolveType(Type type) {
        return this._typeFactory.constructType(type, this._bindings);
    }

    @Override
    public Class<?> getAnnotated() {
        return this._class;
    }

    @Override
    public int getModifiers() {
        return this._class.getModifiers();
    }

    @Override
    public String getName() {
        return this._class.getName();
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> clazz) {
        return this._classAnnotations().get(clazz);
    }

    @Override
    public boolean hasAnnotation(Class<?> clazz) {
        return this._classAnnotations().has(clazz);
    }

    @Override
    public boolean hasOneOf(Class<? extends Annotation>[] classArray) {
        return this._classAnnotations().hasOneOf(classArray);
    }

    @Override
    public Class<?> getRawType() {
        return this._class;
    }

    @Override
    public Iterable<Annotation> annotations() {
        return this._classAnnotations().annotations();
    }

    @Override
    protected AnnotationMap getAllAnnotations() {
        return this._classAnnotations();
    }

    @Override
    public JavaType getType() {
        return this._type;
    }

    public Annotations getAnnotations() {
        return this._classAnnotations();
    }

    public boolean hasAnnotations() {
        return this._classAnnotations().size() > 0;
    }

    public AnnotatedConstructor getDefaultConstructor() {
        if (!this._creatorsResolved) {
            this.resolveCreators();
        }
        return this._defaultConstructor;
    }

    public List<AnnotatedConstructor> getConstructors() {
        if (!this._creatorsResolved) {
            this.resolveCreators();
        }
        return this._constructors;
    }

    public List<AnnotatedMethod> getStaticMethods() {
        if (!this._creatorsResolved) {
            this.resolveCreators();
        }
        return this._creatorMethods;
    }

    public Iterable<AnnotatedMethod> memberMethods() {
        if (this._memberMethods == null) {
            this.resolveMemberMethods();
        }
        return this._memberMethods;
    }

    public int getMemberMethodCount() {
        if (this._memberMethods == null) {
            this.resolveMemberMethods();
        }
        return this._memberMethods.size();
    }

    public AnnotatedMethod findMethod(String string, Class<?>[] classArray) {
        if (this._memberMethods == null) {
            this.resolveMemberMethods();
        }
        return this._memberMethods.find(string, classArray);
    }

    public int getFieldCount() {
        if (this._fields == null) {
            this.resolveFields();
        }
        return this._fields.size();
    }

    public Iterable<AnnotatedField> fields() {
        if (this._fields == null) {
            this.resolveFields();
        }
        return this._fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AnnotationMap _classAnnotations() {
        AnnotationMap annotationMap = this._classAnnotations;
        if (annotationMap == null) {
            AnnotatedClass annotatedClass = this;
            synchronized (annotatedClass) {
                annotationMap = this._classAnnotations;
                if (annotationMap == null) {
                    this._classAnnotations = annotationMap = this._resolveClassAnnotations();
                }
            }
        }
        return annotationMap;
    }

    private AnnotationMap _resolveClassAnnotations() {
        AnnotationMap annotationMap = new AnnotationMap();
        if (this._annotationIntrospector != null) {
            if (this._primaryMixIn != null) {
                this._addClassMixIns(annotationMap, this._class, this._primaryMixIn);
            }
            this._addAnnotationsIfNotPresent(annotationMap, ClassUtil.findClassAnnotations(this._class));
            for (JavaType javaType : this._superTypes) {
                this._addClassMixIns(annotationMap, javaType);
                this._addAnnotationsIfNotPresent(annotationMap, ClassUtil.findClassAnnotations(javaType.getRawClass()));
            }
            this._addClassMixIns(annotationMap, Object.class);
        }
        return annotationMap;
    }

    private void resolveCreators() {
        Object object;
        AnnotatedClass annotatedClass = this;
        ArrayList<AnnotatedConstructor> arrayList = null;
        if (!this._type.isEnumType()) {
            object = ClassUtil.getConstructors(this._class);
            for (ClassUtil.Ctor object2 : object) {
                if (!this._isIncludableConstructor(object2.getConstructor())) continue;
                if (object2.getParamCount() == 0) {
                    this._defaultConstructor = this._constructDefaultConstructor(object2, annotatedClass);
                    continue;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<AnnotatedConstructor>(Math.max(10, ((ClassUtil.Ctor[])object).length));
                }
                arrayList.add(this._constructNonDefaultConstructor(object2, annotatedClass));
            }
        }
        this._constructors = arrayList == null ? Collections.emptyList() : arrayList;
        if (!(this._primaryMixIn == null || this._defaultConstructor == null && this._constructors.isEmpty())) {
            this._addConstructorMixIns(this._primaryMixIn);
        }
        if (this._annotationIntrospector != null) {
            if (this._defaultConstructor != null && this._annotationIntrospector.hasIgnoreMarker(this._defaultConstructor)) {
                this._defaultConstructor = null;
            }
            if (this._constructors != null) {
                int n = this._constructors.size();
                while (--n >= 0) {
                    if (!this._annotationIntrospector.hasIgnoreMarker(this._constructors.get(n))) continue;
                    this._constructors.remove(n);
                }
            }
        }
        object = null;
        for (Method method : this._findClassMethods(this._class)) {
            if (!Modifier.isStatic(method.getModifiers())) continue;
            if (object == null) {
                object = new ArrayList(8);
            }
            object.add(this._constructCreatorMethod(method, annotatedClass));
        }
        if (object == null) {
            this._creatorMethods = Collections.emptyList();
        } else {
            this._creatorMethods = object;
            if (this._primaryMixIn != null) {
                this._addFactoryMixIns(this._primaryMixIn);
            }
            if (this._annotationIntrospector != null) {
                int n = this._creatorMethods.size();
                while (--n >= 0) {
                    if (!this._annotationIntrospector.hasIgnoreMarker(this._creatorMethods.get(n))) continue;
                    this._creatorMethods.remove(n);
                }
            }
        }
        this._creatorsResolved = true;
    }

    private void resolveMemberMethods() {
        GenericDeclaration genericDeclaration;
        this._memberMethods = new AnnotatedMethodMap();
        AnnotatedMethodMap annotatedMethodMap = new AnnotatedMethodMap();
        this._addMemberMethods(this._class, this, this._memberMethods, this._primaryMixIn, annotatedMethodMap);
        Iterator<AnnotatedMethod> iterator = this._superTypes.iterator();
        while (iterator.hasNext()) {
            Serializable serializable = iterator.next();
            genericDeclaration = this._mixInResolver == null ? null : this._mixInResolver.findMixInClassFor(((JavaType)serializable).getRawClass());
            this._addMemberMethods(((JavaType)serializable).getRawClass(), new TypeResolutionContext.Basic(this._typeFactory, ((JavaType)serializable).getBindings()), this._memberMethods, (Class<?>)genericDeclaration, annotatedMethodMap);
        }
        if (this._mixInResolver != null && (iterator = this._mixInResolver.findMixInClassFor(Object.class)) != null) {
            this._addMethodMixIns(this._class, this._memberMethods, (Class<?>)((Object)iterator), annotatedMethodMap);
        }
        if (this._annotationIntrospector != null && !annotatedMethodMap.isEmpty()) {
            for (Serializable serializable : annotatedMethodMap) {
                try {
                    genericDeclaration = Object.class.getDeclaredMethod(((AnnotatedMethod)serializable).getName(), ((AnnotatedMethod)serializable).getRawParameterTypes());
                    if (genericDeclaration == null) continue;
                    AnnotatedMethod annotatedMethod = this._constructMethod((Method)genericDeclaration, this);
                    this._addMixOvers(((AnnotatedMethod)serializable).getAnnotated(), annotatedMethod, false);
                    this._memberMethods.add(annotatedMethod);
                }
                catch (Exception exception) {}
            }
        }
    }

    private void resolveFields() {
        Map<String, AnnotatedField> map = this._findFields(this._type, this, null);
        if (map == null || map.size() == 0) {
            this._fields = Collections.emptyList();
        } else {
            this._fields = new ArrayList<AnnotatedField>(map.size());
            this._fields.addAll(map.values());
        }
    }

    protected void _addClassMixIns(AnnotationMap annotationMap, JavaType javaType) {
        if (this._mixInResolver != null) {
            Class<?> clazz = javaType.getRawClass();
            this._addClassMixIns(annotationMap, clazz, this._mixInResolver.findMixInClassFor(clazz));
        }
    }

    protected void _addClassMixIns(AnnotationMap annotationMap, Class<?> clazz) {
        if (this._mixInResolver != null) {
            this._addClassMixIns(annotationMap, clazz, this._mixInResolver.findMixInClassFor(clazz));
        }
    }

    protected void _addClassMixIns(AnnotationMap annotationMap, Class<?> clazz, Class<?> clazz2) {
        if (clazz2 == null) {
            return;
        }
        this._addAnnotationsIfNotPresent(annotationMap, ClassUtil.findClassAnnotations(clazz2));
        for (Class<?> clazz3 : ClassUtil.findSuperClasses(clazz2, clazz, false)) {
            this._addAnnotationsIfNotPresent(annotationMap, ClassUtil.findClassAnnotations(clazz3));
        }
    }

    protected void _addConstructorMixIns(Class<?> clazz) {
        MemberKey[] memberKeyArray = null;
        int n = this._constructors == null ? 0 : this._constructors.size();
        block0: for (ClassUtil.Ctor ctor : ClassUtil.getConstructors(clazz)) {
            Constructor<?> constructor = ctor.getConstructor();
            if (constructor.getParameterTypes().length == 0) {
                if (this._defaultConstructor == null) continue;
                this._addMixOvers(constructor, this._defaultConstructor, false);
                continue;
            }
            if (memberKeyArray == null) {
                memberKeyArray = new MemberKey[n];
                for (int i = 0; i < n; ++i) {
                    memberKeyArray[i] = new MemberKey((Constructor<?>)this._constructors.get(i).getAnnotated());
                }
            }
            MemberKey memberKey = new MemberKey(constructor);
            for (int i = 0; i < n; ++i) {
                if (!memberKey.equals(memberKeyArray[i])) continue;
                this._addMixOvers(constructor, this._constructors.get(i), true);
                continue block0;
            }
        }
    }

    protected void _addFactoryMixIns(Class<?> clazz) {
        MemberKey[] memberKeyArray = null;
        int n = this._creatorMethods.size();
        block0: for (Method method : ClassUtil.getDeclaredMethods(clazz)) {
            if (!Modifier.isStatic(method.getModifiers()) || method.getParameterTypes().length == 0) continue;
            if (memberKeyArray == null) {
                memberKeyArray = new MemberKey[n];
                for (int i = 0; i < n; ++i) {
                    memberKeyArray[i] = new MemberKey(this._creatorMethods.get(i).getAnnotated());
                }
            }
            MemberKey memberKey = new MemberKey(method);
            for (int i = 0; i < n; ++i) {
                if (!memberKey.equals(memberKeyArray[i])) continue;
                this._addMixOvers(method, this._creatorMethods.get(i), true);
                continue block0;
            }
        }
    }

    protected void _addMemberMethods(Class<?> clazz, TypeResolutionContext typeResolutionContext, AnnotatedMethodMap annotatedMethodMap, Class<?> clazz2, AnnotatedMethodMap annotatedMethodMap2) {
        if (clazz2 != null) {
            this._addMethodMixIns(clazz, annotatedMethodMap, clazz2, annotatedMethodMap2);
        }
        if (clazz == null) {
            return;
        }
        for (Method method : this._findClassMethods(clazz)) {
            if (!this._isIncludableMemberMethod(method)) continue;
            AnnotatedMethod annotatedMethod = annotatedMethodMap.find(method);
            if (annotatedMethod == null) {
                AnnotatedMethod annotatedMethod2 = this._constructMethod(method, typeResolutionContext);
                annotatedMethodMap.add(annotatedMethod2);
                annotatedMethod = annotatedMethodMap2.remove(method);
                if (annotatedMethod == null) continue;
                this._addMixOvers(annotatedMethod.getAnnotated(), annotatedMethod2, false);
                continue;
            }
            this._addMixUnders(method, annotatedMethod);
            if (!annotatedMethod.getDeclaringClass().isInterface() || method.getDeclaringClass().isInterface()) continue;
            annotatedMethodMap.add(annotatedMethod.withMethod(method));
        }
    }

    protected void _addMethodMixIns(Class<?> clazz, AnnotatedMethodMap annotatedMethodMap, Class<?> clazz2, AnnotatedMethodMap annotatedMethodMap2) {
        List<Class<?>> list = ClassUtil.findRawSuperTypes(clazz2, clazz, true);
        for (Class<?> clazz3 : list) {
            for (Method method : ClassUtil.getDeclaredMethods(clazz3)) {
                if (!this._isIncludableMemberMethod(method)) continue;
                AnnotatedMethod annotatedMethod = annotatedMethodMap.find(method);
                if (annotatedMethod != null) {
                    this._addMixUnders(method, annotatedMethod);
                    continue;
                }
                annotatedMethod = annotatedMethodMap2.find(method);
                if (annotatedMethod != null) {
                    this._addMixUnders(method, annotatedMethod);
                    continue;
                }
                annotatedMethodMap2.add(this._constructMethod(method, this));
            }
        }
    }

    protected Map<String, AnnotatedField> _findFields(JavaType javaType, TypeResolutionContext typeResolutionContext, Map<String, AnnotatedField> map) {
        JavaType javaType2 = javaType.getSuperClass();
        if (javaType2 != null) {
            Class<?> clazz = javaType.getRawClass();
            map = this._findFields(javaType2, new TypeResolutionContext.Basic(this._typeFactory, javaType2.getBindings()), map);
            Object object = ClassUtil.getDeclaredFields(clazz);
            int n = ((Field[])object).length;
            for (int i = 0; i < n; ++i) {
                Field field = object[i];
                if (!this._isIncludableField(field)) continue;
                if (map == null) {
                    map = new LinkedHashMap<String, AnnotatedField>();
                }
                map.put(field.getName(), this._constructField(field, typeResolutionContext));
            }
            if (this._mixInResolver != null && (object = this._mixInResolver.findMixInClassFor(clazz)) != null) {
                this._addFieldMixIns((Class<?>)object, clazz, map);
            }
        }
        return map;
    }

    protected void _addFieldMixIns(Class<?> clazz, Class<?> clazz2, Map<String, AnnotatedField> map) {
        List<Class<?>> list = ClassUtil.findSuperClasses(clazz, clazz2, true);
        for (Class<?> clazz3 : list) {
            for (Field field : ClassUtil.getDeclaredFields(clazz3)) {
                String string;
                AnnotatedField annotatedField;
                if (!this._isIncludableField(field) || (annotatedField = map.get(string = field.getName())) == null) continue;
                this._addOrOverrideAnnotations(annotatedField, field.getDeclaredAnnotations());
            }
        }
    }

    protected AnnotatedMethod _constructMethod(Method method, TypeResolutionContext typeResolutionContext) {
        if (this._annotationIntrospector == null) {
            return new AnnotatedMethod(typeResolutionContext, method, this._emptyAnnotationMap(), null);
        }
        return new AnnotatedMethod(typeResolutionContext, method, this._collectRelevantAnnotations(method.getDeclaredAnnotations()), null);
    }

    protected AnnotatedConstructor _constructDefaultConstructor(ClassUtil.Ctor ctor, TypeResolutionContext typeResolutionContext) {
        if (this._annotationIntrospector == null) {
            return new AnnotatedConstructor(typeResolutionContext, ctor.getConstructor(), this._emptyAnnotationMap(), NO_ANNOTATION_MAPS);
        }
        return new AnnotatedConstructor(typeResolutionContext, ctor.getConstructor(), this._collectRelevantAnnotations(ctor.getDeclaredAnnotations()), NO_ANNOTATION_MAPS);
    }

    protected AnnotatedConstructor _constructNonDefaultConstructor(ClassUtil.Ctor ctor, TypeResolutionContext typeResolutionContext) {
        AnnotationMap[] annotationMapArray;
        int n = ctor.getParamCount();
        if (this._annotationIntrospector == null) {
            return new AnnotatedConstructor(typeResolutionContext, ctor.getConstructor(), this._emptyAnnotationMap(), this._emptyAnnotationMaps(n));
        }
        if (n == 0) {
            return new AnnotatedConstructor(typeResolutionContext, ctor.getConstructor(), this._collectRelevantAnnotations(ctor.getDeclaredAnnotations()), NO_ANNOTATION_MAPS);
        }
        Annotation[][] annotationArray = ctor.getParameterAnnotations();
        if (n != annotationArray.length) {
            annotationMapArray = null;
            Class<?> clazz = ctor.getDeclaringClass();
            if (clazz.isEnum() && n == annotationArray.length + 2) {
                Annotation[][] annotationArray2 = annotationArray;
                annotationArray = new Annotation[annotationArray2.length + 2][];
                System.arraycopy(annotationArray2, 0, annotationArray, 2, annotationArray2.length);
                annotationMapArray = this._collectRelevantAnnotations(annotationArray);
            } else if (clazz.isMemberClass() && n == annotationArray.length + 1) {
                Annotation[][] annotationArray3 = annotationArray;
                annotationArray = new Annotation[annotationArray3.length + 1][];
                System.arraycopy(annotationArray3, 0, annotationArray, 1, annotationArray3.length);
                annotationMapArray = this._collectRelevantAnnotations(annotationArray);
            }
            if (annotationMapArray == null) {
                throw new IllegalStateException("Internal error: constructor for " + ctor.getDeclaringClass().getName() + " has mismatch: " + n + " parameters; " + annotationArray.length + " sets of annotations");
            }
        } else {
            annotationMapArray = this._collectRelevantAnnotations(annotationArray);
        }
        return new AnnotatedConstructor(typeResolutionContext, ctor.getConstructor(), this._collectRelevantAnnotations(ctor.getDeclaredAnnotations()), annotationMapArray);
    }

    protected AnnotatedMethod _constructCreatorMethod(Method method, TypeResolutionContext typeResolutionContext) {
        int n = method.getParameterTypes().length;
        if (this._annotationIntrospector == null) {
            return new AnnotatedMethod(typeResolutionContext, method, this._emptyAnnotationMap(), this._emptyAnnotationMaps(n));
        }
        if (n == 0) {
            return new AnnotatedMethod(typeResolutionContext, method, this._collectRelevantAnnotations(method.getDeclaredAnnotations()), NO_ANNOTATION_MAPS);
        }
        return new AnnotatedMethod(typeResolutionContext, method, this._collectRelevantAnnotations(method.getDeclaredAnnotations()), this._collectRelevantAnnotations(method.getParameterAnnotations()));
    }

    protected AnnotatedField _constructField(Field field, TypeResolutionContext typeResolutionContext) {
        if (this._annotationIntrospector == null) {
            return new AnnotatedField(typeResolutionContext, field, this._emptyAnnotationMap());
        }
        return new AnnotatedField(typeResolutionContext, field, this._collectRelevantAnnotations(field.getDeclaredAnnotations()));
    }

    private AnnotationMap _emptyAnnotationMap() {
        return new AnnotationMap();
    }

    private AnnotationMap[] _emptyAnnotationMaps(int n) {
        if (n == 0) {
            return NO_ANNOTATION_MAPS;
        }
        AnnotationMap[] annotationMapArray = new AnnotationMap[n];
        for (int i = 0; i < n; ++i) {
            annotationMapArray[i] = this._emptyAnnotationMap();
        }
        return annotationMapArray;
    }

    protected boolean _isIncludableMemberMethod(Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        if (method.isSynthetic() || method.isBridge()) {
            return false;
        }
        int n = method.getParameterTypes().length;
        return n <= 2;
    }

    private boolean _isIncludableField(Field field) {
        if (field.isSynthetic()) {
            return false;
        }
        int n = field.getModifiers();
        return !Modifier.isStatic(n);
    }

    private boolean _isIncludableConstructor(Constructor<?> constructor) {
        return !constructor.isSynthetic();
    }

    protected AnnotationMap[] _collectRelevantAnnotations(Annotation[][] annotationArray) {
        int n = annotationArray.length;
        AnnotationMap[] annotationMapArray = new AnnotationMap[n];
        for (int i = 0; i < n; ++i) {
            annotationMapArray[i] = this._collectRelevantAnnotations(annotationArray[i]);
        }
        return annotationMapArray;
    }

    protected AnnotationMap _collectRelevantAnnotations(Annotation[] annotationArray) {
        return this._addAnnotationsIfNotPresent(new AnnotationMap(), annotationArray);
    }

    private AnnotationMap _addAnnotationsIfNotPresent(AnnotationMap annotationMap, Annotation[] annotationArray) {
        if (annotationArray != null) {
            List<Annotation> list = null;
            for (Annotation annotation : annotationArray) {
                boolean bl = annotationMap.addIfNotPresent(annotation);
                if (!bl || !this._isAnnotationBundle(annotation)) continue;
                list = this._addFromBundle(annotation, list);
            }
            if (list != null) {
                this._addAnnotationsIfNotPresent(annotationMap, list.toArray(new Annotation[list.size()]));
            }
        }
        return annotationMap;
    }

    private List<Annotation> _addFromBundle(Annotation annotation, List<Annotation> list) {
        for (Annotation annotation2 : ClassUtil.findClassAnnotations(annotation.annotationType())) {
            if (annotation2 instanceof Target || annotation2 instanceof Retention) continue;
            if (list == null) {
                list = new ArrayList<Annotation>();
            }
            list.add(annotation2);
        }
        return list;
    }

    private void _addAnnotationsIfNotPresent(AnnotatedMember annotatedMember, Annotation[] annotationArray) {
        if (annotationArray != null) {
            List<Annotation> list = null;
            for (Annotation annotation : annotationArray) {
                boolean bl = annotatedMember.addIfNotPresent(annotation);
                if (!bl || !this._isAnnotationBundle(annotation)) continue;
                list = this._addFromBundle(annotation, list);
            }
            if (list != null) {
                this._addAnnotationsIfNotPresent(annotatedMember, list.toArray(new Annotation[list.size()]));
            }
        }
    }

    private void _addOrOverrideAnnotations(AnnotatedMember annotatedMember, Annotation[] annotationArray) {
        if (annotationArray != null) {
            List<Annotation> list = null;
            for (Annotation annotation : annotationArray) {
                boolean bl = annotatedMember.addOrOverride(annotation);
                if (!bl || !this._isAnnotationBundle(annotation)) continue;
                list = this._addFromBundle(annotation, list);
            }
            if (list != null) {
                this._addOrOverrideAnnotations(annotatedMember, list.toArray(new Annotation[list.size()]));
            }
        }
    }

    protected void _addMixOvers(Constructor<?> constructor, AnnotatedConstructor annotatedConstructor, boolean bl) {
        this._addOrOverrideAnnotations(annotatedConstructor, constructor.getDeclaredAnnotations());
        if (bl) {
            Annotation[][] annotationArray = constructor.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                for (Annotation annotation : annotationArray[i]) {
                    annotatedConstructor.addOrOverrideParam(i, annotation);
                }
            }
        }
    }

    protected void _addMixOvers(Method method, AnnotatedMethod annotatedMethod, boolean bl) {
        this._addOrOverrideAnnotations(annotatedMethod, method.getDeclaredAnnotations());
        if (bl) {
            Annotation[][] annotationArray = method.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                for (Annotation annotation : annotationArray[i]) {
                    annotatedMethod.addOrOverrideParam(i, annotation);
                }
            }
        }
    }

    protected void _addMixUnders(Method method, AnnotatedMethod annotatedMethod) {
        this._addAnnotationsIfNotPresent(annotatedMethod, method.getDeclaredAnnotations());
    }

    private final boolean _isAnnotationBundle(Annotation annotation) {
        return this._annotationIntrospector != null && this._annotationIntrospector.isAnnotationBundle(annotation);
    }

    protected Method[] _findClassMethods(Class<?> clazz) {
        try {
            return ClassUtil.getDeclaredMethods(clazz);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Class<?> clazz2;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                throw noClassDefFoundError;
            }
            try {
                clazz2 = classLoader.loadClass(clazz.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw noClassDefFoundError;
            }
            return clazz2.getDeclaredMethods();
        }
    }

    @Override
    public String toString() {
        return "[AnnotedClass " + this._class.getName() + "]";
    }

    @Override
    public int hashCode() {
        return this._class.getName().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return ((AnnotatedClass)object)._class == this._class;
    }
}

