/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ext;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.deser.Deserializers;
import com.fasterxml.jackson.databind.ext.Java7Support;
import com.fasterxml.jackson.databind.ser.Serializers;
import java.io.Serializable;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class OptionalHandlerFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String PACKAGE_PREFIX_JAVAX_XML = "javax.xml.";
    private static final String SERIALIZERS_FOR_JAVAX_XML = "com.fasterxml.jackson.databind.ext.CoreXMLSerializers";
    private static final String DESERIALIZERS_FOR_JAVAX_XML = "com.fasterxml.jackson.databind.ext.CoreXMLDeserializers";
    private static final String SERIALIZER_FOR_DOM_NODE = "com.fasterxml.jackson.databind.ext.DOMSerializer";
    private static final String DESERIALIZER_FOR_DOM_DOCUMENT = "com.fasterxml.jackson.databind.ext.DOMDeserializer$DocumentDeserializer";
    private static final String DESERIALIZER_FOR_DOM_NODE = "com.fasterxml.jackson.databind.ext.DOMDeserializer$NodeDeserializer";
    private static final Class<?> CLASS_DOM_NODE;
    private static final Class<?> CLASS_DOM_DOCUMENT;
    private static final Java7Support _jdk7Helper;
    public static final OptionalHandlerFactory instance;

    protected OptionalHandlerFactory() {
    }

    public JsonSerializer<?> findSerializer(SerializationConfig serializationConfig, JavaType javaType, BeanDescription beanDescription) {
        Object object;
        Class<?> clazz = javaType.getRawClass();
        if (_jdk7Helper != null && (object = _jdk7Helper.getSerializerForJavaNioFilePath(clazz)) != null) {
            return object;
        }
        if (CLASS_DOM_NODE != null && CLASS_DOM_NODE.isAssignableFrom(clazz)) {
            return (JsonSerializer)this.instantiate(SERIALIZER_FOR_DOM_NODE);
        }
        object = clazz.getName();
        if (!((String)object).startsWith(PACKAGE_PREFIX_JAVAX_XML) && !this.hasSuperClassStartingWith(clazz, PACKAGE_PREFIX_JAVAX_XML)) {
            return null;
        }
        String string = SERIALIZERS_FOR_JAVAX_XML;
        Object object2 = this.instantiate(string);
        if (object2 == null) {
            return null;
        }
        return ((Serializers)object2).findSerializer(serializationConfig, javaType, beanDescription);
    }

    public JsonDeserializer<?> findDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, BeanDescription beanDescription) throws JsonMappingException {
        Object object;
        Class<?> clazz = javaType.getRawClass();
        if (_jdk7Helper != null && (object = _jdk7Helper.getDeserializerForJavaNioFilePath(clazz)) != null) {
            return object;
        }
        if (CLASS_DOM_NODE != null && CLASS_DOM_NODE.isAssignableFrom(clazz)) {
            return (JsonDeserializer)this.instantiate(DESERIALIZER_FOR_DOM_NODE);
        }
        if (CLASS_DOM_DOCUMENT != null && CLASS_DOM_DOCUMENT.isAssignableFrom(clazz)) {
            return (JsonDeserializer)this.instantiate(DESERIALIZER_FOR_DOM_DOCUMENT);
        }
        object = clazz.getName();
        if (!((String)object).startsWith(PACKAGE_PREFIX_JAVAX_XML) && !this.hasSuperClassStartingWith(clazz, PACKAGE_PREFIX_JAVAX_XML)) {
            return null;
        }
        String string = DESERIALIZERS_FOR_JAVAX_XML;
        Object object2 = this.instantiate(string);
        if (object2 == null) {
            return null;
        }
        return ((Deserializers)object2).findBeanDeserializer(javaType, deserializationConfig, beanDescription);
    }

    private Object instantiate(String string) {
        try {
            return Class.forName(string).newInstance();
        }
        catch (LinkageError linkageError) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean hasSuperClassStartingWith(Class<?> clazz, String string) {
        for (Class<?> clazz2 = clazz.getSuperclass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            if (clazz2 == Object.class) {
                return false;
            }
            if (!clazz2.getName().startsWith(string)) continue;
            return true;
        }
        return false;
    }

    static {
        Object object = null;
        Class<Node> clazz = null;
        try {
            clazz = Node.class;
            object = Document.class;
        }
        catch (Exception exception) {
            System.err.println("WARNING: could not load DOM Node and/or Document classes");
        }
        CLASS_DOM_NODE = clazz;
        CLASS_DOM_DOCUMENT = object;
        object = null;
        try {
            object = Java7Support.instance();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        _jdk7Helper = object;
        instance = new OptionalHandlerFactory();
    }
}

