/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.util.Collection;

@JacksonStdImpl
public final class StringCollectionDeserializer
extends ContainerDeserializerBase<Collection<String>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JavaType _collectionType;
    protected final JsonDeserializer<String> _valueDeserializer;
    protected final ValueInstantiator _valueInstantiator;
    protected final JsonDeserializer<Object> _delegateDeserializer;
    protected final Boolean _unwrapSingle;

    public StringCollectionDeserializer(JavaType javaType, JsonDeserializer<?> jsonDeserializer, ValueInstantiator valueInstantiator) {
        this(javaType, valueInstantiator, null, jsonDeserializer, null);
    }

    protected StringCollectionDeserializer(JavaType javaType, ValueInstantiator valueInstantiator, JsonDeserializer<?> jsonDeserializer, JsonDeserializer<?> jsonDeserializer2, Boolean bl) {
        super(javaType);
        this._collectionType = javaType;
        this._valueDeserializer = jsonDeserializer2;
        this._valueInstantiator = valueInstantiator;
        this._delegateDeserializer = jsonDeserializer;
        this._unwrapSingle = bl;
    }

    protected StringCollectionDeserializer withResolved(JsonDeserializer<?> jsonDeserializer, JsonDeserializer<?> jsonDeserializer2, Boolean bl) {
        if (this._unwrapSingle == bl && this._valueDeserializer == jsonDeserializer2 && this._delegateDeserializer == jsonDeserializer) {
            return this;
        }
        return new StringCollectionDeserializer(this._collectionType, this._valueInstantiator, jsonDeserializer, jsonDeserializer2, bl);
    }

    @Override
    public boolean isCachable() {
        return this._valueDeserializer == null && this._delegateDeserializer == null;
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        JavaType javaType;
        JsonDeserializer<Object> jsonDeserializer;
        JsonDeserializer<Object> jsonDeserializer2 = null;
        if (this._valueInstantiator != null && (jsonDeserializer = this._valueInstantiator.getDelegateCreator()) != null) {
            javaType = this._valueInstantiator.getDelegateType(deserializationContext.getConfig());
            jsonDeserializer2 = this.findDeserializer(deserializationContext, javaType, beanProperty);
        }
        jsonDeserializer = this._valueDeserializer;
        javaType = this._collectionType.getContentType();
        if (jsonDeserializer == null) {
            if ((jsonDeserializer = this.findConvertingContentDeserializer(deserializationContext, beanProperty, jsonDeserializer)) == null) {
                jsonDeserializer = deserializationContext.findContextualValueDeserializer(javaType, beanProperty);
            }
        } else {
            jsonDeserializer = deserializationContext.handleSecondaryContextualization(jsonDeserializer, beanProperty, javaType);
        }
        Boolean bl = this.findFormatFeature(deserializationContext, beanProperty, Collection.class, JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (this.isDefaultDeserializer(jsonDeserializer)) {
            jsonDeserializer = null;
        }
        return this.withResolved(jsonDeserializer2, jsonDeserializer, bl);
    }

    @Override
    public JavaType getContentType() {
        return this._collectionType.getContentType();
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        return jsonDeserializer;
    }

    @Override
    public Collection<String> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (this._delegateDeserializer != null) {
            return (Collection)this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        Collection collection = (Collection)this._valueInstantiator.createUsingDefault(deserializationContext);
        return this.deserialize(jsonParser, deserializationContext, collection);
    }

    @Override
    public Collection<String> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<String> collection) throws IOException {
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext, collection);
        }
        if (this._valueDeserializer != null) {
            return this.deserializeUsingCustom(jsonParser, deserializationContext, collection, this._valueDeserializer);
        }
        try {
            while (true) {
                String string;
                if ((string = jsonParser.nextTextValue()) != null) {
                    collection.add(string);
                    continue;
                }
                JsonToken jsonToken = jsonParser.getCurrentToken();
                if (jsonToken != JsonToken.END_ARRAY) {
                    if (jsonToken != JsonToken.VALUE_NULL) {
                        string = this._parseString(jsonParser, deserializationContext);
                    }
                    collection.add(string);
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            throw JsonMappingException.wrapWithPath((Throwable)exception, collection, collection.size());
        }
        return collection;
    }

    private Collection<String> deserializeUsingCustom(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<String> collection, JsonDeserializer<String> jsonDeserializer) throws IOException {
        while (true) {
            String string;
            if (jsonParser.nextTextValue() == null) {
                JsonToken jsonToken = jsonParser.getCurrentToken();
                if (jsonToken == JsonToken.END_ARRAY) break;
                string = jsonToken == JsonToken.VALUE_NULL ? jsonDeserializer.getNullValue(deserializationContext) : jsonDeserializer.deserialize(jsonParser, deserializationContext);
            } else {
                string = jsonDeserializer.deserialize(jsonParser, deserializationContext);
            }
            collection.add(string);
        }
        return collection;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    private final Collection<String> handleNonArray(JsonParser jsonParser, DeserializationContext deserializationContext, Collection<String> collection) throws IOException {
        boolean bl;
        boolean bl2 = bl = this._unwrapSingle == Boolean.TRUE || this._unwrapSingle == null && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (!bl) {
            return (Collection)deserializationContext.handleUnexpectedToken(this._collectionType.getRawClass(), jsonParser);
        }
        JsonDeserializer<String> jsonDeserializer = this._valueDeserializer;
        JsonToken jsonToken = jsonParser.getCurrentToken();
        String string = jsonToken == JsonToken.VALUE_NULL ? (jsonDeserializer == null ? null : jsonDeserializer.getNullValue(deserializationContext)) : (jsonDeserializer == null ? this._parseString(jsonParser, deserializationContext) : jsonDeserializer.deserialize(jsonParser, deserializationContext));
        collection.add(string);
        return collection;
    }
}

