/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.AggregateFutureState;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@GwtCompatible
abstract class AggregateFuture<InputT, OutputT>
extends AbstractFuture.TrustedFuture<OutputT> {
    private static final Logger logger = Logger.getLogger(AggregateFuture.class.getName());
    private RunningState runningState;

    AggregateFuture() {
    }

    @Override
    final void done() {
        super.done();
        this.runningState = null;
    }

    @Override
    public final boolean cancel(boolean bl) {
        RunningState runningState = this.runningState;
        ImmutableCollection immutableCollection = runningState != null ? runningState.futures : null;
        boolean bl2 = super.cancel(bl);
        if (bl2 & immutableCollection != null) {
            for (ListenableFuture listenableFuture : immutableCollection) {
                listenableFuture.cancel(bl);
            }
        }
        return bl2;
    }

    @Override
    @GwtIncompatible(value="Interruption not supported")
    protected final void interruptTask() {
        RunningState runningState = this.runningState;
        if (runningState != null) {
            runningState.interruptTask();
        }
    }

    final void init(RunningState runningState) {
        this.runningState = runningState;
        runningState.init();
    }

    private static boolean addCausalChain(Set<Throwable> set, Throwable throwable) {
        while (throwable != null) {
            boolean bl = set.add(throwable);
            if (!bl) {
                return false;
            }
            throwable = throwable.getCause();
        }
        return true;
    }

    abstract class RunningState
    extends AggregateFutureState
    implements Runnable {
        private ImmutableCollection<? extends ListenableFuture<? extends InputT>> futures;
        private final boolean allMustSucceed;
        private final boolean collectsValues;

        RunningState(ImmutableCollection<? extends ListenableFuture<? extends InputT>> immutableCollection, boolean bl, boolean bl2) {
            super(immutableCollection.size());
            this.futures = Preconditions.checkNotNull(immutableCollection);
            this.allMustSucceed = bl;
            this.collectsValues = bl2;
        }

        @Override
        public final void run() {
            this.decrementCountAndMaybeComplete();
        }

        private void init() {
            if (this.futures.isEmpty()) {
                this.handleAllCompleted();
                return;
            }
            if (this.allMustSucceed) {
                int n = 0;
                for (final ListenableFuture listenableFuture : this.futures) {
                    final int n2 = n++;
                    listenableFuture.addListener(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                RunningState.this.handleOneInputDone(n2, listenableFuture);
                            }
                            finally {
                                RunningState.this.decrementCountAndMaybeComplete();
                            }
                        }
                    }, MoreExecutors.directExecutor());
                }
            } else {
                for (ListenableFuture listenableFuture : this.futures) {
                    listenableFuture.addListener(this, MoreExecutors.directExecutor());
                }
            }
        }

        private void handleException(Throwable throwable) {
            Preconditions.checkNotNull(throwable);
            boolean bl = false;
            boolean bl2 = true;
            if (this.allMustSucceed) {
                bl = AggregateFuture.this.setException(throwable);
                if (bl) {
                    this.releaseResourcesAfterFailure();
                } else {
                    bl2 = AggregateFuture.addCausalChain(this.getOrInitSeenExceptions(), throwable);
                }
            }
            if (throwable instanceof Error | this.allMustSucceed & !bl & bl2) {
                String string = throwable instanceof Error ? "Input Future failed with Error" : "Got more than one input Future failure. Logging failures after the first";
                logger.log(Level.SEVERE, string, throwable);
            }
        }

        @Override
        final void addInitialException(Set<Throwable> set) {
            if (!AggregateFuture.this.isCancelled()) {
                AggregateFuture.addCausalChain(set, AggregateFuture.this.trustedGetException());
            }
        }

        private void handleOneInputDone(int n, Future<? extends InputT> future) {
            Preconditions.checkState(this.allMustSucceed || !AggregateFuture.this.isDone() || AggregateFuture.this.isCancelled(), "Future was done before all dependencies completed");
            try {
                Preconditions.checkState(future.isDone(), "Tried to set value from future which is not done");
                if (this.allMustSucceed) {
                    if (future.isCancelled()) {
                        AggregateFuture.super.cancel(false);
                    } else {
                        Object InputT = Uninterruptibles.getUninterruptibly(future);
                        if (this.collectsValues) {
                            this.collectOneValue(this.allMustSucceed, n, InputT);
                        }
                    }
                } else if (this.collectsValues && !future.isCancelled()) {
                    this.collectOneValue(this.allMustSucceed, n, Uninterruptibles.getUninterruptibly(future));
                }
            }
            catch (ExecutionException executionException) {
                this.handleException(executionException.getCause());
            }
            catch (Throwable throwable) {
                this.handleException(throwable);
            }
        }

        private void decrementCountAndMaybeComplete() {
            int n = this.decrementRemainingAndGet();
            Preconditions.checkState(n >= 0, "Less than 0 remaining futures");
            if (n == 0) {
                this.processCompleted();
            }
        }

        private void processCompleted() {
            if (this.collectsValues & !this.allMustSucceed) {
                int n = 0;
                for (ListenableFuture listenableFuture : this.futures) {
                    this.handleOneInputDone(n++, listenableFuture);
                }
            }
            this.handleAllCompleted();
        }

        void releaseResourcesAfterFailure() {
            this.futures = null;
        }

        abstract void collectOneValue(boolean var1, int var2, @Nullable InputT var3);

        abstract void handleAllCompleted();

        void interruptTask() {
        }
    }
}

