/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.SubscriberExceptionContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

class Subscriber {
    private EventBus bus;
    @VisibleForTesting
    final Object target;
    private final Method method;
    private final Executor executor;

    static Subscriber create(EventBus eventBus, Object object, Method method) {
        return Subscriber.isDeclaredThreadSafe(method) ? new Subscriber(eventBus, object, method) : new SynchronizedSubscriber(eventBus, object, method);
    }

    private Subscriber(EventBus eventBus, Object object, Method method) {
        this.bus = eventBus;
        this.target = Preconditions.checkNotNull(object);
        this.method = method;
        method.setAccessible(true);
        this.executor = eventBus.executor();
    }

    final void dispatchEvent(final Object object) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    Subscriber.this.invokeSubscriberMethod(object);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Subscriber.this.bus.handleSubscriberException(invocationTargetException.getCause(), Subscriber.this.context(object));
                }
            }
        });
    }

    @VisibleForTesting
    void invokeSubscriberMethod(Object object) throws InvocationTargetException {
        try {
            this.method.invoke(this.target, Preconditions.checkNotNull(object));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Error("Method rejected target/argument: " + object, illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("Method became inaccessible: " + object, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getCause() instanceof Error) {
                throw (Error)invocationTargetException.getCause();
            }
            throw invocationTargetException;
        }
    }

    private SubscriberExceptionContext context(Object object) {
        return new SubscriberExceptionContext(this.bus, object, this.target, this.method);
    }

    public final int hashCode() {
        return (31 + this.method.hashCode()) * 31 + System.identityHashCode(this.target);
    }

    public final boolean equals(@Nullable Object object) {
        if (object instanceof Subscriber) {
            Subscriber subscriber = (Subscriber)object;
            return this.target == subscriber.target && this.method.equals(subscriber.method);
        }
        return false;
    }

    private static boolean isDeclaredThreadSafe(Method method) {
        return method.getAnnotation(AllowConcurrentEvents.class) != null;
    }

    @VisibleForTesting
    static final class SynchronizedSubscriber
    extends Subscriber {
        private SynchronizedSubscriber(EventBus eventBus, Object object, Method method) {
            super(eventBus, object, method);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void invokeSubscriberMethod(Object object) throws InvocationTargetException {
            SynchronizedSubscriber synchronizedSubscriber = this;
            synchronized (synchronizedSubscriber) {
                super.invokeSubscriberMethod(object);
            }
        }
    }
}

