/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.deflate;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.deflate.DeflateParameters;

public class DeflateCompressorInputStream
extends CompressorInputStream {
    private static final int MAGIC_1 = 120;
    private static final int MAGIC_2a = 1;
    private static final int MAGIC_2b = 94;
    private static final int MAGIC_2c = 156;
    private static final int MAGIC_2d = 218;
    private final InputStream in;
    private final Inflater inflater;

    public DeflateCompressorInputStream(InputStream inputStream) {
        this(inputStream, new DeflateParameters());
    }

    public DeflateCompressorInputStream(InputStream inputStream, DeflateParameters deflateParameters) {
        this.inflater = new Inflater(!deflateParameters.withZlibHeader());
        this.in = new InflaterInputStream(inputStream, this.inflater);
    }

    @Override
    public int read() throws IOException {
        int n = this.in.read();
        this.count(n == -1 ? 0 : 1);
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        this.count(n3);
        return n3;
    }

    @Override
    public long skip(long l) throws IOException {
        return this.in.skip(l);
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            this.inflater.end();
        }
    }

    public static boolean matches(byte[] byArray, int n) {
        return n > 3 && byArray[0] == 120 && (byArray[1] == 1 || byArray[1] == 94 || byArray[1] == -100 || byArray[1] == -38);
    }
}

