/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.zip;

import java.io.Closeable;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import org.apache.commons.compress.parallel.ScatterGatherBackingStore;

public abstract class StreamCompressor
implements Closeable {
    private static final int DEFLATER_BLOCK_SIZE = 8192;
    private final Deflater def;
    private final CRC32 crc = new CRC32();
    private long writtenToOutputStreamForLastEntry = 0L;
    private long sourcePayloadLength = 0L;
    private long totalWrittenToOutputStream = 0L;
    private static final int BUFFER_SIZE = 4096;
    private final byte[] outputBuffer = new byte[4096];
    private final byte[] readerBuf = new byte[4096];

    StreamCompressor(Deflater deflater) {
        this.def = deflater;
    }

    static StreamCompressor create(OutputStream outputStream, Deflater deflater) {
        return new OutputStreamCompressor(deflater, outputStream);
    }

    static StreamCompressor create(OutputStream outputStream) {
        return StreamCompressor.create(outputStream, new Deflater(-1, true));
    }

    static StreamCompressor create(DataOutput dataOutput, Deflater deflater) {
        return new DataOutputCompressor(deflater, dataOutput);
    }

    static StreamCompressor create(SeekableByteChannel seekableByteChannel, Deflater deflater) {
        return new SeekableByteChannelCompressor(deflater, seekableByteChannel);
    }

    public static StreamCompressor create(int n, ScatterGatherBackingStore scatterGatherBackingStore) {
        Deflater deflater = new Deflater(n, true);
        return new ScatterGatherBackingStoreCompressor(deflater, scatterGatherBackingStore);
    }

    public static StreamCompressor create(ScatterGatherBackingStore scatterGatherBackingStore) {
        return StreamCompressor.create(-1, scatterGatherBackingStore);
    }

    public long getCrc32() {
        return this.crc.getValue();
    }

    public long getBytesRead() {
        return this.sourcePayloadLength;
    }

    public long getBytesWrittenForLastEntry() {
        return this.writtenToOutputStreamForLastEntry;
    }

    public long getTotalBytesWritten() {
        return this.totalWrittenToOutputStream;
    }

    public void deflate(InputStream inputStream, int n) throws IOException {
        int n2;
        this.reset();
        while ((n2 = inputStream.read(this.readerBuf, 0, this.readerBuf.length)) >= 0) {
            this.write(this.readerBuf, 0, n2, n);
        }
        if (n == 8) {
            this.flushDeflater();
        }
    }

    long write(byte[] byArray, int n, int n2, int n3) throws IOException {
        long l = this.writtenToOutputStreamForLastEntry;
        this.crc.update(byArray, n, n2);
        if (n3 == 8) {
            this.writeDeflated(byArray, n, n2);
        } else {
            this.writeCounted(byArray, n, n2);
        }
        this.sourcePayloadLength += (long)n2;
        return this.writtenToOutputStreamForLastEntry - l;
    }

    void reset() {
        this.crc.reset();
        this.def.reset();
        this.sourcePayloadLength = 0L;
        this.writtenToOutputStreamForLastEntry = 0L;
    }

    @Override
    public void close() throws IOException {
        this.def.end();
    }

    void flushDeflater() throws IOException {
        this.def.finish();
        while (!this.def.finished()) {
            this.deflate();
        }
    }

    private void writeDeflated(byte[] byArray, int n, int n2) throws IOException {
        if (n2 > 0 && !this.def.finished()) {
            if (n2 <= 8192) {
                this.def.setInput(byArray, n, n2);
                this.deflateUntilInputIsNeeded();
            } else {
                int n3;
                int n4 = n2 / 8192;
                for (n3 = 0; n3 < n4; ++n3) {
                    this.def.setInput(byArray, n + n3 * 8192, 8192);
                    this.deflateUntilInputIsNeeded();
                }
                n3 = n4 * 8192;
                if (n3 < n2) {
                    this.def.setInput(byArray, n + n3, n2 - n3);
                    this.deflateUntilInputIsNeeded();
                }
            }
        }
    }

    private void deflateUntilInputIsNeeded() throws IOException {
        while (!this.def.needsInput()) {
            this.deflate();
        }
    }

    void deflate() throws IOException {
        int n = this.def.deflate(this.outputBuffer, 0, this.outputBuffer.length);
        if (n > 0) {
            this.writeCounted(this.outputBuffer, 0, n);
        }
    }

    public void writeCounted(byte[] byArray) throws IOException {
        this.writeCounted(byArray, 0, byArray.length);
    }

    public void writeCounted(byte[] byArray, int n, int n2) throws IOException {
        this.writeOut(byArray, n, n2);
        this.writtenToOutputStreamForLastEntry += (long)n2;
        this.totalWrittenToOutputStream += (long)n2;
    }

    protected abstract void writeOut(byte[] var1, int var2, int var3) throws IOException;

    private static final class SeekableByteChannelCompressor
    extends StreamCompressor {
        private final SeekableByteChannel channel;

        public SeekableByteChannelCompressor(Deflater deflater, SeekableByteChannel seekableByteChannel) {
            super(deflater);
            this.channel = seekableByteChannel;
        }

        @Override
        protected final void writeOut(byte[] byArray, int n, int n2) throws IOException {
            this.channel.write(ByteBuffer.wrap(byArray, n, n2));
        }
    }

    private static final class DataOutputCompressor
    extends StreamCompressor {
        private final DataOutput raf;

        public DataOutputCompressor(Deflater deflater, DataOutput dataOutput) {
            super(deflater);
            this.raf = dataOutput;
        }

        @Override
        protected final void writeOut(byte[] byArray, int n, int n2) throws IOException {
            this.raf.write(byArray, n, n2);
        }
    }

    private static final class OutputStreamCompressor
    extends StreamCompressor {
        private final OutputStream os;

        public OutputStreamCompressor(Deflater deflater, OutputStream outputStream) {
            super(deflater);
            this.os = outputStream;
        }

        @Override
        protected final void writeOut(byte[] byArray, int n, int n2) throws IOException {
            this.os.write(byArray, n, n2);
        }
    }

    private static final class ScatterGatherBackingStoreCompressor
    extends StreamCompressor {
        private final ScatterGatherBackingStore bs;

        public ScatterGatherBackingStoreCompressor(Deflater deflater, ScatterGatherBackingStore scatterGatherBackingStore) {
            super(deflater);
            this.bs = scatterGatherBackingStore;
        }

        @Override
        protected final void writeOut(byte[] byArray, int n, int n2) throws IOException {
            this.bs.writeOut(byArray, n, n2);
        }
    }
}

