/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.archivers.sevenz;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.sevenz.Coder;
import org.apache.commons.compress.archivers.sevenz.CoderBase;
import org.apache.commons.compress.utils.FlushShieldFilterOutputStream;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.LZMAInputStream;
import org.tukaani.xz.LZMAOutputStream;

class LZMADecoder
extends CoderBase {
    LZMADecoder() {
        super(LZMA2Options.class, Number.class);
    }

    @Override
    InputStream decode(String string, InputStream inputStream, long l, Coder coder, byte[] byArray) throws IOException {
        byte by = coder.properties[0];
        int n = this.getDictionarySize(coder);
        if (n > 0x7FFFFFF0) {
            throw new IOException("Dictionary larger than 4GiB maximum size used in " + string);
        }
        return new LZMAInputStream(inputStream, l, by, n);
    }

    @Override
    OutputStream encode(OutputStream outputStream, Object object) throws IOException {
        return new FlushShieldFilterOutputStream((OutputStream)new LZMAOutputStream(outputStream, this.getOptions(object), false));
    }

    @Override
    byte[] getOptionsAsProperties(Object object) throws IOException {
        LZMA2Options lZMA2Options = this.getOptions(object);
        byte by = (byte)((lZMA2Options.getPb() * 5 + lZMA2Options.getLp()) * 9 + lZMA2Options.getLc());
        int n = lZMA2Options.getDictSize();
        return new byte[]{by, (byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
    }

    @Override
    Object getOptionsFromCoder(Coder coder, InputStream inputStream) throws IOException {
        byte by = coder.properties[0];
        int n = by & 0xFF;
        int n2 = n / 45;
        int n3 = (n -= n2 * 9 * 5) / 9;
        int n4 = n - n3 * 9;
        LZMA2Options lZMA2Options = new LZMA2Options();
        lZMA2Options.setPb(n2);
        lZMA2Options.setLcLp(n4, n3);
        lZMA2Options.setDictSize(this.getDictionarySize(coder));
        return lZMA2Options;
    }

    private int getDictionarySize(Coder coder) throws IllegalArgumentException {
        long l = coder.properties[1];
        for (int i = 1; i < 4; ++i) {
            l |= ((long)coder.properties[i + 1] & 0xFFL) << 8 * i;
        }
        return (int)l;
    }

    private LZMA2Options getOptions(Object object) throws IOException {
        if (object instanceof LZMA2Options) {
            return (LZMA2Options)object;
        }
        LZMA2Options lZMA2Options = new LZMA2Options();
        lZMA2Options.setDictSize(this.numberOptionOrDefault(object));
        return lZMA2Options;
    }

    private int numberOptionOrDefault(Object object) {
        return LZMADecoder.numberOptionOrDefault(object, 0x800000);
    }
}

