/*
 * Decompiled with CFR 0.152.
 */
package plugins.UPnP.org.cybergarage.upnp.control;

import plugins.UPnP.org.cybergarage.soap.SOAPResponse;
import plugins.UPnP.org.cybergarage.upnp.UPnP;
import plugins.UPnP.org.cybergarage.upnp.UPnPStatus;
import plugins.UPnP.org.cybergarage.xml.Node;

public class ControlResponse
extends SOAPResponse {
    public static final String FAULT_CODE = "Client";
    public static final String FAULT_STRING = "UPnPError";
    private UPnPStatus upnpErr = new UPnPStatus();

    public ControlResponse() {
        this.setServer(UPnP.getServerName());
    }

    public ControlResponse(SOAPResponse soapRes) {
        super(soapRes);
    }

    public void setFaultResponse(int errCode, String errDescr) {
        this.setStatusCode(500);
        Node bodyNode = this.getBodyNode();
        Node faultNode = this.createFaultResponseNode(errCode, errDescr);
        bodyNode.addNode(faultNode);
        Node envNode = this.getEnvelopeNode();
        this.setContent(envNode);
    }

    public void setFaultResponse(int errCode) {
        this.setFaultResponse(errCode, UPnPStatus.code2String(errCode));
    }

    private Node createFaultResponseNode(int errCode, String errDescr) {
        Node faultNode = new Node("s:Fault");
        Node faultCodeNode = new Node("faultcode");
        faultCodeNode.setValue("s:Client");
        faultNode.addNode(faultCodeNode);
        Node faultStringNode = new Node("faultstring");
        faultStringNode.setValue(FAULT_STRING);
        faultNode.addNode(faultStringNode);
        Node detailNode = new Node("detail");
        faultNode.addNode(detailNode);
        Node upnpErrorNode = new Node(FAULT_STRING);
        upnpErrorNode.setAttribute("xmlns", "urn:schemas-upnp-org:control-1-0");
        detailNode.addNode(upnpErrorNode);
        Node errorCodeNode = new Node("errorCode");
        errorCodeNode.setValue(errCode);
        upnpErrorNode.addNode(errorCodeNode);
        Node errorDesctiprionNode = new Node("errorDescription");
        errorDesctiprionNode.setValue(errDescr);
        upnpErrorNode.addNode(errorDesctiprionNode);
        return faultNode;
    }

    private Node getUPnPErrorNode() {
        Node detailNode = this.getFaultDetailNode();
        if (detailNode == null) {
            return null;
        }
        return detailNode.getNodeEndsWith(FAULT_STRING);
    }

    private Node getUPnPErrorCodeNode() {
        Node errorNode = this.getUPnPErrorNode();
        if (errorNode == null) {
            return null;
        }
        return errorNode.getNodeEndsWith("errorCode");
    }

    private Node getUPnPErrorDescriptionNode() {
        Node errorNode = this.getUPnPErrorNode();
        if (errorNode == null) {
            return null;
        }
        return errorNode.getNodeEndsWith("errorDescription");
    }

    public int getUPnPErrorCode() {
        Node errorCodeNode = this.getUPnPErrorCodeNode();
        if (errorCodeNode == null) {
            return -1;
        }
        String errorCodeStr = errorCodeNode.getValue();
        try {
            return Integer.parseInt(errorCodeStr);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public String getUPnPErrorDescription() {
        Node errorDescNode = this.getUPnPErrorDescriptionNode();
        if (errorDescNode == null) {
            return "";
        }
        return errorDescNode.getValue();
    }

    public UPnPStatus getUPnPError() {
        int code = 0;
        String desc = "";
        code = this.getUPnPErrorCode();
        desc = this.getUPnPErrorDescription();
        this.upnpErr.setCode(code);
        this.upnpErr.setDescription(desc);
        return this.upnpErr;
    }
}

