/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.utilities;

import java.util.ArrayList;
import org.spaceroots.mantissa.utilities.ArrayMapperEntry;
import org.spaceroots.mantissa.utilities.ArraySliceMappable;

public class ArrayMapper {
    private ArrayList domainObjects = new ArrayList();
    private int size;
    private double[] internalData;

    public ArrayMapper() {
        this.size = 0;
        this.internalData = null;
    }

    public ArrayMapper(ArraySliceMappable object) {
        this.domainObjects.add(new ArrayMapperEntry(object, 0));
        this.size = object.getStateDimension();
        this.internalData = new double[this.size];
    }

    public void manageMappable(ArraySliceMappable object) {
        this.domainObjects.add(new ArrayMapperEntry(object, this.size));
        this.size += object.getStateDimension();
        if (this.internalData != null) {
            this.internalData = new double[this.size];
        }
    }

    public double[] getDataArray() {
        if (this.internalData == null) {
            this.internalData = new double[this.size];
        }
        return (double[])this.internalData.clone();
    }

    public void updateObjects() {
        if (this.internalData == null) {
            this.internalData = new double[this.size];
        }
        this.updateObjects(this.internalData);
    }

    public void updateObjects(double[] data) {
        for (ArrayMapperEntry entry : this.domainObjects) {
            entry.object.mapStateFromArray(entry.offset, data);
        }
    }

    public void updateArray() {
        if (this.internalData == null) {
            this.internalData = new double[this.size];
        }
        this.updateArray(this.internalData);
    }

    public void updateArray(double[] data) {
        for (ArrayMapperEntry entry : this.domainObjects) {
            entry.object.mapStateToArray(entry.offset, data);
        }
    }
}

