/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.quadrature.vectorial;

import org.spaceroots.mantissa.functions.FunctionException;
import org.spaceroots.mantissa.functions.vectorial.ComputableFunction;
import org.spaceroots.mantissa.quadrature.vectorial.ComputableFunctionIntegrator;

public class GaussLegendreIntegrator
implements ComputableFunctionIntegrator {
    double[][] weightedRoots;
    double rawStep;

    public GaussLegendreIntegrator(int minPoints, double rawStep) {
        this.weightedRoots = minPoints <= 2 ? (Object)new double[][]{{1.0, -1.0 / Math.sqrt(3.0)}, {1.0, 1.0 / Math.sqrt(3.0)}} : (double[][])(minPoints <= 3 ? (double[][])new double[][]{{0.5555555555555556, -Math.sqrt(0.6)}, {0.8888888888888888, 0.0}, {0.5555555555555556, Math.sqrt(0.6)}} : (minPoints <= 4 ? (Object)new double[][]{{(90.0 - 5.0 * Math.sqrt(30.0)) / 180.0, -Math.sqrt((15.0 + 2.0 * Math.sqrt(30.0)) / 35.0)}, {(90.0 + 5.0 * Math.sqrt(30.0)) / 180.0, -Math.sqrt((15.0 - 2.0 * Math.sqrt(30.0)) / 35.0)}, {(90.0 + 5.0 * Math.sqrt(30.0)) / 180.0, Math.sqrt((15.0 - 2.0 * Math.sqrt(30.0)) / 35.0)}, {(90.0 - 5.0 * Math.sqrt(30.0)) / 180.0, Math.sqrt((15.0 + 2.0 * Math.sqrt(30.0)) / 35.0)}} : (double[][])new double[][]{{(322.0 - 13.0 * Math.sqrt(70.0)) / 900.0, -Math.sqrt((35.0 + 2.0 * Math.sqrt(70.0)) / 63.0)}, {(322.0 + 13.0 * Math.sqrt(70.0)) / 900.0, -Math.sqrt((35.0 - 2.0 * Math.sqrt(70.0)) / 63.0)}, {0.5688888888888889, 0.0}, {(322.0 + 13.0 * Math.sqrt(70.0)) / 900.0, Math.sqrt((35.0 - 2.0 * Math.sqrt(70.0)) / 63.0)}, {(322.0 - 13.0 * Math.sqrt(70.0)) / 900.0, Math.sqrt((35.0 + 2.0 * Math.sqrt(70.0)) / 63.0)}}));
        this.rawStep = rawStep;
    }

    public int getEvaluationsPerStep() {
        return this.weightedRoots.length;
    }

    @Override
    public double[] integrate(ComputableFunction f, double a, double b) throws FunctionException {
        if (b < a) {
            double tmp = b;
            b = a;
            a = tmp;
        }
        long n = Math.round(0.5 + (b - a) / this.rawStep);
        double step = (b - a) / (double)n;
        double halfStep = step / 2.0;
        double midPoint = a + halfStep;
        double[] sum = new double[f.getDimension()];
        for (int k = 0; k < sum.length; ++k) {
            sum[k] = 0.0;
        }
        for (long i = 0L; i < n; ++i) {
            for (int j = 0; j < this.weightedRoots.length; ++j) {
                double[] value = f.valueAt(midPoint + halfStep * this.weightedRoots[j][1]);
                for (int k = 0; k < sum.length; ++k) {
                    int n2 = k;
                    sum[n2] = sum[n2] + this.weightedRoots[j][0] * value[k];
                }
            }
            midPoint += step;
        }
        int k = 0;
        while (k < sum.length) {
            int n3 = k++;
            sum[n3] = sum[n3] * halfStep;
        }
        return sum;
    }
}

