/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.fitting;

import org.spaceroots.mantissa.estimation.EstimatedParameter;
import org.spaceroots.mantissa.estimation.EstimationException;
import org.spaceroots.mantissa.estimation.Estimator;
import org.spaceroots.mantissa.estimation.GaussNewtonEstimator;
import org.spaceroots.mantissa.fitting.AbstractCurveFitter;
import org.spaceroots.mantissa.fitting.HarmonicCoefficientsGuesser;
import org.spaceroots.mantissa.functions.ExhaustedSampleException;
import org.spaceroots.mantissa.functions.FunctionException;

public class HarmonicFitter
extends AbstractCurveFitter {
    private boolean firstGuessNeeded;
    private static final long serialVersionUID = -8722683066277473450L;

    public HarmonicFitter(Estimator estimator) {
        super(3, estimator);
        this.coefficients[0] = new EstimatedParameter("a", Math.PI * 2);
        this.coefficients[1] = new EstimatedParameter("omega", 0.0);
        this.coefficients[2] = new EstimatedParameter("phi", 0.0);
        this.firstGuessNeeded = true;
    }

    public HarmonicFitter(EstimatedParameter[] coefficients, Estimator estimator) {
        super(coefficients, estimator);
        this.firstGuessNeeded = false;
    }

    public HarmonicFitter(int maxIterations, double convergence, double steadyStateThreshold, double epsilon) {
        this(new GaussNewtonEstimator(maxIterations, convergence, steadyStateThreshold, epsilon));
    }

    public HarmonicFitter(EstimatedParameter[] coefficients, int maxIterations, double convergence, double steadyStateThreshold, double epsilon) {
        this(coefficients, (Estimator)new GaussNewtonEstimator(maxIterations, convergence, steadyStateThreshold, epsilon));
    }

    @Override
    public double[] fit() throws EstimationException {
        if (this.firstGuessNeeded) {
            if (this.measurements.size() < 4) {
                throw new EstimationException("sample must contain at least {0} points", new String[]{Integer.toString(4)});
            }
            this.sortMeasurements();
            try {
                HarmonicCoefficientsGuesser guesser = new HarmonicCoefficientsGuesser((AbstractCurveFitter.FitMeasurement[])this.getMeasurements());
                guesser.guess();
                this.coefficients[0].setEstimate(guesser.getA());
                this.coefficients[1].setEstimate(guesser.getOmega());
                this.coefficients[2].setEstimate(guesser.getPhi());
            }
            catch (ExhaustedSampleException e) {
                throw new EstimationException(e);
            }
            catch (FunctionException e) {
                throw new EstimationException(e);
            }
            this.firstGuessNeeded = false;
        }
        return super.fit();
    }

    public double getAmplitude() {
        return this.coefficients[0].getEstimate();
    }

    public double getPulsation() {
        return this.coefficients[1].getEstimate();
    }

    public double getPhase() {
        return this.coefficients[2].getEstimate();
    }

    @Override
    public double valueAt(double x) {
        double a = this.coefficients[0].getEstimate();
        double omega = this.coefficients[1].getEstimate();
        double phi = this.coefficients[2].getEstimate();
        return a * Math.cos(omega * x + phi);
    }

    @Override
    public double partial(double x, EstimatedParameter p) {
        double a = this.coefficients[0].getEstimate();
        double omega = this.coefficients[1].getEstimate();
        double phi = this.coefficients[2].getEstimate();
        if (p == this.coefficients[0]) {
            return Math.cos(omega * x + phi);
        }
        if (p == this.coefficients[1]) {
            return -a * x * Math.sin(omega * x + phi);
        }
        return -a * Math.sin(omega * x + phi);
    }
}

