/*
 * Decompiled with CFR 0.152.
 */
package org.spaceroots.mantissa.estimation;

import java.io.Serializable;
import org.spaceroots.mantissa.estimation.EstimatedParameter;
import org.spaceroots.mantissa.estimation.EstimationException;
import org.spaceroots.mantissa.estimation.EstimationProblem;
import org.spaceroots.mantissa.estimation.Estimator;
import org.spaceroots.mantissa.estimation.WeightedMeasurement;
import org.spaceroots.mantissa.linalg.GeneralMatrix;
import org.spaceroots.mantissa.linalg.Matrix;
import org.spaceroots.mantissa.linalg.SingularMatrixException;
import org.spaceroots.mantissa.linalg.SymetricalMatrix;

public class GaussNewtonEstimator
implements Estimator,
Serializable {
    private int maxIterations;
    private double steadyStateThreshold;
    private double convergence;
    private double epsilon;
    private static final long serialVersionUID = -7606628156644194170L;

    public GaussNewtonEstimator(int maxIterations, double convergence, double steadyStateThreshold, double epsilon) {
        this.maxIterations = maxIterations;
        this.steadyStateThreshold = steadyStateThreshold;
        this.convergence = convergence;
        this.epsilon = epsilon;
    }

    @Override
    public void estimate(EstimationProblem problem) throws EstimationException {
        int iterations = 0;
        double previous = 0.0;
        double current = 0.0;
        do {
            if (++iterations > this.maxIterations) {
                throw new EstimationException("unable to converge in {0} iterations", new String[]{Integer.toString(this.maxIterations)});
            }
            this.linearEstimate(problem);
            previous = current;
            current = this.evaluateCriterion(problem);
        } while (iterations < 2 || Math.abs(previous - current) > current * this.steadyStateThreshold && Math.abs(current) > this.convergence);
    }

    public void linearEstimate(EstimationProblem problem) throws EstimationException {
        EstimatedParameter[] parameters = problem.getUnboundParameters();
        WeightedMeasurement[] measurements = problem.getMeasurements();
        GeneralMatrix b = new GeneralMatrix(parameters.length, 1);
        SymetricalMatrix a = new SymetricalMatrix(parameters.length);
        for (int i = 0; i < measurements.length; ++i) {
            if (measurements[i].isIgnored()) continue;
            double weight = measurements[i].getWeight();
            double residual = measurements[i].getResidual();
            double[] grad = new double[parameters.length];
            GeneralMatrix bDecrement = new GeneralMatrix(parameters.length, 1);
            for (int j = 0; j < parameters.length; ++j) {
                grad[j] = measurements[i].getPartial(parameters[j]);
                bDecrement.setElement(j, 0, weight * residual * grad[j]);
            }
            a.selfAddWAAt(weight, grad);
            b.selfAdd(bDecrement);
        }
        try {
            Matrix dX = a.solve(b, this.epsilon);
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i].setEstimate(parameters[i].getEstimate() + dX.getElement(i, 0));
            }
        }
        catch (SingularMatrixException e) {
            throw new EstimationException(e);
        }
    }

    private double evaluateCriterion(EstimationProblem problem) {
        double criterion = 0.0;
        WeightedMeasurement[] measurements = problem.getMeasurements();
        for (int i = 0; i < measurements.length; ++i) {
            double residual = measurements[i].getResidual();
            criterion += measurements[i].getWeight() * residual * residual;
        }
        return criterion;
    }

    @Override
    public double getRMS(EstimationProblem problem) {
        double criterion = this.evaluateCriterion(problem);
        int n = problem.getMeasurements().length;
        return Math.sqrt(criterion / (double)n);
    }
}

