/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.handlers;

import com.db4o.CorruptionException;
import com.db4o.foundation.Coercion4;
import com.db4o.foundation.PreparedComparison;
import com.db4o.internal.ByteArrayBuffer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.handlers.PrimitiveHandler;
import com.db4o.internal.marshall.MarshallerFamily;
import com.db4o.marshall.ReadContext;
import com.db4o.marshall.WriteContext;
import com.db4o.reflect.ReflectClass;
import com.db4o.reflect.Reflector;

public class ShortHandler
extends PrimitiveHandler {
    static final int LENGTH = 2;
    private static final Short DEFAULTVALUE = new Short(0);

    @Override
    public Object coerce(Reflector reflector, ReflectClass claxx, Object obj) {
        return Coercion4.toShort(obj);
    }

    @Override
    public Object defaultValue() {
        return DEFAULTVALUE;
    }

    @Override
    public int linkLength() {
        return 2;
    }

    @Override
    public Class primitiveJavaClass() {
        return Short.TYPE;
    }

    @Override
    public Object read(MarshallerFamily mf, StatefulBuffer buffer, boolean redirect) throws CorruptionException {
        return mf._primitive.readShort(buffer);
    }

    @Override
    Object read1(ByteArrayBuffer buffer) {
        return this.primitiveMarshaller().readShort(buffer);
    }

    @Override
    public void write(Object a_object, ByteArrayBuffer a_bytes) {
        ShortHandler.writeShort(((Short)a_object).shortValue(), a_bytes);
    }

    static final void writeShort(int a_short, ByteArrayBuffer a_bytes) {
        for (int i = 0; i < 2; ++i) {
            a_bytes._buffer[a_bytes._offset++] = (byte)(a_short >> (1 - i) * 8);
        }
    }

    @Override
    public Object read(ReadContext context) {
        int value = ((context.readByte() & 0xFF) << 8) + (context.readByte() & 0xFF);
        return new Short((short)value);
    }

    @Override
    public void write(WriteContext context, Object obj) {
        short shortValue = (Short)obj;
        context.writeBytes(new byte[]{(byte)(shortValue >> 8), (byte)shortValue});
    }

    @Override
    public PreparedComparison internalPrepareComparison(Object source) {
        final short sourceShort = (Short)source;
        return new PreparedComparison(){

            @Override
            public int compareTo(Object target) {
                if (target == null) {
                    return 1;
                }
                short targetShort = (Short)target;
                return sourceShort == targetShort ? 0 : (sourceShort < targetShort ? -1 : 1);
            }
        };
    }
}

