/*
 * Decompiled with CFR 0.152.
 */
package blue.utility.midi;

import blue.utility.GUI;
import blue.utility.midi.MidiImportSettings;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class MidiImportSettingsDialog
extends JDialog {
    private static String REFERENCE = "<INSTR_ID> - Instrument ID\n<START> - Start time of note\n<DUR> - Duration of note\n<KEY> - MIDI key Number\n<KEY_PCH> - MIDI key number as Csound PCH\n<KEY_OCT> - MIDI key number as Csound OCT\n<KEY_CPS> - MIDI key number as CPS\n<VELOCITY> - MIDI velocity number\n<VELOCITY_AMP> - MIDI velocity number as amplitude";
    private static MidiImportSettingsDialog dialog = null;
    boolean retVal = false;
    private JButton cancelButton;
    private JScrollPane jScrollPane1;
    private JButton okButton;
    private JButton referenceButton;
    private JTable settingsTable;

    public MidiImportSettingsDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
    }

    public static boolean ask(Frame root, MidiImportSettings settings) {
        if (dialog == null) {
            dialog = new MidiImportSettingsDialog(root, true);
            GUI.centerOnScreen((Component)dialog);
        }
        MidiImportSettingsDialog.dialog.retVal = false;
        dialog.setMidiImportSettings(settings);
        dialog.setVisible(true);
        return MidiImportSettingsDialog.dialog.retVal;
    }

    public void setMidiImportSettings(MidiImportSettings settings) {
        this.settingsTable.setModel(settings);
        this.settingsTable.getColumnModel().getColumn(0).setWidth(100);
        this.settingsTable.getColumnModel().getColumn(1).setWidth(150);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.settingsTable = new JTable();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.referenceButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("MIDI Import Settings");
        this.settingsTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.settingsTable);
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MidiImportSettingsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MidiImportSettingsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.referenceButton.setText("Reference");
        this.referenceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MidiImportSettingsDialog.this.referenceButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING, -1, 668, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.referenceButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 385, Short.MAX_VALUE).addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton))).addContainerGap()));
        layout.linkSize(0, this.cancelButton, this.okButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 211, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton).addComponent(this.referenceButton)).addContainerGap()));
        this.pack();
    }

    private void referenceButtonActionPerformed(ActionEvent evt) {
        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)REFERENCE, 1);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.retVal = true;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.retVal = false;
        this.setVisible(false);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(() -> new MidiImportSettingsDialog((Frame)new JFrame(), true).setVisible(true));
    }
}

