/*
 * Decompiled with CFR 0.152.
 */
package blue.projects.actions;

import blue.projects.BlueProjectManager;
import blue.projects.actions.OpenProjectAction;
import blue.projects.recentProjects.RecentProjectsList;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.DynamicMenuContent;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public class RecentProjectsAction
extends CallableSystemAction {
    public void performAction() {
    }

    public String getName() {
        return NbBundle.getMessage(RecentProjectsAction.class, (String)"CTL_RecentProjectsAction");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    public JMenuItem getMenuPresenter() {
        MRUFilesMenu menu = new MRUFilesMenu(this.getName());
        return menu;
    }

    class MRUFilesMenu
    extends JMenu
    implements DynamicMenuContent {
        public MRUFilesMenu(String s) {
            super(s);
            RecentProjectsList opts = RecentProjectsList.getInstance();
            opts.addPropertyChangeListener(evt -> {
                if (!evt.getPropertyName().equals("MRUFileList")) {
                    return;
                }
                this.updateMenu();
            });
            this.updateMenu();
        }

        public JComponent[] getMenuPresenters() {
            return new JComponent[]{this};
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            return this.getMenuPresenters();
        }

        private void updateMenu() {
            this.removeAll();
            RecentProjectsList opts = RecentProjectsList.getInstance();
            List<String> list = opts.getRecentProjectsList();
            for (int i = 0; i < list.size(); ++i) {
                String name = list.get(i);
                Action action = this.createAction(name);
                action.putValue("Name", name);
                JMenuItem menuItem = new JMenuItem(action);
                this.add(menuItem);
            }
        }

        private Action createAction(String actionCommand) {
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MRUFilesMenu.this.menuItemActionPerformed(e);
                }
            };
            action.putValue("ActionCommandKey", actionCommand);
            return action;
        }

        private void menuItemActionPerformed(ActionEvent evt) {
            String command = evt.getActionCommand();
            File file = new File(command);
            if (BlueProjectManager.getInstance().findProjectFromFile(file) == null) {
                OpenProjectAction.open(file);
            } else {
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)"This project is already open.", 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            }
        }
    }
}

