/*
 * Decompiled with CFR 0.152.
 */
package blue.score.layers.patterns.ui;

import blue.score.ScoreObject;
import blue.score.layers.patterns.core.PatternLayer;
import blue.soundObject.SoundObject;
import blue.ui.components.IconFactory;
import blue.ui.core.score.ScoreController;
import blue.ui.core.score.layers.soundObject.ScoreObjectEditorTopComponent;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.WindowManager;

public class PatternLayerPanel
extends JPanel
implements PropertyChangeListener {
    private final PatternLayer patternLayer;
    private InstanceContent content;
    private static final Border border = BorderFactory.createBevelBorder(0);
    private static final Border selectionBorder = BorderFactory.createBevelBorder(0, Color.GREEN, Color.GREEN.darker());
    private JMenu changeSObjMenu;
    private JMenuItem copySObjToBufferMenuItem;
    private JMenuItem editSObjMenuItem;
    private JPanel jPanel1;
    private JPopupMenu jPopupMenu1;
    private JPopupMenu.Separator jSeparator1;
    private JPopupMenu.Separator jSeparator2;
    private JToggleButton muteToggleButton;
    private JLabel nameLabel;
    private JTextField nameText;
    private JButton otherMenuButton;
    private JMenuItem setSObjFromBufferMenuItem;
    private JToggleButton soloToggleButton;

    public PatternLayerPanel(PatternLayer layer, InstanceContent ic) {
        this.initComponents();
        Dimension d = new Dimension(100, 22);
        this.setSize(d);
        this.setPreferredSize(d);
        this.content = ic;
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem temp = (JMenuItem)e.getSource();
                Class c = (Class)temp.getClientProperty("sObjClass");
                try {
                    SoundObject sObj = (SoundObject)c.newInstance();
                    PatternLayerPanel.this.patternLayer.setSoundObject(sObj);
                    PatternLayerPanel.this.editSoundObject();
                }
                catch (InstantiationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
        FileObject[] sObjFiles = FileUtil.getConfigFile((String)"blue/score/layers/patterns/soundObjects").getChildren();
        List orderedSObjFiles = FileUtil.getOrder(Arrays.asList(sObjFiles), (boolean)true);
        for (FileObject fObj : orderedSObjFiles) {
            if (fObj.isFolder()) continue;
            SoundObject sObj = (SoundObject)FileUtil.getConfigObject((String)fObj.getPath(), SoundObject.class);
            String originalFile = (String)fObj.getAttribute("originalFile");
            FileObject configFile = FileUtil.getConfigFile((String)originalFile);
            if (configFile == null) {
                System.err.println("[PatternLayerPanel] Error: Unable to open file: " + originalFile);
                continue;
            }
            String displayName = (String)configFile.getAttribute("displayName");
            JMenuItem temp = new JMenuItem();
            temp.setText(displayName);
            temp.putClientProperty("sObjClass", sObj.getClass());
            temp.setActionCommand(displayName);
            temp.addActionListener(al);
            this.changeSObjMenu.add(temp);
        }
        this.setBorder(border);
        this.patternLayer = layer;
        this.nameLabel.setText(this.patternLayer.getName());
        this.muteToggleButton.setSelected(this.patternLayer.isMuted());
        this.soloToggleButton.setSelected(this.patternLayer.isSolo());
        this.muteToggleButton.putClientProperty("BlueToggleButton.selectColorOverride", Color.ORANGE.darker());
        this.soloToggleButton.putClientProperty("BlueToggleButton.selectColorOverride", Color.GREEN.darker());
        this.patternLayer.addPropertyChangeListener((PropertyChangeListener)this);
    }

    protected void editSoundObject() {
        this.content.set(Collections.singleton(this.patternLayer.getSoundObject()), null);
        ScoreObjectEditorTopComponent editor = (ScoreObjectEditorTopComponent)WindowManager.getDefault().findTopComponent("ScoreObjectEditorTopComponent");
        if (!editor.isOpened()) {
            editor.open();
        }
        editor.requestActive();
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.editSObjMenuItem = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.setSObjFromBufferMenuItem = new JMenuItem();
        this.copySObjToBufferMenuItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.changeSObjMenu = new JMenu();
        this.jPanel1 = new JPanel();
        this.nameLabel = new JLabel();
        this.nameText = new JTextField();
        this.muteToggleButton = new JToggleButton();
        this.soloToggleButton = new JToggleButton();
        this.otherMenuButton = new JButton();
        this.editSObjMenuItem.setText(NbBundle.getMessage(PatternLayerPanel.class, (String)"PatternLayerPanel.editSObjMenuItem.text"));
        this.editSObjMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatternLayerPanel.this.editSObjMenuItemActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.editSObjMenuItem);
        this.jPopupMenu1.add(this.jSeparator1);
        this.setSObjFromBufferMenuItem.setText(NbBundle.getMessage(PatternLayerPanel.class, (String)"PatternLayerPanel.setSObjFromBufferMenuItem.text"));
        this.setSObjFromBufferMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatternLayerPanel.this.setSObjFromBufferMenuItemActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.setSObjFromBufferMenuItem);
        this.copySObjToBufferMenuItem.setText(NbBundle.getMessage(PatternLayerPanel.class, (String)"PatternLayerPanel.copySObjToBufferMenuItem.text"));
        this.copySObjToBufferMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatternLayerPanel.this.copySObjToBufferMenuItemActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.copySObjToBufferMenuItem);
        this.jPopupMenu1.add(this.jSeparator2);
        this.changeSObjMenu.setText(NbBundle.getMessage(PatternLayerPanel.class, (String)"PatternLayerPanel.changeSObjMenu.text"));
        this.jPopupMenu1.add(this.changeSObjMenu);
        this.setLayout(new BoxLayout(this, 2));
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
        this.jPanel1.setMinimumSize(new Dimension(0, 0));
        this.jPanel1.setPreferredSize(new Dimension(17, 17));
        this.jPanel1.setLayout(new CardLayout());
        this.nameLabel.setText(NbBundle.getMessage(PatternLayerPanel.class, (String)"PatternLayerPanel.nameLabel.text"));
        this.nameLabel.setMinimumSize(new Dimension(0, 15));
        this.jPanel1.add((Component)this.nameLabel, "label");
        this.nameText.setText(NbBundle.getMessage(PatternLayerPanel.class, (String)"PatternLayerPanel.nameText.text"));
        this.nameText.setMinimumSize(new Dimension(0, 15));
        this.nameText.setPreferredSize(new Dimension(115, 17));
        this.nameText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatternLayerPanel.this.nameTextActionPerformed(evt);
            }
        });
        this.nameText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PatternLayerPanel.this.nameTextFocusLost(evt);
            }
        });
        this.nameText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PatternLayerPanel.this.nameTextKeyPressed(evt);
            }
        });
        this.jPanel1.add((Component)this.nameText, "textField");
        this.add(this.jPanel1);
        this.muteToggleButton.setFont(new Font("Dialog", 1, 10));
        this.muteToggleButton.setText(NbBundle.getMessage(PatternLayerPanel.class, (String)"PatternLayerPanel.muteToggleButton.text"));
        this.muteToggleButton.setFocusPainted(false);
        this.muteToggleButton.setFocusable(false);
        this.muteToggleButton.setMargin(new Insets(0, 3, 0, 3));
        this.muteToggleButton.setMaximumSize(new Dimension(19, 19));
        this.muteToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatternLayerPanel.this.muteToggleButtonActionPerformed(evt);
            }
        });
        this.add(this.muteToggleButton);
        this.soloToggleButton.setFont(new Font("Dialog", 1, 10));
        this.soloToggleButton.setText(NbBundle.getMessage(PatternLayerPanel.class, (String)"PatternLayerPanel.soloToggleButton.text"));
        this.soloToggleButton.setFocusPainted(false);
        this.soloToggleButton.setFocusable(false);
        this.soloToggleButton.setMargin(new Insets(0, 3, 0, 3));
        this.soloToggleButton.setMaximumSize(new Dimension(19, 19));
        this.soloToggleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatternLayerPanel.this.soloToggleButtonActionPerformed(evt);
            }
        });
        this.add(this.soloToggleButton);
        this.otherMenuButton.setFont(new Font("Dialog", 1, 10));
        this.otherMenuButton.setIcon(IconFactory.getDownArrowIcon());
        this.otherMenuButton.setText(NbBundle.getMessage(PatternLayerPanel.class, (String)"PatternLayerPanel.otherMenuButton.text"));
        this.otherMenuButton.setToolTipText(NbBundle.getMessage(PatternLayerPanel.class, (String)"PatternLayerPanel.otherMenuButton.toolTipText"));
        this.otherMenuButton.setFocusPainted(false);
        this.otherMenuButton.setFocusable(false);
        this.otherMenuButton.setMargin(new Insets(5, 0, 4, 0));
        this.otherMenuButton.setPreferredSize(new Dimension(16, 17));
        this.otherMenuButton.setSize(new Dimension(19, 19));
        this.otherMenuButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PatternLayerPanel.this.otherMenuButtonActionPerformed(evt);
            }
        });
        this.add(this.otherMenuButton);
    }

    private void nameTextActionPerformed(ActionEvent evt) {
        if (this.patternLayer == null) {
            return;
        }
        this.patternLayer.setName(this.nameText.getText());
        this.nameLabel.setText(this.patternLayer.getName());
        ((CardLayout)this.jPanel1.getLayout()).show(this.jPanel1, "label");
    }

    private void nameTextFocusLost(FocusEvent evt) {
        ((CardLayout)this.jPanel1.getLayout()).show(this.jPanel1, "label");
    }

    private void nameTextKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 27) {
            ((CardLayout)this.jPanel1.getLayout()).show(this.jPanel1, "label");
        }
    }

    private void muteToggleButtonActionPerformed(ActionEvent evt) {
        this.patternLayer.setMuted(this.muteToggleButton.isSelected());
    }

    private void soloToggleButtonActionPerformed(ActionEvent evt) {
        this.patternLayer.setSolo(this.soloToggleButton.isSelected());
    }

    private void otherMenuButtonActionPerformed(ActionEvent evt) {
        Class<?> current = this.patternLayer.getSoundObject().getClass();
        for (Component c : this.changeSObjMenu.getMenuComponents()) {
            JMenuItem menuItem;
            Class clazz = (Class)(menuItem = (JMenuItem)c).getClientProperty("sObjClass");
            menuItem.setEnabled(!current.equals(clazz));
        }
        ScoreController controller = ScoreController.getInstance();
        Collection selected = controller.getSelectedScoreObjects();
        this.setSObjFromBufferMenuItem.setEnabled(selected.size() == 1 && selected.iterator().next() instanceof SoundObject);
        this.jPopupMenu1.show(this.otherMenuButton, 0, this.otherMenuButton.getHeight());
    }

    private void editSObjMenuItemActionPerformed(ActionEvent evt) {
        this.editSoundObject();
    }

    private void setSObjFromBufferMenuItemActionPerformed(ActionEvent evt) {
        ScoreController controller = ScoreController.getInstance();
        ScoreController.ScoreObjectBuffer buffer = controller.getScoreObjectBuffer();
        if (buffer.scoreObjects.size() == 1) {
            ScoreObject scoreObj = (ScoreObject)buffer.scoreObjects.get(0);
            if (!(scoreObj instanceof SoundObject)) {
                return;
            }
            SoundObject sObj = (SoundObject)scoreObj;
            SoundObject copy = sObj.deepCopy();
            copy.setStartTime(0.0);
            copy.setSubjectiveDuration(4.0);
            copy.setTimeBehavior(2);
            this.patternLayer.setSoundObject(copy);
            this.editSoundObject();
        }
    }

    private void copySObjToBufferMenuItemActionPerformed(ActionEvent evt) {
        SoundObject copy = this.patternLayer.getSoundObject().deepCopy();
        ScoreController.getInstance().setSelectedScoreObjects(Collections.singleton(copy));
    }

    public void editName() {
        if (this.patternLayer == null) {
            return;
        }
        this.nameText.setText(this.patternLayer.getName());
        ((CardLayout)this.jPanel1.getLayout()).show(this.jPanel1, "textField");
        this.nameText.requestFocusInWindow();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this.patternLayer != null) {
            this.patternLayer.removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.patternLayer != null) {
            this.patternLayer.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void setSelected(boolean val) {
        this.setBorder(val ? selectionBorder : border);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName;
        if (evt.getSource() == this.patternLayer && (propName = evt.getPropertyName()).equals("name")) {
            this.nameText.setText(this.patternLayer.getName());
            this.nameLabel.setText(this.patternLayer.getName());
        }
    }
}

