/*
 * Decompiled with CFR 0.152.
 */
package electric.util;

import electric.util.io.FastReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Hashtable;

public final class Lex {
    public static final int SKIP_WS = 1;
    public static final int CONSUME = 2;
    public static final int INCLUDE = 4;
    public static final int EOF_OK = 8;
    public static final int QUOTES = 16;
    public static final int STRIP = 32;
    public static final int HTML = 64;
    public static final int COMMENTS = 128;
    static final int BUFFER_SIZE = 60;
    static final Hashtable substitutions;
    Reader reader;
    String defaultDelimiters = "";
    int defaultFlags = 1;
    int index = 0;
    int lastChar = 0;
    int lineNumber = 1;
    int charNumber = 0;
    int[] window = new int[60];
    StringBuffer comment = new StringBuffer();

    public Lex(Reader reader) {
        this.reader = reader;
    }

    public Lex(String string) {
        this.reader = new FastReader(string);
    }

    public Lex(Reader reader, String string, int n) {
        this.reader = reader;
        this.defaultDelimiters = string;
        this.defaultFlags = n;
    }

    public Lex(String string, String string2, int n) {
        this.reader = new FastReader(string);
        this.defaultDelimiters = string2;
        this.defaultFlags = n;
    }

    public String getComment() {
        return this.comment.toString();
    }

    public void clearComment() {
        this.comment = new StringBuffer();
    }

    public String readToPattern(String string, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 1) != 0) {
            this.skipWhitespace(n);
        }
        char c = string.charAt(0);
        int n2 = string.length();
        while (true) {
            int n3;
            if ((n3 = this.peek()) == -1) {
                if ((n & 8) == 0) {
                    throw new IOException(String.valueOf(String.valueOf(new StringBuffer("unexpected EOF while searching for '").append(string).append("'"))));
                }
                this.read();
                return stringBuffer.toString();
            }
            if (n3 == c) {
                int n4;
                if (n2 == 1) {
                    if ((n & 4) != 0) {
                        stringBuffer.append((char)n3);
                    }
                    if ((n & 2) != 0) {
                        this.read();
                    }
                    return stringBuffer.toString();
                }
                int[] nArray = new int[n2];
                this.peek(nArray);
                boolean bl = true;
                for (n4 = 1; n4 < n2; ++n4) {
                    if (nArray[n4] == string.charAt(n4)) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    if ((n & 2) != 0) {
                        for (n4 = 0; n4 < n2; ++n4) {
                            this.read();
                        }
                    }
                    if ((n & 4) != 0) {
                        for (n4 = 0; n4 < n2; ++n4) {
                            stringBuffer.append((char)nArray[n4]);
                        }
                    }
                    return stringBuffer.toString();
                }
            }
            if (n3 == 38 && (n & 0x40) != 0) {
                this.readHTML(stringBuffer);
                continue;
            }
            if ((n3 == 39 || n3 == 34) && (n & 0x10) != 0) {
                this.readQuoted(stringBuffer, n3, n);
                continue;
            }
            stringBuffer.append((char)this.read());
        }
    }

    public String readToDelimiter(String string, int n) throws IOException {
        if ((n & 1) != 0) {
            this.skipWhitespace(n);
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n2;
            if ((n2 = this.peek()) == -1) {
                if (stringBuffer.length() <= 0) {
                    throw new IOException("unexpected EOF");
                }
                this.read();
                return stringBuffer.toString();
            }
            if (string.indexOf(n2) != -1) {
                if (stringBuffer.length() == 0) {
                    stringBuffer.append((char)this.read());
                }
                return stringBuffer.toString();
            }
            if (Character.isWhitespace((char)n2)) {
                return stringBuffer.toString();
            }
            if (n2 == 38 && (n & 0x40) != 0) {
                this.readHTML(stringBuffer);
                continue;
            }
            if ((n2 == 39 || n2 == 34) && (n & 0x10) != 0) {
                this.readQuoted(stringBuffer, n2, n);
                continue;
            }
            stringBuffer.append((char)this.read());
        }
    }

    public String readToDelimiter(String string) throws IOException {
        return this.readToDelimiter(string, this.defaultFlags);
    }

    public String readToken() throws IOException {
        return this.readToDelimiter(this.defaultDelimiters, this.defaultFlags);
    }

    public void readToken(String string) throws IOException {
        String string2 = this.readToken();
        if (!string.equals(string2)) {
            throw new IOException(String.valueOf(String.valueOf(new StringBuffer("expected \"").append(string).append("\", got \"").append(string2).append("\""))));
        }
    }

    public void readHTML(StringBuffer stringBuffer) throws IOException {
        this.read();
        String string = this.readTo(59);
        try {
            if (string.startsWith("#x")) {
                stringBuffer.append((char)Integer.parseInt(string.substring(2), 16));
            } else if (string.startsWith("#")) {
                stringBuffer.append((char)Integer.parseInt(string.substring(1)));
            } else {
                String string2 = (String)substitutions.get(string);
                if (string2 != null) {
                    stringBuffer.append(string2);
                } else {
                    stringBuffer.append('&');
                    stringBuffer.append(string);
                    stringBuffer.append(';');
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(String.valueOf(String.valueOf(new StringBuffer("number format exception while parsing &").append(string).append(";"))));
        }
    }

    void readQuoted(StringBuffer stringBuffer, int n, int n2) throws IOException {
        int n3 = this.read();
        if ((n2 & 0x20) == 0) {
            stringBuffer.append((char)n3);
        }
        while ((n3 = this.read()) != -1) {
            if (n3 == n) {
                if ((n2 & 0x20) != 0) break;
                stringBuffer.append((char)n3);
                break;
            }
            stringBuffer.append((char)n3);
        }
    }

    public int readChar() throws IOException {
        this.skipWhitespace();
        int n = this.read();
        if (n == -1) {
            throw new IOException("unexpected EOF");
        }
        return n;
    }

    public void readChar(int n) throws IOException {
        int n2 = this.readChar();
        if (n2 != n) {
            throw new IOException(String.valueOf(String.valueOf(new StringBuffer("expected '").append((char)n).append("', got '").append((char)n2).append("'"))));
        }
    }

    public String readTo(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n2;
            if ((n2 = this.read()) == -1) {
                throw new IOException("could not find ".concat(String.valueOf(String.valueOf(n))));
            }
            if (n2 == n) break;
            stringBuffer.append((char)n2);
        }
        return stringBuffer.toString();
    }

    public StringBuffer readWhitespace() throws IOException {
        return this.readWhitespace(this.defaultFlags);
    }

    public StringBuffer readWhitespace(int n) throws IOException {
        StringBuffer stringBuffer;
        block4: {
            stringBuffer = null;
            while (true) {
                this.reader.mark(2);
                int n2 = this.reader.read();
                if (Character.isWhitespace((char)n2)) {
                    if (stringBuffer == null) {
                        stringBuffer = new StringBuffer();
                    }
                    this.reader.reset();
                    stringBuffer.append((char)this.read());
                    continue;
                }
                if (n2 != 47 || (n & 0x80) == 0) break block4;
                n2 = this.reader.read();
                this.reader.reset();
                if (n2 == 47) {
                    this.readOneLineComment();
                    continue;
                }
                if (n2 != 42) break;
                this.readMultiLineComment();
            }
            return stringBuffer;
        }
        this.reader.reset();
        return stringBuffer;
    }

    public void skipWhitespace() throws IOException {
        this.skipWhitespace(this.defaultFlags);
    }

    public void skipWhitespace(int n) throws IOException {
        block3: {
            while (true) {
                this.reader.mark(2);
                int n2 = this.reader.read();
                if (Character.isWhitespace((char)n2)) {
                    this.reader.reset();
                    this.read();
                    continue;
                }
                if (n2 != 47 || (n & 0x80) == 0) break block3;
                n2 = this.reader.read();
                this.reader.reset();
                if (n2 == 47) {
                    this.readOneLineComment();
                    continue;
                }
                if (n2 != 42) break;
                this.readMultiLineComment();
            }
            return;
        }
        this.reader.reset();
    }

    void readOneLineComment() throws IOException {
        this.comment.append(this.readToPattern("\n", 10));
    }

    void readMultiLineComment() throws IOException {
        int n;
        do {
            if ((n = this.read()) == -1) {
                throw new IOException("missing */ on comment");
            }
            this.comment.append((char)n);
        } while (n != 42 || this.peek() != 47);
        n = this.read();
        this.comment.append((char)n);
    }

    public String peekString(int n) throws IOException {
        int[] nArray = new int[n];
        this.peek(nArray);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n && nArray[i] != -1; ++i) {
            stringBuffer.append((char)nArray[i]);
        }
        return stringBuffer.toString();
    }

    public boolean peekString(String string) throws IOException {
        return string.equals(this.peekString(string.length()));
    }

    public void peek(int[] nArray) throws IOException {
        this.reader.mark(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.reader.read();
        }
        this.reader.reset();
    }

    public int peek() throws IOException {
        this.reader.mark(1);
        int n = this.reader.read();
        this.reader.reset();
        return n;
    }

    public void mark(int n) throws IOException {
        this.reader.mark(n);
    }

    public void reset() throws IOException {
        this.reader.reset();
    }

    public boolean eof() throws IOException {
        this.skipWhitespace();
        return this.peek() == -1;
    }

    public void skip(int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            this.read();
        }
    }

    public String getLocation() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("line ").append(this.lineNumber).append(", char ").append(this.charNumber);
        stringBuffer.append(": ...");
        StringBuffer stringBuffer2 = new StringBuffer();
        int n = 0;
        int n2 = this.index;
        while (n++ < this.charNumber) {
            if (n2-- == 0) {
                n2 = 59;
            }
            if (this.window[n2] == 10 || n2 == this.index) break;
            stringBuffer2.append((char)this.window[n2]);
        }
        return stringBuffer.append((Object)stringBuffer2.reverse()).toString();
    }

    public int peekRead() throws IOException {
        return this.reader.read();
    }

    public int read() throws IOException {
        if (this.lastChar == 10) {
            ++this.lineNumber;
            this.charNumber = 0;
        }
        int n = this.reader.read();
        ++this.charNumber;
        this.lastChar = n;
        this.window[this.index] = n;
        if (++this.index == this.window.length) {
            this.index = 0;
        }
        return n;
    }

    static {
        SKIP_WS = 1;
        CONSUME = 2;
        INCLUDE = 4;
        EOF_OK = 8;
        QUOTES = 16;
        STRIP = 32;
        HTML = 64;
        COMMENTS = 128;
        BUFFER_SIZE = 60;
        substitutions = new Hashtable();
        substitutions.put("apos", "'");
        substitutions.put("lt", "<");
        substitutions.put("gt", ">");
        substitutions.put("quot", "\"");
        substitutions.put("amp", "&");
    }
}

