/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor.ceciliaModule;

import blue.soundObject.CeciliaModule;
import blue.soundObject.ceciliaModule.CGraph;
import blue.soundObject.ceciliaModule.CGraphPoint;
import blue.soundObject.ceciliaModule.CeciliaObject;
import blue.soundObject.editor.ceciliaModule.LineColors;
import blue.ui.utilities.UiUtilities;
import blue.utility.TextUtilities;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class Grapher
extends JComponent {
    private static final int NOISE_POINTS = 50;
    private static final int SINE_POINTS = 50;
    private ArrayList graphOrder = new ArrayList();
    private HashMap graphs = new HashMap();
    private CGraph currentGraph;
    private CGraph copyBufferGraph;
    private CGraphPoint selectedPoint = null;
    private CGraph selectedGraph = null;
    int leftBoundaryX = -1;
    int rightBoundaryX = -1;
    private CeciliaModule ceciliaModule;

    public Grapher() {
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (Grapher.this.currentGraph == null) {
                    return;
                }
                if (Grapher.this.selectedGraph == null) {
                    if (Grapher.this.selectedPoint != null) {
                        if (UiUtilities.isRightMouseButton((MouseEvent)e)) {
                            ArrayList<CGraphPoint> points = Grapher.this.currentGraph.getPoints();
                            if (Grapher.this.selectedPoint != points.get(0) && Grapher.this.selectedPoint != points.get(points.size() - 1)) {
                                points.remove(Grapher.this.selectedPoint);
                                Grapher.this.selectedPoint = null;
                            }
                        } else {
                            Grapher.this.setBoundaryXValues();
                        }
                    } else if (SwingUtilities.isLeftMouseButton(e)) {
                        Grapher.this.selectedPoint = Grapher.this.insertGraphPoint(e.getX(), e.getY());
                        Grapher.this.setBoundaryXValues();
                        Grapher.this.repaint();
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (Grapher.this.currentGraph == null) {
                    return;
                }
                Grapher.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (Grapher.this.currentGraph == null) {
                    return;
                }
                if (Grapher.this.selectedPoint != null) {
                    int x = e.getX();
                    int y = e.getY();
                    int topY = 5;
                    int bottomY = Grapher.this.getHeight() - 5;
                    if (x < Grapher.this.leftBoundaryX) {
                        x = Grapher.this.leftBoundaryX;
                    } else if (x > Grapher.this.rightBoundaryX) {
                        x = Grapher.this.rightBoundaryX;
                    }
                    if (y < topY) {
                        y = topY;
                    } else if (y > bottomY) {
                        y = bottomY;
                    }
                    if (Grapher.this.selectedPoint != null) {
                        ((Grapher)Grapher.this).selectedPoint.time = Grapher.this.screenToDoubleX(x);
                        ((Grapher)Grapher.this).selectedPoint.value = Grapher.this.screenToDoubleY(y);
                        Grapher.this.repaint();
                    }
                } else if (Grapher.this.selectedGraph != null) {
                    // empty if block
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                int y;
                if (Grapher.this.currentGraph == null) {
                    return;
                }
                if (Grapher.this.currentGraph == null) {
                    return;
                }
                int x = e.getX();
                CGraphPoint foundPoint = Grapher.this.findGraphPoint(x, y = e.getY());
                if (foundPoint != null) {
                    if (Grapher.this.selectedPoint != foundPoint) {
                        Grapher.this.selectedPoint = foundPoint;
                        Grapher.this.repaint();
                    }
                } else if (Grapher.this.selectedPoint != null) {
                    Grapher.this.selectedPoint = null;
                    Grapher.this.repaint();
                }
            }
        });
    }

    public void setCurrentGraph(String objectName) {
        this.currentGraph = (CGraph)this.graphs.get(objectName);
        this.repaint();
    }

    public CGraph getCurrentGraph() {
        return this.currentGraph;
    }

    protected CGraphPoint insertGraphPoint(int x, int y) {
        CGraphPoint point = new CGraphPoint();
        point.time = this.screenToDoubleX(x);
        point.value = this.screenToDoubleY(y);
        ArrayList<CGraphPoint> points = this.currentGraph.getPoints();
        int index = 1;
        for (int i = 0; i < points.size(); ++i) {
            CGraphPoint p1 = points.get(i);
            CGraphPoint p2 = points.get(i + 1);
            if (!(point.time >= p1.time) || !(point.time <= p2.time)) continue;
            index = i + 1;
            break;
        }
        points.add(index, point);
        return point;
    }

    public void setBoundaryXValues() {
        ArrayList<CGraphPoint> points = this.currentGraph.getPoints();
        if (this.selectedPoint == points.get(0)) {
            this.leftBoundaryX = 5;
            this.rightBoundaryX = 5;
            return;
        }
        if (this.selectedPoint == points.get(points.size() - 1)) {
            this.leftBoundaryX = this.getWidth() - 5;
            this.rightBoundaryX = this.getWidth() - 5;
            return;
        }
        for (int i = 0; i < points.size(); ++i) {
            if (points.get(i) != this.selectedPoint) continue;
            CGraphPoint p1 = points.get(i - 1);
            CGraphPoint p2 = points.get(i + 1);
            this.leftBoundaryX = this.doubleToScreenX(p1.time);
            this.rightBoundaryX = this.doubleToScreenX(p2.time);
            return;
        }
    }

    public CGraphPoint findGraphPoint(int x, int y) {
        for (CGraphPoint point : this.currentGraph.getPoints()) {
            int tempX = this.doubleToScreenX(point.time);
            int tempY = this.doubleToScreenY(point.value);
            if (tempX < x - 2 || tempX > x + 2 || tempY < y - 2 || tempY > y + 2) continue;
            return point;
        }
        return null;
    }

    public CGraphPoint findGraphPoint(int x) {
        for (CGraphPoint point : this.currentGraph.getPoints()) {
            int tempX = this.doubleToScreenX(point.time);
            if (tempX < x - 2 || tempX > x + 2) continue;
            return point;
        }
        return null;
    }

    public void clearPanel() {
        this.graphOrder.clear();
        this.graphs.clear();
        this.currentGraph = null;
    }

    public void addGraphOrder(String objectName) {
        this.graphOrder.add(objectName);
    }

    public void editCeciliaModule(CeciliaModule ceciliaModule) {
        this.ceciliaModule = ceciliaModule;
        HashMap map = ceciliaModule.getStateData();
        if (map.size() == 0) {
            return;
        }
        for (CeciliaObject element : map.values()) {
            if (!(element instanceof CGraph)) continue;
            CGraph graph = (CGraph)element;
            this.graphs.put(graph.getObjectName(), graph);
            if (this.currentGraph != null) continue;
            this.currentGraph = graph;
        }
        this.repaint();
    }

    public void setDuration(double duration) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHints(hints);
        g2d.setColor(Color.black);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setColor(Color.DARK_GRAY.darker());
        int h = this.getHeight() - 10;
        int right = this.getWidth() - 5;
        for (int i = 0; i < 12; ++i) {
            int y = (int)((float)i / 12.0f * (float)h);
            g2d.drawLine(5, y, right, y);
        }
        int w = this.getWidth() - 10;
        int bottom = this.getHeight() - 5;
        for (int i = 0; i < 12; ++i) {
            int x = (int)((float)i / 12.0f * (float)w);
            g2d.drawLine(x, 5, x, bottom);
        }
        g2d.setColor(Color.lightGray);
        g2d.drawRect(5, 5, this.getWidth() - 10, this.getHeight() - 10);
        int colorIndex = 0;
        Color currentColor = null;
        for (String objectName : this.graphOrder) {
            CGraph tempGraph = (CGraph)this.graphs.get(objectName);
            if (tempGraph == this.currentGraph) {
                currentColor = LineColors.getColor(colorIndex);
                ++colorIndex;
                continue;
            }
            g2d.setColor(LineColors.getLightColor(colorIndex));
            ++colorIndex;
            this.drawGraph(g2d, tempGraph, false);
        }
        if (currentColor != null) {
            g2d.setColor(currentColor);
            this.drawGraph(g2d, this.currentGraph, true);
        }
        if (this.selectedPoint != null) {
            int x = this.doubleToScreenX(this.selectedPoint.time);
            int y = this.doubleToScreenY(this.selectedPoint.value);
            g2d.setColor(Color.red);
            this.paintPoint(g2d, x, y);
            if (this.currentGraph != null) {
                this.drawPointInformation(g2d, x, y);
            }
        }
    }

    private void drawPointInformation(Graphics2D g2d, int x, int y) {
        g2d.setColor(Color.white);
        double range = this.currentGraph.getMax() - this.currentGraph.getMin();
        double yVal = this.selectedPoint.value * range + this.currentGraph.getMin();
        String xText = "x: " + this.selectedPoint.time;
        String yText = "y: " + yVal;
        Rectangle2D xRect = g2d.getFontMetrics().getStringBounds(xText, g2d);
        Rectangle2D yRect = g2d.getFontMetrics().getStringBounds(yText, g2d);
        double wx = xRect.getWidth();
        double wy = yRect.getWidth();
        double w = wx > wy ? wx : wy;
        int width = 95;
        int height = 28;
        int xLoc = x + 5;
        int yLoc = y + 5;
        if (x + width > this.getWidth()) {
            xLoc = x - width - 5;
        }
        if (y + height > this.getHeight()) {
            yLoc = y - 14 - 5;
        }
        g2d.drawString(xText, xLoc, yLoc);
        g2d.drawString(yText, xLoc, yLoc + 14);
    }

    private final void drawGraph(Graphics g, CGraph tempGraph, boolean drawPoints) {
        int prevX = -1;
        int prevY = -1;
        for (CGraphPoint point : tempGraph.getPoints()) {
            int x = this.doubleToScreenX(point.time);
            int y = this.doubleToScreenY(point.value);
            if (drawPoints) {
                this.paintPoint(g, x, y);
            }
            if (prevX != -1) {
                g.drawLine(prevX, prevY, x, y);
            }
            prevX = x;
            prevY = y;
        }
    }

    private final void paintPoint(Graphics g, int x, int y) {
        g.fillRect(x - 2, y - 2, 5, 5);
    }

    private final int doubleToScreenX(double val) {
        int width = this.getWidth() - 10;
        return (int)Math.round(val * (double)width) + 5;
    }

    private final int doubleToScreenY(double val) {
        int height = this.getHeight() - 10;
        int y = (int)Math.round((double)height * (1.0 - val)) + 5;
        return y;
    }

    private final double screenToDoubleX(int val) {
        double width = this.getWidth() - 10;
        return (double)(val - 5) / width;
    }

    private final double screenToDoubleY(int val) {
        double height = this.getHeight() - 10;
        return 1.0 - (double)(val - 5) / height;
    }

    public void cutGraph() {
        if (this.currentGraph == null) {
            return;
        }
        this.copyGraph();
        this.resetGraph();
    }

    public void copyGraph() {
        if (this.currentGraph == null) {
            return;
        }
        this.copyBufferGraph = new CGraph(this.currentGraph);
    }

    public void pasteGraph() {
        if (this.currentGraph == null || this.copyBufferGraph == null) {
            return;
        }
        this.currentGraph.replaceValues(this.copyBufferGraph);
        this.repaint();
    }

    public void resetGraph() {
        if (this.currentGraph == null || this.ceciliaModule == null) {
            return;
        }
        String objectName = this.currentGraph.getObjectName();
        String tk_interface = this.ceciliaModule.getModuleDefinition().tk_interface;
        StringTokenizer st = new StringTokenizer(tk_interface, "\n");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            if (!line.contains(objectName) || !line.contains("cgraph")) continue;
            String[] tokens = TextUtilities.splitStringWithQuotes((String)line);
            this.currentGraph.initialize(tokens);
            break;
        }
        this.repaint();
    }

    public void importGraph() {
        if (this.currentGraph == null) {
            return;
        }
    }

    public void exportGraph() {
        if (this.currentGraph == null) {
            return;
        }
    }

    public void moveUpGraph() {
        if (this.currentGraph == null) {
            return;
        }
        for (CGraphPoint point : this.currentGraph.getPoints()) {
            int val = this.doubleToScreenY(point.value);
            if (--val < 5) {
                val = 5;
            }
            point.value = this.screenToDoubleY(val);
        }
        this.repaint();
    }

    public void moveDownGraph() {
        if (this.currentGraph == null) {
            return;
        }
        for (CGraphPoint point : this.currentGraph.getPoints()) {
            int val = this.doubleToScreenY(point.value);
            if (++val > this.getHeight() - 5) {
                val = this.getHeight() - 5;
            }
            point.value = this.screenToDoubleY(val);
        }
        this.repaint();
    }

    public void generateSineGraph() {
        if (this.currentGraph == null) {
            return;
        }
        ArrayList<CGraphPoint> points = this.currentGraph.getPoints();
        points.clear();
        for (int i = 0; i < 50; ++i) {
            double percent;
            CGraphPoint point = new CGraphPoint();
            point.time = percent = (double)i / 49.0;
            point.value = Math.sin(percent * 2.0 * Math.PI);
            point.value = point.value * 0.5 + 0.5;
            points.add(point);
        }
        this.repaint();
    }

    public void generateWaveform() {
        if (this.currentGraph == null) {
            return;
        }
    }

    public void generateDrunkGraph() {
        if (this.currentGraph == null) {
            return;
        }
    }

    public void generateRandomGraph() {
        if (this.currentGraph == null) {
            return;
        }
        ArrayList<CGraphPoint> points = this.currentGraph.getPoints();
        points.clear();
        for (int i = 0; i < 50; ++i) {
            CGraphPoint point = new CGraphPoint();
            point.time = Math.random();
            point.value = Math.random();
            points.add(point);
        }
        Collections.sort(points);
        points.get((int)0).time = 0.0;
        points.get((int)(points.size() - 1)).time = 1.0;
        this.repaint();
    }

    public void scatterGraph() {
        if (this.currentGraph == null) {
            return;
        }
    }
}

