/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.nbutilities.lazyplugin;

import blue.ui.nbutilities.lazyplugin.LazyPlugin;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class LazyPluginFactory {
    private LazyPluginFactory() {
    }

    public static <T> List<LazyPlugin<T>> loadPlugins(String folder, Class<T> z) {
        return LazyPluginFactory.loadPlugins(folder, z, null, null);
    }

    public static <T> List<LazyPlugin<T>> loadPlugins(String folder, Class<T> z, MetaDataProcessor processor) {
        return LazyPluginFactory.loadPlugins(folder, z, processor, null);
    }

    public static <T> List<LazyPlugin<T>> loadPlugins(String folder, Class<T> z, Filter filter) {
        return LazyPluginFactory.loadPlugins(folder, z, null, filter);
    }

    public static <T> List<LazyPlugin<T>> loadPlugins(String folder, Class<T> pluginClass, MetaDataProcessor processor, Filter f) {
        ArrayList<LazyPlugin<T>> plugins = new ArrayList<LazyPlugin<T>>();
        FileObject[] files = FileUtil.getConfigFile((String)folder).getChildren();
        List orderedFiles = FileUtil.getOrder(Arrays.asList(files), (boolean)true);
        for (FileObject fObj : orderedFiles) {
            if (fObj.isFolder() || f != null && !f.accept(fObj)) continue;
            LazyPlugin plugin = new LazyPlugin(fObj, pluginClass);
            if (processor != null) {
                processor.process(fObj, plugin);
            }
            plugins.add(plugin);
        }
        return plugins;
    }

    public static interface MetaDataProcessor {
        public void process(FileObject var1, LazyPlugin var2);
    }

    public static interface Filter {
        public boolean accept(FileObject var1);
    }
}

