/*
 * Decompiled with CFR 0.152.
 */
package blue.score.layers.patterns.core;

import blue.CompileData;
import blue.noteProcessor.NoteProcessorChain;
import blue.noteProcessor.NoteProcessorException;
import blue.score.ScoreGenerationException;
import blue.score.layers.LayerGroup;
import blue.score.layers.LayerGroupDataEvent;
import blue.score.layers.LayerGroupListener;
import blue.score.layers.patterns.core.PatternLayer;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.OnLoadProcessable;
import blue.soundObject.SoundObject;
import blue.soundObject.SoundObjectException;
import blue.utility.ScoreUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.ArrayList;
import java.util.Map;
import java.util.Vector;

public class PatternsLayerGroup
extends ArrayList<PatternLayer>
implements LayerGroup<PatternLayer> {
    private transient Vector<LayerGroupListener> layerGroupListeners = null;
    private int patternBeatsLength = 4;
    private String name = "Patterns Layer Group";
    private NoteProcessorChain npc;

    public PatternsLayerGroup() {
        this.npc = new NoteProcessorChain();
    }

    public PatternsLayerGroup(PatternsLayerGroup plg) {
        super(plg.size());
        this.patternBeatsLength = plg.patternBeatsLength;
        this.name = plg.name;
        this.npc = new NoteProcessorChain(plg.npc);
        for (PatternLayer pl : plg) {
            this.add(pl.deepCopy());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NoteProcessorChain getNoteProcessorChain() {
        return this.npc;
    }

    public void setNoteProcessorChain(NoteProcessorChain npc) {
        this.npc = npc;
    }

    public int getPatternBeatsLength() {
        return this.patternBeatsLength;
    }

    public void setPatternBeatsLength(int patternBeatsLength) {
        this.patternBeatsLength = patternBeatsLength;
    }

    public boolean hasSoloLayers() {
        for (PatternLayer layer : this) {
            if (!layer.isSolo()) continue;
            return true;
        }
        return false;
    }

    public NoteList generateForCSD(CompileData compileData, double startTime, double endTime, boolean processWithSolo) throws ScoreGenerationException {
        NoteList noteList = new NoteList();
        if (processWithSolo) {
            for (PatternLayer patternLayer : this) {
                if (!patternLayer.isSolo() || patternLayer.isMuted()) continue;
                noteList.merge(patternLayer.generateForCSD(compileData, startTime, endTime, this.patternBeatsLength));
            }
        } else {
            for (PatternLayer patternLayer : this) {
                if (patternLayer.isMuted()) continue;
                noteList.merge(patternLayer.generateForCSD(compileData, startTime, endTime, this.patternBeatsLength));
            }
        }
        try {
            noteList = this.processNotes(compileData, noteList, startTime, endTime);
        }
        catch (NoteProcessorException ex) {
            throw new ScoreGenerationException((Throwable)ex);
        }
        return noteList;
    }

    private NoteList processNotes(CompileData compileData, NoteList nl, double start, double endTime) throws NoteProcessorException {
        Note tempNote;
        int i;
        NoteList buffer;
        NoteList retVal = null;
        ScoreUtilities.applyNoteProcessorChain((NoteList)nl, (NoteProcessorChain)this.npc);
        if (start == 0.0) {
            retVal = nl;
        } else {
            ScoreUtilities.setScoreStart((NoteList)nl, (double)(-start));
            buffer = new NoteList();
            for (i = 0; i < nl.size(); ++i) {
                tempNote = (Note)nl.get(i);
                if (!(tempNote.getStartTime() >= 0.0)) continue;
                buffer.add((Object)tempNote);
            }
            retVal = buffer;
        }
        if (endTime > start) {
            buffer = new NoteList();
            for (i = 0; i < retVal.size(); ++i) {
                tempNote = (Note)retVal.get(i);
                if (!(tempNote.getStartTime() <= endTime)) continue;
                buffer.add((Object)tempNote);
            }
            retVal = buffer;
        }
        return retVal;
    }

    public static PatternsLayerGroup loadFromXML(Element data) throws Exception {
        PatternsLayerGroup layerGroup = new PatternsLayerGroup();
        if (data.getAttribute("name") != null) {
            layerGroup.setName(data.getAttributeValue("name"));
        }
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            String nodeName = node.getName();
            if ("patternLayers".equals(nodeName)) {
                Elements patternNodes = node.getElements();
                while (patternNodes.hasMoreElements()) {
                    Element patternNode = patternNodes.next();
                    if (!"patternLayer".equals(patternNode.getName())) continue;
                    layerGroup.add(PatternLayer.loadFromXML(patternNode));
                }
                continue;
            }
            if (!"noteProcessorChain".equals(nodeName)) continue;
            layerGroup.setNoteProcessorChain(NoteProcessorChain.loadFromXML((Element)node));
        }
        return layerGroup;
    }

    public Element saveAsXML(Map<Object, String> objRefMap) {
        Element root = new Element("patternsLayerGroup");
        root.setAttribute("name", this.name);
        Element patternsNode = root.addElement("patternLayers");
        for (PatternLayer layer : this) {
            patternsNode.addElement(layer.saveAsXML());
        }
        root.addElement(this.npc.saveAsXML());
        return root;
    }

    public PatternLayer newLayerAt(int index) {
        PatternLayer patternLayer = new PatternLayer();
        int insertIndex = index;
        if (index < 0 || index >= this.size()) {
            insertIndex = this.size();
            this.add(patternLayer);
        } else {
            this.add(index, patternLayer);
        }
        ArrayList<PatternLayer> layers = new ArrayList<PatternLayer>();
        layers.add(patternLayer);
        LayerGroupDataEvent lde = new LayerGroupDataEvent((LayerGroup)this, 0, insertIndex, insertIndex, layers);
        this.fireLayerGroupDataEvent(lde);
        return patternLayer;
    }

    public void removeLayers(int startIndex, int endIndex) {
        ArrayList<PatternLayer> layers = new ArrayList<PatternLayer>();
        for (int i = endIndex; i >= startIndex; --i) {
            PatternLayer patternLayer = (PatternLayer)this.get(i);
            patternLayer.clearListeners();
            this.remove(i);
            layers.add(patternLayer);
        }
        LayerGroupDataEvent lde = new LayerGroupDataEvent((LayerGroup)this, 1, startIndex, endIndex, layers);
        this.fireLayerGroupDataEvent(lde);
    }

    public void pushUpLayers(int startIndex, int endIndex) {
        PatternLayer a = (PatternLayer)this.remove(startIndex - 1);
        this.add(endIndex, a);
        LayerGroupDataEvent lde = new LayerGroupDataEvent((LayerGroup)this, 2, startIndex - 1, endIndex);
        this.fireLayerGroupDataEvent(lde);
    }

    public void pushDownLayers(int startIndex, int endIndex) {
        PatternLayer a = (PatternLayer)this.remove(endIndex + 1);
        this.add(startIndex, a);
        LayerGroupDataEvent lde = new LayerGroupDataEvent((LayerGroup)this, 2, -startIndex, -(endIndex + 1));
        this.fireLayerGroupDataEvent(lde);
    }

    public void onLoadComplete() {
        for (PatternLayer layer : this) {
            OnLoadProcessable olp;
            SoundObject sObj = layer.getSoundObject();
            if (!(sObj instanceof OnLoadProcessable) || !(olp = (OnLoadProcessable)sObj).isOnLoadProcessable()) continue;
            try {
                olp.processOnLoad();
            }
            catch (SoundObjectException soe) {
                throw new RuntimeException(new SoundObjectException(sObj, "Error during on load processing:", (Throwable)soe));
            }
        }
    }

    public void addLayerGroupListener(LayerGroupListener l) {
        if (this.layerGroupListeners == null) {
            this.layerGroupListeners = new Vector();
        }
        this.layerGroupListeners.add(l);
    }

    public void removeLayerGroupListener(LayerGroupListener l) {
        if (this.layerGroupListeners != null) {
            this.layerGroupListeners.remove(l);
        }
    }

    private void fireLayerGroupDataEvent(LayerGroupDataEvent lde) {
        if (this.layerGroupListeners == null) {
            return;
        }
        for (LayerGroupListener listener : this.layerGroupListeners) {
            listener.layerGroupChanged(lde);
        }
    }

    public int getMaxPattern() {
        int max = 0;
        for (PatternLayer layer : this) {
            if (layer.getPatternData().getMaxSelected() <= max) continue;
            max = layer.getPatternData().getMaxSelected();
        }
        return max;
    }

    public PatternsLayerGroup deepCopyLG() {
        return new PatternsLayerGroup(this);
    }
}

