/*
 * Decompiled with CFR 0.152.
 */
package blue.utility;

import blue.BlueSystem;
import blue.orchestra.GenericInstrument;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class OrchestraUtilities {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList parseInstruments(File csoundTextFile) {
        ArrayList<GenericInstrument> foundInstruments = null;
        BufferedReader in = null;
        try {
            in = new BufferedReader(new FileReader(csoundTextFile));
            String line = "";
            String iName = "";
            StringBuffer iBody = new StringBuffer();
            foundInstruments = new ArrayList<GenericInstrument>();
            int state = 1;
            while ((line = in.readLine()) != null) {
                switch (state) {
                    case 1: {
                        if (!line.trim().startsWith("instr")) break;
                        int index = line.indexOf(59);
                        if (index != -1) {
                            iName = line.substring(index + 1);
                        }
                        state = 2;
                        break;
                    }
                    case 2: {
                        if (line.trim().startsWith("endin")) {
                            GenericInstrument temp = new GenericInstrument();
                            temp.setName(iName);
                            temp.setText(iBody.toString());
                            foundInstruments.add(temp);
                            iName = "";
                            iBody = new StringBuffer();
                            state = 1;
                            break;
                        }
                        iBody.append(line).append("\n");
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println(BlueSystem.getString("orchestraGUI.error.instrumentParse"));
            System.out.println(e);
            foundInstruments = null;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    System.err.println("Could not close file");
                    e.printStackTrace();
                }
            }
        }
        return foundInstruments;
    }
}

