/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.pianoRoll;

import electric.xml.Element;
import electric.xml.Elements;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class PianoNote
implements Comparable<PianoNote> {
    int octave = 8;
    int scaleDegree = 0;
    double start = 0.0;
    double duration = 1.0;
    String noteTemplate = "";
    private transient ArrayList listeners;

    public PianoNote() {
    }

    public PianoNote(PianoNote pn) {
        this.octave = pn.octave;
        this.scaleDegree = pn.scaleDegree;
        this.start = pn.start;
        this.duration = pn.duration;
        this.noteTemplate = pn.noteTemplate;
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double duration) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "duration", new Double(this.duration), new Double(duration));
        this.duration = duration;
        this.firePropertyChange(pce);
    }

    public int getOctave() {
        return this.octave;
    }

    public void setOctave(int octave) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "octave", new Integer(this.octave), new Integer(octave));
        this.octave = octave;
        this.firePropertyChange(pce);
    }

    public int getScaleDegree() {
        return this.scaleDegree;
    }

    public void setScaleDegree(int scaleDegree) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "scaleDegree", new Integer(this.scaleDegree), new Integer(scaleDegree));
        this.scaleDegree = scaleDegree;
        this.firePropertyChange(pce);
    }

    public double getStart() {
        return this.start;
    }

    public void setStart(double start) {
        PropertyChangeEvent pce = new PropertyChangeEvent(this, "start", new Double(this.start), new Double(start));
        this.start = start;
        this.firePropertyChange(pce);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.checkListenersExists();
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.checkListenersExists();
        this.listeners.remove(listener);
    }

    public void firePropertyChange(PropertyChangeEvent pce) {
        this.checkListenersExists();
        for (PropertyChangeListener listener : this.listeners) {
            listener.propertyChange(pce);
        }
    }

    private void checkListenersExists() {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
    }

    public String getNoteTemplate() {
        return this.noteTemplate;
    }

    public void setNoteTemplate(String noteTemplate) {
        this.noteTemplate = noteTemplate;
    }

    public static PianoNote loadFromXML(Element data) {
        PianoNote note = new PianoNote();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            switch (node.getName()) {
                case "octave": {
                    note.setOctave(Integer.parseInt(node.getTextString()));
                    break;
                }
                case "scaleDegree": {
                    note.setScaleDegree(Integer.parseInt(node.getTextString()));
                    break;
                }
                case "start": {
                    note.setStart(Double.parseDouble(node.getTextString()));
                    break;
                }
                case "duration": {
                    note.setDuration(Double.parseDouble(node.getTextString()));
                    break;
                }
                case "noteTemplate": {
                    note.setNoteTemplate(node.getTextString());
                }
            }
        }
        return note;
    }

    public Element saveAsXML() {
        Element retVal = new Element("pianoNote");
        retVal.addElement("octave").setText(Integer.toString(this.octave));
        retVal.addElement("scaleDegree").setText(Integer.toString(this.scaleDegree));
        retVal.addElement("start").setText(Double.toString(this.start));
        retVal.addElement("duration").setText(Double.toString(this.duration));
        retVal.addElement("noteTemplate").setText(this.noteTemplate);
        return retVal;
    }

    @Override
    public int compareTo(PianoNote note2) {
        int val = this.octave - note2.octave;
        if (val != 0) {
            return val;
        }
        val = this.scaleDegree - note2.scaleDegree;
        if (val != 0) {
            return val;
        }
        double val2 = this.start - note2.start;
        if (val2 != 0.0) {
            if (val2 > 0.0) {
                return 1;
            }
            return -1;
        }
        val2 = this.duration - note2.duration;
        if (val2 != 0.0) {
            if (val2 > 0.0) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

