/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.jmask;

public class Utilities {
    public static double round(double val, long dec) {
        double p = Math.pow(10.0, dec);
        double erg = Math.floor(val * p + 0.5) / p;
        return erg;
    }

    public static double limit(double val, double lowerBound, double upperBound) {
        if (lowerBound == upperBound) {
            return lowerBound;
        }
        if (val < lowerBound) {
            return lowerBound;
        }
        if (val > upperBound) {
            return upperBound;
        }
        return val;
    }

    public static double wrap(double val, double lowerBound, double upperBound) {
        double xn;
        double range = upperBound - lowerBound;
        if (range == 0.0) {
            val = lowerBound;
        }
        if (val > upperBound) {
            xn = val - lowerBound;
            val = lowerBound + Math.IEEEremainder(xn, range);
        }
        if (val < lowerBound) {
            xn = upperBound - val;
            val = upperBound - Math.IEEEremainder(xn, range);
        }
        return val;
    }

    public static double mirror(double val, double lowerBound, double upperBound) {
        double xn;
        double range = upperBound - lowerBound;
        if (range == 0.0) {
            val = lowerBound;
        }
        if (val > upperBound) {
            xn = val - lowerBound;
            val = upperBound - Math.IEEEremainder(xn, range);
        }
        if (val < lowerBound) {
            xn = upperBound - val;
            val = lowerBound + Math.IEEEremainder(xn, range);
        }
        return val;
    }
}

