/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.jmask;

import blue.soundObject.jmask.Accumulatable;
import blue.soundObject.jmask.Generator;
import blue.soundObject.jmask.Quantizable;
import electric.xml.Element;
import electric.xml.Elements;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Random
implements Generator,
Quantizable,
Accumulatable {
    private double min = 0.0;
    private double max = 1.0;

    public Random() {
    }

    public Random(Random rand) {
        this.min = rand.min;
        this.max = rand.max;
    }

    public static Generator loadFromXML(Element data) {
        Random retVal = new Random();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            String nodeName;
            Element node = nodes.next();
            switch (nodeName = node.getName()) {
                case "min": {
                    retVal.min = Double.parseDouble(node.getTextString());
                    break;
                }
                case "max": {
                    retVal.max = Double.parseDouble(node.getTextString());
                }
            }
        }
        return retVal;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("generator");
        retVal.setAttribute("type", this.getClass().getName());
        retVal.addElement("min").setText(Double.toString(this.min));
        retVal.addElement("max").setText(Double.toString(this.max));
        return retVal;
    }

    @Override
    public void initialize(double duration) {
    }

    @Override
    public double getValue(double time, java.util.Random rnd) {
        double range = this.max - this.min;
        return this.min + range * rnd.nextDouble();
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public Random deepCopy() {
        return new Random(this);
    }
}

