/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.jmask;

import blue.soundObject.jmask.Table;
import blue.utility.XMLUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Quantizer {
    private double gridSize = 1.0;
    private double strength = 1.0;
    private double offset = 0.0;
    private boolean gridSizeTableEnabled = false;
    private boolean strengthTableEnabled = false;
    private boolean offsetTableEnabled = false;
    private Table gridSizeTable = new Table();
    private Table strengthTable = new Table();
    private Table offsetTable = new Table();
    private boolean enabled = false;
    private transient double duration = 1.0;

    public Quantizer() {
        this.gridSizeTable.getPoint(0).setValue(1.0);
        this.gridSizeTable.getPoint(0).setValue(1.0);
        this.gridSizeTable.setMin(Double.MIN_VALUE, true);
        this.strengthTable.getPoint(0).setValue(1.0);
        this.strengthTable.getPoint(0).setValue(1.0);
        this.offsetTable.getPoint(0).setValue(0.0);
        this.offsetTable.getPoint(0).setValue(0.0);
    }

    public Quantizer(Quantizer q) {
        this.gridSize = q.gridSize;
        this.strength = q.strength;
        this.offset = q.offset;
        this.gridSizeTableEnabled = q.gridSizeTableEnabled;
        this.strengthTableEnabled = q.strengthTableEnabled;
        this.offsetTableEnabled = q.offsetTableEnabled;
        this.gridSizeTable = new Table(q.gridSizeTable);
        this.strengthTable = new Table(q.strengthTable);
        this.offsetTable = new Table(q.offsetTable);
        this.enabled = q.enabled;
        this.duration = q.duration;
    }

    public static Quantizer loadFromXML(Element data) {
        Quantizer retVal = new Quantizer();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Element node = nodes.next();
            String nodeName = node.getName();
            String nodeVal = node.getTextString();
            block10 : switch (nodeName) {
                case "gridSize": {
                    retVal.gridSize = Double.parseDouble(nodeVal);
                    break;
                }
                case "strength": {
                    retVal.strength = Double.parseDouble(nodeVal);
                    break;
                }
                case "offset": {
                    retVal.offset = Double.parseDouble(nodeVal);
                    break;
                }
                case "gridSizeTableEnabled": {
                    retVal.gridSizeTableEnabled = Boolean.valueOf(node.getTextString());
                    break;
                }
                case "strengthTableEnabled": {
                    retVal.strengthTableEnabled = Boolean.valueOf(node.getTextString());
                    break;
                }
                case "offsetTableEnabled": {
                    retVal.offsetTableEnabled = Boolean.valueOf(node.getTextString());
                    break;
                }
                case "enabled": {
                    retVal.enabled = Boolean.valueOf(node.getTextString());
                    break;
                }
                case "table": {
                    String tabInstance;
                    Table t = Table.loadFromXML(node);
                    switch (tabInstance = node.getAttributeValue("tableId")) {
                        case "gridSizeTable": {
                            retVal.gridSizeTable = t;
                            break block10;
                        }
                        case "strengthTable": {
                            retVal.strengthTable = t;
                            break block10;
                        }
                        case "offsetTable": {
                            retVal.offsetTable = t;
                        }
                    }
                }
            }
        }
        return retVal;
    }

    public Element saveAsXML() {
        Element retVal = new Element("quantizer");
        retVal.addElement(XMLUtilities.writeDouble("gridSize", this.gridSize));
        retVal.addElement(XMLUtilities.writeDouble("strength", this.strength));
        retVal.addElement(XMLUtilities.writeDouble("offset", this.offset));
        retVal.addElement(XMLUtilities.writeBoolean("gridSizeTableEnabled", this.gridSizeTableEnabled));
        retVal.addElement(XMLUtilities.writeBoolean("strengthTableEnabled", this.strengthTableEnabled));
        retVal.addElement(XMLUtilities.writeBoolean("offsetTableEnabled", this.offsetTableEnabled));
        retVal.addElement(XMLUtilities.writeBoolean("enabled", this.enabled));
        Element gridSizeTableNode = this.gridSizeTable.saveAsXML();
        Element strengthTableNode = this.strengthTable.saveAsXML();
        Element offsetTableNode = this.offsetTable.saveAsXML();
        gridSizeTableNode.setAttribute("tableId", "gridSizeTable");
        strengthTableNode.setAttribute("tableId", "strengthTable");
        offsetTableNode.setAttribute("tableId", "offsetTable");
        retVal.addElement(gridSizeTableNode);
        retVal.addElement(strengthTableNode);
        retVal.addElement(offsetTableNode);
        return retVal;
    }

    public double getValue(double time, double val) {
        if (!this.enabled) {
            return val;
        }
        double localGridSize = this.gridSizeTableEnabled ? this.gridSizeTable.getValue(time / this.duration) : this.gridSize;
        double localStrength = this.strengthTableEnabled ? this.strengthTable.getValue(time / this.duration) : this.strength;
        double localOffset = this.offsetTableEnabled ? this.offsetTable.getValue(time / this.duration) : this.offset;
        double d = val - localOffset;
        double r = Math.floor((d + localGridSize / 2.0) / localGridSize);
        double err = d / localGridSize - r;
        double retVal = localOffset + (r + err * (1.0 - localStrength)) * localGridSize;
        return retVal;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public double getGridSize() {
        return this.gridSize;
    }

    public void setGridSize(double gridSize) {
        this.gridSize = gridSize;
    }

    public double getStrength() {
        return this.strength;
    }

    public void setStrength(double strength) {
        this.strength = strength;
    }

    public double getOffset() {
        return this.offset;
    }

    public void setOffset(double offset) {
        this.offset = offset;
    }

    public boolean isGridSizeTableEnabled() {
        return this.gridSizeTableEnabled;
    }

    public void setGridSizeTableEnabled(boolean gridSizeTableEnabled) {
        this.gridSizeTableEnabled = gridSizeTableEnabled;
    }

    public boolean isStrengthTableEnabled() {
        return this.strengthTableEnabled;
    }

    public void setStrengthTableEnabled(boolean strengthTableEnabled) {
        this.strengthTableEnabled = strengthTableEnabled;
    }

    public boolean isOffsetTableEnabled() {
        return this.offsetTableEnabled;
    }

    public void setOffsetTableEnabled(boolean offsetTableEnabled) {
        this.offsetTableEnabled = offsetTableEnabled;
    }

    public Table getGridSizeTable() {
        return this.gridSizeTable;
    }

    public void setGridSizeTable(Table gridSizeTable) {
        this.gridSizeTable = gridSizeTable;
    }

    public Table getStrengthTable() {
        return this.strengthTable;
    }

    public void setStrengthTable(Table strengthTable) {
        this.strengthTable = strengthTable;
    }

    public Table getOffsetTable() {
        return this.offsetTable;
    }

    public void setOffsetTable(Table offsetTable) {
        this.offsetTable = offsetTable;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }
}

