/*
 * Decompiled with CFR 0.152.
 */
package blue.noteProcessor;

import blue.noteProcessor.BeatValuePair;
import java.util.StringTokenizer;

public class ValueTimeMapper {
    BeatValuePair[] timeMap;

    private ValueTimeMapper() {
    }

    public static ValueTimeMapper createValueTimeMapper(String beatValueString) {
        ValueTimeMapper tm = new ValueTimeMapper();
        StringTokenizer st = new StringTokenizer(beatValueString);
        if (st.countTokens() % 2 != 0) {
            return null;
        }
        tm.timeMap = new BeatValuePair[st.countTokens() / 2];
        int index = 0;
        while (st.hasMoreTokens()) {
            try {
                String time = st.nextToken();
                String tempo = st.nextToken();
                BeatValuePair temp = new BeatValuePair();
                temp.beat = Double.parseDouble(time);
                temp.value = Double.parseDouble(tempo);
                if (temp.beat < 0.0) {
                    return null;
                }
                tm.timeMap[index] = temp;
                ++index;
            }
            catch (Exception e) {
                return null;
            }
        }
        return tm;
    }

    public double getValueForBeat(double beat) {
        if (beat >= this.timeMap[this.timeMap.length - 1].beat) {
            return this.timeMap[this.timeMap.length - 1].value;
        }
        for (int i = 0; i < this.timeMap.length - 1; ++i) {
            if (!(beat >= this.timeMap[i].beat) || !(beat < this.timeMap[i + 1].beat)) continue;
            double x1 = this.timeMap[i].value;
            double x2 = this.timeMap[i + 1].value;
            double m = x2 - x1;
            double x = (beat - this.timeMap[i].beat) / (this.timeMap[i + 1].beat - this.timeMap[i].beat);
            double y = m * x + x1;
            return y;
        }
        return Double.NaN;
    }
}

