/*
 * Decompiled with CFR 0.152.
 */
package blue.noteProcessor;

import blue.BlueSystem;
import blue.noteProcessor.NoteProcessor;
import blue.noteProcessor.NoteProcessorException;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import blue.utility.ScoreUtilities;
import electric.xml.Element;

public class SubListProcessor
implements NoteProcessor {
    int start = 1;
    int end = 2;

    public SubListProcessor() {
    }

    public SubListProcessor(SubListProcessor slp) {
        this.start = slp.start;
        this.end = slp.end;
    }

    public String toString() {
        return "[sublist]";
    }

    public String getStart() {
        return Integer.toString(this.start);
    }

    public void setStart(String start) {
        this.start = Integer.parseInt(start);
    }

    public String getEnd() {
        return Integer.toString(this.end);
    }

    public void setEnd(String end) {
        this.end = Integer.parseInt(end);
    }

    @Override
    public final void processNotes(NoteList in) throws NoteProcessorException {
        NoteList tempList = new NoteList();
        if (this.end < 1) {
            throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.noteListEnd"));
        }
        for (int i = 0; i < in.size(); ++i) {
            if (i < this.start - 1 || i > this.end - 1) continue;
            tempList.add(in.get(i));
        }
        in.clear();
        in.merge(tempList);
        ScoreUtilities.normalizeNoteList(in);
    }

    public static void main(String[] args) {
        NoteList n = new NoteList();
        for (int i = 0; i < 10; ++i) {
            try {
                n.add(Note.createNote("i1 " + i * 2 + " 2 " + i + " 4"));
                continue;
            }
            catch (NoteParseException e) {
                e.printStackTrace();
            }
        }
        System.out.println("before: \n\n" + n + "\n\n");
        SubListProcessor slp = new SubListProcessor();
        slp.setStart("2");
        slp.setEnd("5");
        try {
            slp.processNotes(n);
        }
        catch (NoteProcessorException ex) {
            System.out.println("Exception: " + ex.getMessage());
        }
        System.out.println("after: \n\n" + n + "\n\n");
    }

    public static NoteProcessor loadFromXML(Element data) {
        SubListProcessor slp = new SubListProcessor();
        slp.setStart(data.getElement("start").getTextString());
        slp.setEnd(data.getElement("end").getTextString());
        return slp;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("noteProcessor");
        retVal.setAttribute("type", this.getClass().getName());
        retVal.addElement("start").setText(this.getStart());
        retVal.addElement("end").setText(this.getEnd());
        return retVal;
    }

    @Override
    public SubListProcessor deepCopy() {
        return new SubListProcessor(this);
    }
}

