/*
 * Decompiled with CFR 0.152.
 */
package blue.noteProcessor;

import blue.BlueSystem;
import blue.noteProcessor.NoteProcessor;
import blue.noteProcessor.NoteProcessorException;
import blue.soundObject.Note;
import blue.soundObject.NoteList;
import blue.soundObject.NoteParseException;
import blue.utility.ScoreUtilities;
import electric.xml.Element;

public class PchInversionProcessor
implements NoteProcessor {
    double value = 8.0;
    int pfield = 4;

    public PchInversionProcessor() {
    }

    public PchInversionProcessor(PchInversionProcessor pip) {
        this.value = pip.value;
        this.pfield = pip.pfield;
    }

    public String toString() {
        return "[pch inversion]";
    }

    public String getPfield() {
        return Integer.toString(this.pfield);
    }

    public void setPfield(String pfield) {
        this.pfield = Integer.parseInt(pfield);
    }

    public String getVal() {
        return Double.toString(this.value);
    }

    public void setVal(String value) {
        this.value = Double.parseDouble(value);
    }

    @Override
    public final void processNotes(NoteList in) throws NoteProcessorException {
        for (int i = 0; i < in.size(); ++i) {
            String val;
            Note temp = (Note)in.get(i);
            try {
                val = temp.getPField(this.pfield).trim();
                Double.parseDouble(val);
            }
            catch (NumberFormatException ex) {
                throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.pfieldNotDouble"), this.pfield);
            }
            catch (Exception ex) {
                throw new NoteProcessorException(this, BlueSystem.getString("noteProcessorException.missingPfield"), this.pfield);
            }
            double baseTen = ScoreUtilities.getBaseTen(val);
            double baseTenAxis = ScoreUtilities.getBaseTen(this.getVal());
            double addVal = -1.0 * (baseTen - baseTenAxis);
            baseTen = baseTenAxis + addVal;
            int octave = (int)(baseTen / 12.0);
            double strPch = baseTen % 12.0 / 100.0;
            temp.setPField(Double.toString((double)octave + strPch), this.pfield);
        }
    }

    public static void main(String[] args) {
        NoteList n = new NoteList();
        for (int i = 0; i < 10; ++i) {
            try {
                n.add(Note.createNote("i1 " + i + " 2 6.0" + i + " 4"));
                continue;
            }
            catch (NoteParseException e) {
                e.printStackTrace();
            }
        }
        System.out.println("before: \n\n" + n + "\n\n");
        PchInversionProcessor ap = new PchInversionProcessor();
        ap.setPfield("4");
        ap.setVal("5.00");
        try {
            ap.processNotes(n);
        }
        catch (NoteProcessorException ex) {
            System.out.println("Exception: " + ex.getMessage());
        }
        System.out.println("after: \n\n" + n + "\n\n");
    }

    public static NoteProcessor loadFromXML(Element data) {
        PchInversionProcessor pip = new PchInversionProcessor();
        pip.setPfield(data.getElement("pfield").getTextString());
        pip.setVal(data.getElement("value").getTextString());
        return pip;
    }

    @Override
    public Element saveAsXML() {
        Element retVal = new Element("noteProcessor");
        retVal.setAttribute("type", this.getClass().getName());
        retVal.addElement("pfield").setText(this.getPfield());
        retVal.addElement("value").setText(this.getVal());
        return retVal;
    }

    @Override
    public PchInversionProcessor deepCopy() {
        return new PchInversionProcessor(this);
    }
}

