/*
 * Decompiled with CFR 0.152.
 */
package blue;

import blue.Marker;
import electric.xml.Element;
import electric.xml.Elements;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class MarkersList
implements TableModel,
PropertyChangeListener {
    ArrayList<Marker> markers = new ArrayList();
    private transient Vector listeners = null;
    private transient Vector listListeners = null;

    public MarkersList() {
    }

    public MarkersList(MarkersList markersList) {
        for (Marker marker : markersList.markers) {
            this.markers.add(new Marker(marker));
        }
    }

    public void addMarker(double time) {
        String name = "Marker" + (this.markers.size() + 1);
        Marker m = new Marker();
        m.setTime(time);
        m.setName(name);
        this.addMarker(m);
    }

    public void addMarker(Marker marker) {
        this.markers.add(marker);
        marker.addPropertyChangeListener(this);
        Collections.sort(this.markers);
        int index = this.markers.indexOf(marker);
        if (this.listeners == null) {
            return;
        }
        TableModelEvent tme = new TableModelEvent(this, index, index, -1, 1);
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(tme);
        }
        this.fireTableDataChanged();
    }

    public Marker getMarker(int index) {
        return this.markers.get(index);
    }

    public void removeMarker(Marker marker) {
        this.removeMarker(this.markers.indexOf(marker));
    }

    public void removeMarker(int index) {
        Marker m = this.markers.remove(index);
        m.removePropertyChangeListener(this);
        if (this.listeners == null) {
            return;
        }
        TableModelEvent tme = new TableModelEvent(this, index, index, -1, -1);
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(tme);
        }
    }

    public int size() {
        return this.markers.size();
    }

    @Override
    public int getRowCount() {
        return this.size();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "Time";
            }
            case 1: {
                return "Label";
            }
        }
        return null;
    }

    public Class getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return Double.class;
            }
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Marker m = this.getMarker(rowIndex);
        if (m == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return new Double(m.getTime());
            }
            case 1: {
                return m.getName();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Marker m = this.getMarker(rowIndex);
        if (m == null) {
            return;
        }
        switch (columnIndex) {
            case 0: {
                Double f = (Double)aValue;
                m.setTime(f);
                break;
            }
            case 1: {
                String title = (String)aValue;
                if (title.trim().length() <= 0) break;
                m.setName(title);
            }
        }
        this.fireTableDataChanged();
    }

    public static MarkersList loadFromXML(Element data) {
        MarkersList markers = new MarkersList();
        Elements nodes = data.getElements();
        while (nodes.hasMoreElements()) {
            Marker m = Marker.loadFromXML(nodes.next());
            markers.addMarker(m);
        }
        return markers;
    }

    public Element saveAsXML() {
        Element retVal = new Element("markersList");
        for (int i = 0; i < this.size(); ++i) {
            Marker m = this.getMarker(i);
            retVal.addElement(m.saveAsXML());
        }
        return retVal;
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    private void fireTableDataChanged() {
        if (this.listeners == null) {
            return;
        }
        TableModelEvent tme = new TableModelEvent(this);
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(tme);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.markers.contains(evt.getSource()) && evt.getPropertyName().equals("time")) {
            Collections.sort(this.markers);
            this.fireTableDataChanged();
        }
    }
}

