/*
 * Decompiled with CFR 0.152.
 */
package blue;

import blue.ArrangementEvent;
import blue.ArrangementListener;
import blue.BlueSystem;
import blue.CompileData;
import blue.InstrumentAssignment;
import blue.InstrumentLibrary;
import blue.Tables;
import blue.automation.Automatable;
import blue.automation.AutomatableCollectionListener;
import blue.mixer.Channel;
import blue.mixer.Mixer;
import blue.orchestra.GenericInstrument;
import blue.orchestra.Instrument;
import blue.udo.OpcodeList;
import blue.utility.TextUtilities;
import electric.xml.Element;
import electric.xml.Elements;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Optional;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.text.StrBuilder;

public class Arrangement
implements TableModel {
    private static final Pattern NEW_LINES = Pattern.compile("\\n");
    private ArrayList<InstrumentAssignment> arrangement = new ArrayList();
    private transient Vector<TableModelListener> listeners = null;
    private transient Vector<ArrangementListener> arrangementListeners = null;
    private transient Vector<AutomatableCollectionListener> automatableCollectionListeners = null;
    private transient HashMap compilationVariables;
    private transient StrBuilder preGenerationCache = null;
    private transient ArrayList<InstrumentAssignment> preGenList = new ArrayList();

    public Arrangement() {
    }

    public Arrangement(Arrangement arr) {
        for (InstrumentAssignment ia : arr.getArrangement()) {
            this.arrangement.add(new InstrumentAssignment(ia));
        }
    }

    public int addInstrument(Instrument instrument) {
        return this.addInstrument("0", instrument);
    }

    public int addInstrumentAtEnd(Instrument instrument) {
        InstrumentAssignment ia;
        int max = 0;
        for (int i = 0; i < this.arrangement.size(); ++i) {
            ia = this.arrangement.get(i);
            try {
                int instrNum = Integer.parseInt(ia.arrangementId);
                if (instrNum <= max) continue;
                max = instrNum;
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        String newIndex = Integer.toString(max + 1);
        ia = new InstrumentAssignment();
        ia.arrangementId = newIndex;
        ia.instr = instrument;
        this.arrangement.add(ia);
        if (instrument instanceof Automatable) {
            this.fireAutomatableAdded((Automatable)((Object)ia.instr));
        }
        return max + 1;
    }

    public int addInstrument(String instrumentId, Instrument instrument) {
        int retVal = -1;
        try {
            InstrumentAssignment ia;
            int currentInstrumentNum = instrumentId == null ? 0 : Integer.parseInt(instrumentId);
            int counter = currentInstrumentNum + 1;
            for (int i = 0; i < this.arrangement.size(); ++i) {
                ia = this.arrangement.get(i);
                try {
                    if (counter != Integer.parseInt(ia.arrangementId)) continue;
                    ++counter;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            String newIndex = Integer.toString(counter);
            ia = new InstrumentAssignment();
            ia.arrangementId = newIndex;
            ia.instr = instrument;
            this.arrangement.add(ia);
            retVal = counter;
        }
        catch (NumberFormatException nfe) {
            String instrID = instrumentId;
            if (this.containsInstrumentId(instrID)) {
                int counter = 0;
                while (this.containsInstrumentId(instrumentId + counter)) {
                    ++counter;
                }
                instrID = instrumentId + counter;
            }
            InstrumentAssignment ia = new InstrumentAssignment();
            ia.arrangementId = instrID;
            ia.instr = instrument;
            this.arrangement.add(ia);
        }
        Collections.sort(this.arrangement);
        this.fireTableDataChanged();
        if (instrument instanceof Automatable) {
            this.fireAutomatableAdded((Automatable)((Object)instrument));
        }
        return retVal;
    }

    public void addInstrumentWithId(Instrument instr, String instrId) {
        InstrumentAssignment ia = new InstrumentAssignment();
        ia.arrangementId = instrId;
        ia.instr = instr;
        this.arrangement.add(ia);
        Collections.sort(this.arrangement);
        if (instr instanceof Automatable) {
            this.fireAutomatableAdded((Automatable)((Object)instr));
        }
        this.fireTableDataChanged();
    }

    public boolean containsInstrumentId(String instrId) {
        for (int i = 0; i < this.arrangement.size(); ++i) {
            InstrumentAssignment ia = this.arrangement.get(i);
            if (!ia.arrangementId.equals(instrId)) continue;
            return true;
        }
        return false;
    }

    public void insertInstrument(String arrangementId, Instrument instrument) {
        InstrumentAssignment ia = new InstrumentAssignment();
        ia.arrangementId = arrangementId;
        ia.instr = instrument;
        this.arrangement.add(ia);
        Collections.sort(this.arrangement);
    }

    public void replaceInstrument(String instrumentId, Instrument instr) {
        for (InstrumentAssignment ia : this.arrangement) {
            if (!ia.arrangementId.equals(instrumentId)) continue;
            ia.instr = instr;
        }
        this.fireTableDataChanged();
        if (instr instanceof Automatable) {
            this.fireAutomatableAdded((Automatable)((Object)instr));
        }
    }

    public Instrument removeInstrument(String instrumentId) {
        for (int i = 0; i < this.arrangement.size(); ++i) {
            InstrumentAssignment ia = this.arrangement.get(i);
            if (!ia.arrangementId.equals(instrumentId)) continue;
            return this.removeInstrument(i);
        }
        return null;
    }

    public int size() {
        return this.arrangement.size();
    }

    public String getInstrumentId(int index) {
        InstrumentAssignment ia = this.arrangement.get(index);
        return ia.arrangementId;
    }

    public String getInstrumentId(Instrument instr) {
        for (InstrumentAssignment ia : this.arrangement) {
            if (ia.instr != instr) continue;
            return ia.arrangementId;
        }
        return null;
    }

    public String[] getInstrumentIds() {
        String[] ids = new String[this.arrangement.size()];
        for (int i = 0; i < this.arrangement.size(); ++i) {
            ids[i] = this.getInstrumentId(i);
        }
        return ids;
    }

    public Instrument getInstrument(int index) {
        InstrumentAssignment ia = this.arrangement.get(index);
        return ia.instr;
    }

    public Instrument getInstrument(String arrangementId) {
        for (InstrumentAssignment ia : this.arrangement) {
            if (!ia.arrangementId.equals(arrangementId)) continue;
            return ia.instr;
        }
        return null;
    }

    public void changeInstrumentId(Instrument instr, String newId) {
        for (InstrumentAssignment ia : this.arrangement) {
            if (ia.instr != instr) continue;
            String oldId = ia.arrangementId;
            ia.arrangementId = newId;
            Collections.sort(this.arrangement);
            if (this.arrangementListeners != null) {
                this.fireArrangementChanged(new ArrangementEvent(1, oldId, newId));
            }
            return;
        }
    }

    public ArrayList<InstrumentAssignment> getArrangement() {
        return this.arrangement;
    }

    public void setArrangement(ArrayList arrangement) {
        this.arrangement = arrangement;
    }

    public String generateGlobalOrc(CompileData data) {
        StrBuilder retVal = new StrBuilder();
        ArrayList<Instrument> instruments = new ArrayList<Instrument>();
        for (InstrumentAssignment ia : this.arrangement) {
            Instrument instr;
            if (!ia.enabled || instruments.contains(instr = ia.instr)) continue;
            String globalOrc = instr.generateGlobalOrc();
            if (globalOrc != null) {
                String assignmentId = data.getInstrSourceId(instr);
                if (assignmentId == null) {
                    assignmentId = ia.arrangementId;
                }
                String transformed = this.replaceInstrumentId(assignmentId, globalOrc);
                retVal.append(transformed);
                retVal.append("\n");
            }
            instruments.add(instr);
        }
        return retVal.toString();
    }

    public String generateGlobalSco(CompileData data) {
        StrBuilder retVal = new StrBuilder();
        for (InstrumentAssignment ia : this.arrangement) {
            Instrument instr;
            String globalSco;
            if (!ia.enabled || (globalSco = (instr = ia.instr).generateGlobalSco()) == null) continue;
            String assignmentId = data.getInstrSourceId(instr);
            if (assignmentId == null) {
                assignmentId = ia.arrangementId;
            }
            String transformed = this.replaceInstrumentId(assignmentId, globalSco);
            retVal.append(transformed);
            retVal.append("\n");
        }
        return retVal.toString();
    }

    public void preGenerateOrchestra(CompileData data, Mixer mixer, int nchnls, ArrayList<Instrument> alwaysOnInstruments) {
        if (this.preGenerationCache == null) {
            this.preGenerationCache = new StrBuilder();
            this.preGenList = new ArrayList();
        }
        for (InstrumentAssignment ia : this.arrangement) {
            this.preGenList.add(ia);
            if (!ia.enabled) continue;
            this.appendInstrumentText(data, this.preGenerationCache, ia, mixer, nchnls);
            Instrument alwaysOnInstr = this.createAlwaysOnInstrument(data, ia, mixer, nchnls);
            if (alwaysOnInstr == null) continue;
            alwaysOnInstruments.add(alwaysOnInstr);
            data.addInstrSourceId(alwaysOnInstr, ia.arrangementId);
        }
    }

    public String generateOrchestra(CompileData data, Mixer mixer, int nchnls) {
        StrBuilder buffer = this.preGenerationCache == null ? new StrBuilder() : this.preGenerationCache;
        for (InstrumentAssignment ia : this.arrangement) {
            if (this.preGenList.contains(ia) || !ia.enabled) continue;
            this.appendInstrumentText(data, buffer, ia, mixer, nchnls);
        }
        String retVal = buffer.toString();
        this.preGenerationCache = null;
        this.preGenList = null;
        return retVal;
    }

    private void appendInstrumentText(CompileData data, StrBuilder buffer, InstrumentAssignment ia, Mixer mixer, int nchnls) {
        Instrument instr = ia.instr;
        buffer.append("\tinstr ").append(ia.arrangementId);
        buffer.append("\t;").append(instr.getName()).append("\n");
        String instrumentText = instr.generateInstrument();
        String assignmentId = data.getInstrSourceId(instr);
        if (assignmentId == null) {
            assignmentId = ia.arrangementId;
        }
        String transformed = this.replaceInstrumentId(assignmentId, instrumentText);
        transformed = this.convertBlueMixerOut(data, mixer, ia.arrangementId, transformed, nchnls);
        buffer.append(transformed).append("\n");
        buffer.append("\tendin\n\n");
    }

    private Instrument createAlwaysOnInstrument(CompileData data, InstrumentAssignment ia, Mixer mixer, int nchnls) {
        Instrument instr = ia.instr;
        String alwaysOnInstrCode = instr.generateAlwaysOnInstrument();
        if (alwaysOnInstrCode == null || alwaysOnInstrCode.trim().isEmpty()) {
            return null;
        }
        String transformed = this.convertBlueMixerOut(data, mixer, ia.arrangementId, alwaysOnInstrCode, nchnls);
        GenericInstrument retVal = new GenericInstrument();
        retVal.setText(transformed);
        return retVal;
    }

    public void clearUnusedInstrAssignments() {
        Iterator<InstrumentAssignment> iter = this.arrangement.iterator();
        while (iter.hasNext()) {
            InstrumentAssignment ia = iter.next();
            if (ia.enabled) continue;
            iter.remove();
        }
    }

    public void generateUserDefinedOpcodes(OpcodeList udos) {
        for (InstrumentAssignment ia : this.arrangement) {
            if (!ia.enabled) continue;
            ia.instr.generateUserDefinedOpcodes(udos);
        }
    }

    public void generateFTables(Tables tables) {
        for (InstrumentAssignment ia : this.arrangement) {
            if (!ia.enabled) continue;
            ia.instr.generateFTables(tables);
        }
    }

    private String replaceInstrumentId(String arrangementId, String input) {
        String replacementId = "";
        try {
            replacementId = replacementId + Integer.parseInt(arrangementId);
        }
        catch (NumberFormatException nfe) {
            replacementId = "\"" + arrangementId + "\"";
        }
        String transformed = TextUtilities.replaceAll(input, "<INSTR_ID>", replacementId);
        transformed = TextUtilities.replaceAll(transformed, "<INSTR_NAME>", arrangementId);
        return transformed;
    }

    private Channel getChannelForArrangementId(Mixer mixer, String arrangementId) {
        if (mixer != null) {
            for (Channel channel : mixer.getAllSourceChannels()) {
                if (!channel.getName().equals(arrangementId)) continue;
                return channel;
            }
        }
        return null;
    }

    private String convertBlueMixerOut(CompileData data, Mixer mixer, String arrangementId, String input, int nchnls) {
        if (!input.contains("blueMixerOut") && !input.contains("blueMixerIn")) {
            return input;
        }
        StrBuilder buffer = new StrBuilder();
        String[] lines = NEW_LINES.split(input);
        boolean blueMixerInFound = false;
        for (String line : lines) {
            int mixerInIndex = line.indexOf("blueMixerIn");
            if (mixerInIndex > 0) {
                String noCommentLine = TextUtilities.stripSingleLineComments(line);
                if (!noCommentLine.contains("blueMixerIn")) {
                    buffer.append(line).append("\n");
                    continue;
                }
                if (mixer == null || !mixer.isEnabled()) {
                    throw new RuntimeException("Error: Instrument uses blueMixerIn but mixer is not enabled");
                }
                blueMixerInFound = true;
                String argText = noCommentLine.substring(0, mixerInIndex).trim();
                String[] args = argText.split(",");
                Channel c = this.getChannelForArrangementId(mixer, arrangementId);
                for (int i = 0; i < nchnls && i < args.length; ++i) {
                    String arg = args[i];
                    String var = c == null ? Mixer.getSubChannelVar("Master", i) : Mixer.getChannelVar(data.getChannelIdAssignments().get(c), i);
                    buffer.append(arg).append(" = ");
                    buffer.append(var).append("\n");
                }
                continue;
            }
            if (line.trim().startsWith("blueMixerOut")) {
                String argText = line.trim().substring(12);
                String[] args = argText.split(",");
                if (args[0].trim().matches("\".*\"")) {
                    if (mixer == null || !mixer.isEnabled()) {
                        buffer.append("outc ");
                        for (int i = 1; i < args.length; ++i) {
                            if (i > 1) {
                                buffer.append(",");
                            }
                            buffer.append(args[i]);
                        }
                        buffer.append("\n");
                        continue;
                    }
                    String subChanBase = args[0].trim();
                    String subChannelName = subChanBase.substring(1, subChanBase.length() - 1);
                    Optional<Channel> found = mixer.getSubChannels().stream().filter(chn -> subChannelName.equals(chn.getName())).findFirst();
                    if (!found.isPresent()) {
                        throw new RuntimeException("Unable to find subchannel with name: " + subChannelName);
                    }
                    mixer.addSubChannelDependency(subChannelName);
                    for (int i = 1; i < nchnls + 1 && i < args.length; ++i) {
                        String arg = args[i];
                        String var = Mixer.getSubChannelVar(subChannelName, i - 1);
                        buffer.append(var);
                        if (!blueMixerInFound) {
                            buffer.append(" += ");
                        } else {
                            buffer.append(" = ");
                        }
                        buffer.append(arg).append("\n");
                    }
                    continue;
                }
                if (mixer == null || !mixer.isEnabled()) {
                    buffer.append(line.replaceAll("blueMixerOut", "outc"));
                    buffer.append("\n");
                    continue;
                }
                Channel c = this.getChannelForArrangementId(mixer, arrangementId);
                for (int i = 0; i < nchnls && i < args.length; ++i) {
                    String arg = args[i];
                    String var = c == null ? Mixer.getSubChannelVar("Master", i) : Mixer.getChannelVar(data.getChannelIdAssignments().get(c), i);
                    buffer.append(var);
                    if (!blueMixerInFound) {
                        buffer.append(" += ");
                    } else {
                        buffer.append(" = ");
                    }
                    buffer.append(arg).append("\n");
                }
                continue;
            }
            buffer.append(line).append("\n");
        }
        return buffer.toString();
    }

    public static Arrangement loadFromXML(Element data) throws Exception {
        Arrangement arr = new Arrangement();
        Elements items = data.getElements("instrumentAssignment");
        while (items.hasMoreElements()) {
            Element elem = items.next();
            InstrumentAssignment ia = InstrumentAssignment.loadFromXML(elem);
            arr.getArrangement().add(ia);
        }
        return arr;
    }

    @Deprecated
    public static Arrangement loadFromXML(Element data, InstrumentLibrary iLibrary) {
        Arrangement arr = new Arrangement();
        Elements items = data.getElements("instrumentAssignment");
        while (items.hasMoreElements()) {
            Element elem = items.next();
            InstrumentAssignment ia = InstrumentAssignment.loadFromXML(elem, iLibrary);
            arr.getArrangement().add(ia);
        }
        return arr;
    }

    public Element saveAsXML() {
        Element retVal = new Element("arrangement");
        for (InstrumentAssignment ia : this.arrangement) {
            retVal.addElement(ia.saveAsXML());
        }
        return retVal;
    }

    public Instrument removeInstrument(int index) {
        InstrumentAssignment ia = this.arrangement.remove(index);
        this.fireTableDataChanged();
        if (ia.instr instanceof Automatable) {
            this.fireAutomatableRemoved((Automatable)((Object)ia.instr));
        }
        return ia.instr;
    }

    public InstrumentAssignment getInstrumentAssignment(int rowIndex) {
        return this.arrangement.get(rowIndex);
    }

    @Override
    public int getRowCount() {
        return this.size();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return "[X]";
            }
            case 1: {
                return BlueSystem.getString("arrangement.instrID");
            }
            case 2: {
                return BlueSystem.getString("arrangement.instrName");
            }
        }
        return "";
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        InstrumentAssignment ia = this.getInstrumentAssignment(rowIndex);
        switch (columnIndex) {
            case 0: {
                return ia.enabled;
            }
            case 1: {
                return ia.arrangementId;
            }
            case 2: {
                return ia.instr.getName();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col == 0) {
            InstrumentAssignment ia = this.getInstrumentAssignment(row);
            ia.enabled = (Boolean)value;
        } else if (col == 1) {
            try {
                String newId = (String)value;
                Instrument instr = this.getInstrument(row);
                this.changeInstrumentId(instr, newId);
            }
            catch (Exception e) {
                System.out.println("error in OrchestraTableModel: setValueAt");
                e.printStackTrace();
            }
        } else if (col == 2) {
            InstrumentAssignment ia = this.getInstrumentAssignment(row);
            ia.instr.setName((String)value);
        }
        this.fireTableDataChanged();
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    private void fireTableDataChanged() {
        if (this.listeners == null) {
            return;
        }
        TableModelEvent tme = new TableModelEvent(this);
        for (TableModelListener listener : this.listeners) {
            listener.tableChanged(tme);
        }
        if (this.arrangementListeners != null) {
            this.fireArrangementChanged(new ArrangementEvent(0, null, null));
        }
    }

    public void addArrangementListener(ArrangementListener l) {
        if (this.arrangementListeners == null) {
            this.arrangementListeners = new Vector();
        }
        this.arrangementListeners.add(l);
    }

    public void removeArrangementListener(ArrangementListener l) {
        if (this.arrangementListeners == null) {
            return;
        }
        this.arrangementListeners.remove(l);
    }

    private void fireArrangementChanged(ArrangementEvent arrEvt) {
        if (this.arrangementListeners == null) {
            return;
        }
        for (ArrangementListener listener : this.arrangementListeners) {
            listener.arrangementChanged(arrEvt);
        }
    }

    public void addAutomatableCollectionListener(AutomatableCollectionListener listener) {
        if (this.automatableCollectionListeners == null) {
            this.automatableCollectionListeners = new Vector();
        }
        this.automatableCollectionListeners.add(listener);
    }

    public void removeAutomatableCollectionListener(AutomatableCollectionListener listener) {
        if (this.automatableCollectionListeners != null) {
            this.automatableCollectionListeners.remove(listener);
        }
    }

    private void fireAutomatableAdded(Automatable automatable) {
        if (this.automatableCollectionListeners != null) {
            for (AutomatableCollectionListener listener : new Vector<AutomatableCollectionListener>(this.automatableCollectionListeners)) {
                listener.automatableAdded(automatable);
            }
        }
    }

    private void fireAutomatableRemoved(Automatable automatable) {
        if (this.automatableCollectionListeners != null) {
            for (AutomatableCollectionListener listener : new Vector<AutomatableCollectionListener>(this.automatableCollectionListeners)) {
                listener.automatableRemoved(automatable);
            }
        }
    }
}

