/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.soundLayer;

import blue.SoundLayer;
import blue.noteProcessor.NoteProcessorChainMap;
import blue.soundObject.PolyObject;
import blue.ui.core.score.soundLayer.LayersPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class SoundLayerListPanel
extends JPanel {
    private PolyObject pObj;
    LayersPanel layers = new LayersPanel();
    LayerHeightPopup heightPopup = null;

    public SoundLayerListPanel() {
        this.initComponents();
        this.add((Component)this.layers, "Center");
    }

    public void setPolyObject(PolyObject pObj) {
        this.pObj = pObj;
        this.layers.setPolyObject(pObj);
    }

    public void setNoteProcessorChainMap(NoteProcessorChainMap npcMap) {
        this.layers.setNoteProcessorChainMap(npcMap);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private class LayerHeightPopup
    extends JPopupMenu {
        JMenuItem[] heightItems = new JMenuItem[9];

        public LayerHeightPopup() {
            ActionListener allListener = ae -> {
                if (SoundLayerListPanel.this.pObj == null) {
                    return;
                }
                int heightIndex = Integer.parseInt(ae.getActionCommand()) - 1;
                for (int i = 0; i < SoundLayerListPanel.this.pObj.size(); ++i) {
                    SoundLayer temp = (SoundLayer)SoundLayerListPanel.this.pObj.get(i);
                    temp.setHeightIndex(heightIndex);
                }
            };
            ActionListener defaultListener = ae -> {
                if (SoundLayerListPanel.this.pObj == null) {
                    return;
                }
                int heightIndex = Integer.parseInt(ae.getActionCommand()) - 1;
                SoundLayerListPanel.this.pObj.setDefaultHeightIndex(heightIndex);
            };
            JMenu setAllMenu = new JMenu("Set All Layer Heights");
            for (int i = 0; i < this.heightItems.length; ++i) {
                JMenuItem item = new JMenuItem(Integer.toString(i + 1));
                item.addActionListener(allListener);
                setAllMenu.add(item);
            }
            JMenu setDefaultMenu = new JMenu("Set Default Layer Height");
            for (int i = 0; i < this.heightItems.length; ++i) {
                this.heightItems[i] = new JMenuItem(Integer.toString(i + 1));
                this.heightItems[i].addActionListener(defaultListener);
                setDefaultMenu.add(this.heightItems[i]);
            }
            this.add(setAllMenu);
            this.add(setDefaultMenu);
            this.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    if (SoundLayerListPanel.this.pObj == null) {
                        return;
                    }
                    int defaultHeightIndex = SoundLayerListPanel.this.pObj.getDefaultHeightIndex();
                    for (int i = 0; i < LayerHeightPopup.this.heightItems.length; ++i) {
                        LayerHeightPopup.this.heightItems[i].setEnabled(i != defaultHeightIndex);
                    }
                }
            });
        }
    }
}

