/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score.layers.soundObject;

import blue.components.ColorSelectionPanel;
import blue.components.PropertyEditor;
import blue.noteProcessor.NoteProcessorChainMap;
import blue.score.ScoreObject;
import blue.score.ScoreObjectEvent;
import blue.score.ScoreObjectListener;
import blue.soundObject.SoundObject;
import blue.ui.core.score.NoteProcessorChainEditor;
import blue.ui.core.score.layers.SoundObjectProvider;
import blue.ui.core.score.undo.ResizeScoreObjectEdit;
import blue.ui.core.score.undo.StartTimeEdit;
import blue.ui.utilities.SimpleDocumentListener;
import blue.undo.BlueUndoManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.undo.UndoableEdit;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="SoundObjectPropertiesTopComponent", persistenceType=0)
public final class SoundObjectPropertiesTopComponent
extends TopComponent
implements ScoreObjectListener,
LookupListener {
    private ScoreObject sObj = null;
    private static SoundObjectPropertiesTopComponent instance;
    PropertyEditor propEdittor = new PropertyEditor();
    private boolean isUpdating = false;
    Lookup.Result<ScoreObject> result = null;
    NoteProcessorChainEditor noteProcessorChainEditor2 = new NoteProcessorChainEditor();
    private ColorSelectionPanel colorPanel;
    private JTextField endTimeText;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel8;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextField nameText;
    private JPanel npcEditorPanel;
    private JLabel repeatPointLabel;
    private JTextField repeatePointText;
    private JTextField startTimeText;
    private JTextField subjectiveDurationText;
    private JComboBox timeBehaviorBox;
    private JLabel timeBehaviorLabel;
    private JLabel useRepeatLabel;
    private JCheckBox useRepeatPoint;

    private SoundObjectPropertiesTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(SoundObjectPropertiesTopComponent.class, (String)"CTL_SoundObjectPropertiesTopComponent"));
        this.setToolTipText(NbBundle.getMessage(SoundObjectPropertiesTopComponent.class, (String)"HINT_SoundObjectPropertiesTopComponent"));
        this.npcEditorPanel.setLayout(new BorderLayout());
        this.npcEditorPanel.add((Component)this.noteProcessorChainEditor2, "Center");
        this.noteProcessorChainEditor2.setMinimumSize(new Dimension(0, 0));
        this.nameText.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (SoundObjectPropertiesTopComponent.this.nameText.getText() != null && SoundObjectPropertiesTopComponent.this.sObj != null) {
                    SoundObjectPropertiesTopComponent.this.isUpdating = true;
                    SoundObjectPropertiesTopComponent.this.updateName();
                    SoundObjectPropertiesTopComponent.this.isUpdating = false;
                }
            }
        });
    }

    private void setScoreObject(ScoreObject scoreObj) {
        SoundObject soundObj = null;
        if (scoreObj instanceof SoundObject) {
            soundObj = (SoundObject)scoreObj;
        }
        this.isUpdating = true;
        if (this.sObj != null) {
            this.sObj.removeScoreObjectListener((ScoreObjectListener)this);
        }
        if (scoreObj == null) {
            this.sObj = null;
            this.disableFields();
            this.propEdittor.editObject(null);
            this.noteProcessorChainEditor2.setNoteProcessorChain(null);
        } else {
            this.enableFields();
            this.setFieldsVisible(soundObj != null);
            this.sObj = scoreObj;
            this.updateProperties();
            this.colorPanel.setColor(this.sObj.getBackgroundColor());
            if (soundObj != null) {
                this.noteProcessorChainEditor2.setNoteProcessorChain(soundObj.getNoteProcessorChain());
                int timeBehavior = soundObj.getTimeBehavior();
                if (timeBehavior == -1) {
                    this.timeBehaviorBox.setEnabled(false);
                    this.useRepeatPoint.setEnabled(false);
                    this.repeatePointText.setEnabled(false);
                } else {
                    this.timeBehaviorBox.setEnabled(true);
                    this.timeBehaviorBox.setSelectedIndex(timeBehavior);
                    if (timeBehavior == 1) {
                        this.useRepeatPoint.setEnabled(true);
                        double repeatPoint = soundObj.getRepeatPoint();
                        if (repeatPoint <= 0.0) {
                            this.useRepeatPoint.setSelected(false);
                            this.repeatePointText.setEnabled(false);
                        } else {
                            this.useRepeatPoint.setSelected(true);
                            this.repeatePointText.setEnabled(true);
                            this.repeatePointText.setText(Double.toString(repeatPoint));
                        }
                    } else {
                        this.useRepeatPoint.setEnabled(false);
                        this.repeatePointText.setEnabled(false);
                    }
                }
            }
            this.propEdittor.editObject(null);
            this.sObj.addScoreObjectListener((ScoreObjectListener)this);
        }
        this.isUpdating = false;
    }

    private void updateProperties() {
        if (this.sObj != null) {
            this.startTimeText.setText(Double.toString(this.sObj.getStartTime()));
            this.nameText.setText(this.sObj.getName());
            this.subjectiveDurationText.setText(Double.toString(this.sObj.getSubjectiveDuration()));
            if (this.sObj instanceof SoundObject) {
                double repeatPoint = ((SoundObject)this.sObj).getRepeatPoint();
                this.repeatePointText.setText(Double.toString(repeatPoint));
            }
            this.updateEndTime();
        }
    }

    private void updateEndTime() {
        this.endTimeText.setText(Double.toString(this.sObj.getStartTime() + this.sObj.getSubjectiveDuration()));
    }

    protected void updateName() {
        this.sObj.setName(this.nameText.getText());
    }

    protected void updateColor() {
        this.sObj.setBackgroundColor(this.colorPanel.getColor());
    }

    protected void updateStartTime() {
        double newValue;
        double initialStart = this.sObj.getStartTime();
        try {
            newValue = Double.parseDouble(this.startTimeText.getText());
        }
        catch (NumberFormatException nfe) {
            this.startTimeText.setText(Double.toString(initialStart));
            return;
        }
        if (newValue < 0.0) {
            newValue = 0.0;
            this.startTimeText.setText("0.0");
        }
        this.sObj.setStartTime(newValue);
        BlueUndoManager.setUndoManager((String)"score");
        BlueUndoManager.addEdit((UndoableEdit)new StartTimeEdit(initialStart, newValue, this.sObj));
    }

    protected void updateSubjectiveDuration() {
        double newValue;
        double initialDuration = this.sObj.getSubjectiveDuration();
        try {
            newValue = Double.parseDouble(this.subjectiveDurationText.getText());
        }
        catch (NumberFormatException nfe) {
            this.subjectiveDurationText.setText(Double.toString(initialDuration));
            return;
        }
        this.sObj.setSubjectiveDuration(newValue);
        BlueUndoManager.setUndoManager((String)"score");
        BlueUndoManager.addEdit((UndoableEdit)new ResizeScoreObjectEdit(this.sObj, initialDuration, this.sObj.getSubjectiveDuration()));
    }

    private void updateTimeBehavior() {
        if (!(this.sObj instanceof ScoreObject)) {
            return;
        }
        SoundObject soundObj = (SoundObject)this.sObj;
        soundObj.setTimeBehavior(this.timeBehaviorBox.getSelectedIndex());
        if (this.timeBehaviorBox.getSelectedIndex() == 1) {
            boolean repeatPointUsed = soundObj.getRepeatPoint() > 0.0;
            this.useRepeatPoint.setSelected(repeatPointUsed);
            this.useRepeatPoint.setEnabled(true);
            this.repeatePointText.setEnabled(repeatPointUsed);
        } else {
            this.useRepeatPoint.setSelected(false);
            this.useRepeatPoint.setEnabled(false);
            this.repeatePointText.setEnabled(false);
            if (!this.isUpdating) {
                soundObj.setRepeatPoint(-1.0);
            }
        }
    }

    private void updateUseRepeatPoint() {
        if (!(this.sObj instanceof ScoreObject)) {
            return;
        }
        SoundObject soundObj = (SoundObject)this.sObj;
        this.repeatePointText.setEnabled(this.useRepeatPoint.isSelected());
        if (!this.isUpdating) {
            double dur = -1.0;
            if (this.useRepeatPoint.isSelected()) {
                dur = this.sObj.getSubjectiveDuration();
            }
            soundObj.setRepeatPoint(dur);
            this.repeatePointText.setText(Double.toString(dur));
        }
    }

    protected void updateRepeatPoint() {
        double newValue;
        if (!(this.sObj instanceof ScoreObject)) {
            return;
        }
        SoundObject soundObj = (SoundObject)this.sObj;
        double initialRepeatPoint = soundObj.getRepeatPoint();
        try {
            newValue = Double.parseDouble(this.repeatePointText.getText());
        }
        catch (NumberFormatException nfe) {
            this.repeatePointText.setText(Double.toString(initialRepeatPoint));
            return;
        }
        if (newValue <= 0.0) {
            this.repeatePointText.setText(Double.toString(initialRepeatPoint));
            return;
        }
        soundObj.setRepeatPoint(newValue);
        this.repeatePointText.setText(Double.toString(newValue));
    }

    private void setFieldsVisible(boolean isSoundObject) {
        this.timeBehaviorBox.setVisible(isSoundObject);
        this.useRepeatPoint.setVisible(isSoundObject);
        this.repeatePointText.setVisible(isSoundObject);
        this.npcEditorPanel.setVisible(isSoundObject);
        this.timeBehaviorLabel.setVisible(isSoundObject);
        this.repeatPointLabel.setVisible(isSoundObject);
        this.useRepeatLabel.setVisible(isSoundObject);
    }

    private void enableFields() {
        this.nameText.setEnabled(true);
        this.startTimeText.setEnabled(true);
        this.subjectiveDurationText.setEnabled(true);
        this.timeBehaviorBox.setEnabled(true);
        this.repeatePointText.setEnabled(true);
        this.colorPanel.setVisible(true);
    }

    private void disableFields() {
        this.nameText.setText("");
        this.nameText.setEnabled(false);
        this.startTimeText.setText("");
        this.startTimeText.setEnabled(false);
        this.subjectiveDurationText.setText("");
        this.subjectiveDurationText.setEnabled(false);
        this.endTimeText.setText("");
        this.timeBehaviorBox.setEnabled(false);
        this.useRepeatPoint.setEnabled(false);
        this.repeatePointText.setText("");
        this.repeatePointText.setEnabled(false);
        this.colorPanel.setVisible(false);
    }

    public void setNoteProcessorChainMap(NoteProcessorChainMap npcMap) {
        this.noteProcessorChainEditor2.setNoteProcessorChainMap(npcMap);
    }

    private void setLibraryItem(boolean isLibrary) {
        this.startTimeText.setEnabled(!isLibrary);
    }

    public void scoreObjectChanged(ScoreObjectEvent event) {
        if (event.getScoreObject() != this.sObj) {
            return;
        }
        switch (event.getPropertyChanged()) {
            case 0: {
                if (this.isUpdating) break;
                this.nameText.setText(this.sObj.getName());
                break;
            }
            case 1: {
                this.startTimeText.setText(Double.toString(this.sObj.getStartTime()));
                this.updateEndTime();
                break;
            }
            case 2: {
                this.subjectiveDurationText.setText(Double.toString(this.sObj.getSubjectiveDuration()));
                this.updateEndTime();
                break;
            }
            case 3: {
                this.colorPanel.setColor(this.sObj.getBackgroundColor());
            }
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.colorPanel = new ColorSelectionPanel();
        this.jLabel4 = new JLabel();
        this.useRepeatPoint = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.subjectiveDurationText = new JTextField();
        this.jLabel3 = new JLabel();
        this.nameText = new JTextField();
        this.repeatePointText = new JTextField();
        this.timeBehaviorBox = new JComboBox();
        this.useRepeatLabel = new JLabel();
        this.timeBehaviorLabel = new JLabel();
        this.startTimeText = new JTextField();
        this.endTimeText = new JTextField();
        this.repeatPointLabel = new JLabel();
        this.jLabel8 = new JLabel();
        this.npcEditorPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1.setBorder(null);
        this.colorPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                SoundObjectPropertiesTopComponent.this.colorPanelPropertyChange(evt);
            }
        });
        GroupLayout colorPanelLayout = new GroupLayout(this.colorPanel);
        this.colorPanel.setLayout(colorPanelLayout);
        colorPanelLayout.setHorizontalGroup(colorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        colorPanelLayout.setVerticalGroup(colorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(SoundObjectPropertiesTopComponent.class, (String)"SoundObjectPropertiesTopComponent.jLabel4.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.useRepeatPoint, (String)NbBundle.getMessage(SoundObjectPropertiesTopComponent.class, (String)"SoundObjectPropertiesTopComponent.useRepeatPoint.text"));
        this.useRepeatPoint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundObjectPropertiesTopComponent.this.useRepeatPointActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SoundObjectPropertiesTopComponent.class, (String)"SoundObjectPropertiesTopComponent.jLabel1.text"));
        this.subjectiveDurationText.setText(NbBundle.getMessage(SoundObjectPropertiesTopComponent.class, (String)"SoundObjectPropertiesTopComponent.subjectiveDurationText.text"));
        this.subjectiveDurationText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundObjectPropertiesTopComponent.this.subjectiveDurationTextActionPerformed(evt);
            }
        });
        this.subjectiveDurationText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SoundObjectPropertiesTopComponent.this.subjectiveDurationTextFocusLost(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SoundObjectPropertiesTopComponent.class, (String)"SoundObjectPropertiesTopComponent.jLabel3.text"));
        this.nameText.setText(NbBundle.getMessage(SoundObjectPropertiesTopComponent.class, (String)"SoundObjectPropertiesTopComponent.nameText.text"));
        this.nameText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundObjectPropertiesTopComponent.this.nameTextActionPerformed(evt);
            }
        });
        this.nameText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SoundObjectPropertiesTopComponent.this.nameTextFocusLost(evt);
            }
        });
        this.repeatePointText.setText(NbBundle.getMessage(SoundObjectPropertiesTopComponent.class, (String)"SoundObjectPropertiesTopComponent.repeatePointText.text"));
        this.repeatePointText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundObjectPropertiesTopComponent.this.repeatePointTextActionPerformed(evt);
            }
        });
        this.repeatePointText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SoundObjectPropertiesTopComponent.this.repeatePointTextFocusLost(evt);
            }
        });
        this.timeBehaviorBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Scale", "Repeat", "None"}));
        this.timeBehaviorBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundObjectPropertiesTopComponent.this.timeBehaviorBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.useRepeatLabel, (String)NbBundle.getMessage(SoundObjectPropertiesTopComponent.class, (String)"SoundObjectPropertiesTopComponent.useRepeatLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.timeBehaviorLabel, (String)NbBundle.getMessage(SoundObjectPropertiesTopComponent.class, (String)"SoundObjectPropertiesTopComponent.timeBehaviorLabel.text"));
        this.startTimeText.setText(NbBundle.getMessage(SoundObjectPropertiesTopComponent.class, (String)"SoundObjectPropertiesTopComponent.startTimeText.text"));
        this.startTimeText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SoundObjectPropertiesTopComponent.this.startTimeTextActionPerformed(evt);
            }
        });
        this.startTimeText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SoundObjectPropertiesTopComponent.this.startTimeTextFocusLost(evt);
            }
        });
        this.endTimeText.setEditable(false);
        this.endTimeText.setText(NbBundle.getMessage(SoundObjectPropertiesTopComponent.class, (String)"SoundObjectPropertiesTopComponent.endTimeText.text"));
        Mnemonics.setLocalizedText((JLabel)this.repeatPointLabel, (String)NbBundle.getMessage(SoundObjectPropertiesTopComponent.class, (String)"SoundObjectPropertiesTopComponent.repeatPointLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel8, (String)NbBundle.getMessage(SoundObjectPropertiesTopComponent.class, (String)"SoundObjectPropertiesTopComponent.jLabel8.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SoundObjectPropertiesTopComponent.class, (String)"SoundObjectPropertiesTopComponent.jLabel2.text"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.npcEditorPanel, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4, GroupLayout.Alignment.TRAILING).addComponent(this.timeBehaviorLabel, GroupLayout.Alignment.TRAILING).addComponent(this.useRepeatLabel, GroupLayout.Alignment.TRAILING).addComponent(this.repeatPointLabel, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel8, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.colorPanel, -1, -1, Short.MAX_VALUE).addComponent(this.nameText).addComponent(this.repeatePointText).addComponent(this.endTimeText).addComponent(this.subjectiveDurationText).addComponent(this.startTimeText).addComponent(this.timeBehaviorBox, 0, -1, Short.MAX_VALUE).addComponent(this.useRepeatPoint)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.nameText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.startTimeText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.subjectiveDurationText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.endTimeText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.colorPanel, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.timeBehaviorLabel).addComponent(this.timeBehaviorBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.useRepeatLabel).addComponent(this.useRepeatPoint)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.repeatPointLabel).addComponent(this.repeatePointText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.npcEditorPanel, -1, 38, Short.MAX_VALUE).addContainerGap()));
        this.jScrollPane1.setViewportView(this.jPanel1);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 245, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 341, Short.MAX_VALUE));
    }

    private void timeBehaviorBoxActionPerformed(ActionEvent evt) {
        this.updateTimeBehavior();
    }

    private void colorPanelPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("colorSelectionValue")) {
            this.updateColor();
        }
    }

    private void nameTextFocusLost(FocusEvent evt) {
        if (this.nameText.getText() != null && this.sObj != null) {
            this.updateName();
        }
    }

    private void nameTextActionPerformed(ActionEvent evt) {
        if (this.nameText.getText() != null && this.sObj != null) {
            this.updateName();
        }
    }

    private void subjectiveDurationTextActionPerformed(ActionEvent evt) {
        if (this.sObj != null) {
            this.updateSubjectiveDuration();
        }
    }

    private void subjectiveDurationTextFocusLost(FocusEvent evt) {
        if (this.sObj != null) {
            this.updateSubjectiveDuration();
        }
    }

    private void useRepeatPointActionPerformed(ActionEvent evt) {
        this.updateUseRepeatPoint();
    }

    private void repeatePointTextFocusLost(FocusEvent evt) {
        if (this.repeatePointText.getText() != null && this.sObj != null) {
            this.updateRepeatPoint();
        }
    }

    private void repeatePointTextActionPerformed(ActionEvent evt) {
        if (this.repeatePointText.getText() != null && this.sObj != null) {
            this.updateRepeatPoint();
        }
    }

    private void startTimeTextFocusLost(FocusEvent evt) {
        if (this.startTimeText.getText() != null && this.sObj != null) {
            this.updateStartTime();
        }
    }

    private void startTimeTextActionPerformed(ActionEvent evt) {
        if (this.startTimeText.getText() != null && this.sObj != null) {
            this.updateStartTime();
        }
    }

    public void componentOpened() {
        this.result = Utilities.actionsGlobalContext().lookupResult(ScoreObject.class);
        this.result.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    public void componentClosed() {
        this.result.removeLookupListener((LookupListener)this);
    }

    protected void componentActivated() {
        super.componentActivated();
        if (this.nameText.isEnabled()) {
            this.nameText.requestFocus();
        }
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    public void resultChanged(LookupEvent ev) {
        if (!(TopComponent.getRegistry().getActivated() instanceof SoundObjectProvider)) {
            return;
        }
        Collection scoreObjects = this.result.allInstances();
        if (scoreObjects.size() == 1) {
            this.setScoreObject((ScoreObject)scoreObjects.iterator().next());
        } else {
            this.setScoreObject(null);
        }
    }
}

