/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.score;

import blue.BlueData;
import blue.Marker;
import blue.MarkersList;
import blue.score.TimeState;
import blue.services.render.RenderTimeManager;
import blue.services.render.RenderTimeManagerListener;
import blue.settings.PlaybackSettings;
import blue.ui.utilities.BlueGradientFactory;
import blue.ui.utilities.UiUtilities;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.openide.util.Lookup;

public final class TimeBar
extends JPanel
implements PropertyChangeListener,
TableModelListener,
RenderTimeManagerListener {
    private static final Font LABEL_FONT = new Font("dialog", 0, 11);
    private BlueData data;
    private TimeState timeState;
    private Rectangle scrollRect = new Rectangle(0, 0, 1, 1);
    private double renderStart = 0.0;
    private double timePointer = 0.0;
    private boolean rootTimeline = true;
    RenderTimeManager renderTimeManager = (RenderTimeManager)Lookup.getDefault().lookup(RenderTimeManager.class);

    public TimeBar() {
        this.setDoubleBuffered(true);
        this.setLayout(null);
        this.addMouseListener(new MouseAdapter(){
            int start;

            @Override
            public void mousePressed(MouseEvent e) {
                if (!TimeBar.this.rootTimeline) {
                    return;
                }
                this.start = e.getX();
                if (this.start < 0) {
                    this.start = 0;
                }
                double time = (double)this.start / (double)TimeBar.this.timeState.getPixelSecond();
                if (TimeBar.this.timeState.isSnapEnabled() && !e.isShiftDown()) {
                    time = (double)Math.round(time / TimeBar.this.timeState.getSnapValue()) * TimeBar.this.timeState.getSnapValue();
                }
                if (SwingUtilities.isLeftMouseButton(e)) {
                    if (e.isShiftDown() && TimeBar.this.rootTimeline) {
                        TimeBar.this.data.getMarkersList().addMarker(time);
                    } else {
                        TimeBar.this.data.setRenderStartTime(time);
                    }
                } else if (UiUtilities.isRightMouseButton((MouseEvent)e)) {
                    TimeBar.this.data.setRenderEndTime(time);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!TimeBar.this.rootTimeline) {
                    return;
                }
                int start = e.getX();
                if (start < 0) {
                    start = 0;
                }
                double time = (double)start / (double)TimeBar.this.timeState.getPixelSecond();
                if (TimeBar.this.timeState.isSnapEnabled() && !e.isShiftDown()) {
                    time = (double)Math.round(time / TimeBar.this.timeState.getSnapValue()) * TimeBar.this.timeState.getSnapValue();
                }
                if (SwingUtilities.isLeftMouseButton(e)) {
                    TimeBar.this.data.setRenderStartTime(time);
                } else if (UiUtilities.isRightMouseButton((MouseEvent)e)) {
                    TimeBar.this.data.setRenderEndTime(time);
                    TimeBar.this.checkScroll(e.getPoint());
                }
            }
        });
        this.renderTimeManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.renderTimeManager.addRenderTimeManagerListener((RenderTimeManagerListener)this);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Paint p = g2d.getPaint();
        g2d.setPaint(BlueGradientFactory.getGradientPaint((Color)this.getBackground()));
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setPaint(p);
        if (this.timeState == null || this.getHeight() == 0 || this.getWidth() == 0) {
            return;
        }
        this.drawLinesAndNumbers(g);
        if (this.rootTimeline) {
            double latency;
            g.setColor(Color.GREEN);
            int x = (int)(this.data.getRenderStartTime() * (double)this.timeState.getPixelSecond());
            g.drawLine(x, 0, x, this.getHeight());
            double renderLoopTime = this.data.getRenderEndTime();
            if (renderLoopTime >= 0.0) {
                g.setColor(Color.YELLOW);
                x = (int)(this.data.getRenderEndTime() * (double)this.timeState.getPixelSecond());
                g.drawLine(x, 0, x, this.getHeight());
            }
            if (this.renderTimeManager.isCurrentProjectRendering() && this.timePointer > (latency = (double)PlaybackSettings.getInstance().getPlaybackLatencyCorrection()) && this.renderStart >= 0.0) {
                g.setColor(Color.ORANGE);
                x = (int)((this.timePointer + this.renderStart - latency) * (double)this.timeState.getPixelSecond());
                g.drawLine(x, 0, x, this.getHeight());
            }
        }
    }

    private void drawLinesAndNumbers(Graphics g) {
        int i;
        Rectangle bounds = g.getClipBounds();
        int h = 19;
        int timeDisplay = this.timeState.getTimeDisplay();
        FontMetrics fontMetrics = g.getFontMetrics();
        int textWidth = timeDisplay == 0 ? fontMetrics.stringWidth("00:00") : fontMetrics.stringWidth("000");
        int pixelTime = this.timeState.getPixelSecond();
        int timeUnit = this.timeState.getTimeUnit();
        LookAndFeel lnf = UIManager.getLookAndFeel();
        g.setColor(this.getForeground());
        int startX = bounds.x;
        int endX = startX + bounds.width;
        g.drawLine(startX, h, endX, h);
        int lastVal = 0;
        int divisions = this.getWidth() / pixelTime;
        int longHeight = h - 6;
        int shortHeight = h - 3;
        int start = startX / pixelTime;
        int end = endX / pixelTime + 1;
        end = end > divisions ? divisions : end;
        for (i = start; i < end; ++i) {
            int lineX = i * pixelTime;
            if (i % timeUnit == 0) {
                if (lineX == 0 || lineX - lastVal > textWidth) {
                    g.drawLine(lineX, h, lineX, longHeight);
                    lastVal = lineX;
                    continue;
                }
                g.drawLine(lineX, h, lineX, shortHeight);
                continue;
            }
            g.drawLine(lineX, h, lineX, shortHeight);
        }
        g.setFont(LABEL_FONT);
        lastVal = 0;
        for (i = start; i < end; ++i) {
            if (i % timeUnit != 0) continue;
            String time = "";
            if (timeDisplay == 0) {
                int min = i / 60;
                int sec = i % 60;
                String seconds = sec < 10 ? "0" + sec : String.valueOf(sec);
                time = min + ":" + seconds;
            } else if (timeDisplay == 1) {
                time = Integer.toString(i);
            }
            int labelX = i * pixelTime;
            if (labelX != 0 && labelX - lastVal <= textWidth) continue;
            g.drawString(time, labelX + 3, 14);
            lastVal = labelX;
        }
    }

    public void setData(BlueData data) {
        if (this.data != null) {
            this.data.removePropertyChangeListener((PropertyChangeListener)this);
            this.data.getMarkersList().removeTableModelListener((TableModelListener)this);
        }
        this.data = data;
        data.addPropertyChangeListener((PropertyChangeListener)this);
        data.getMarkersList().addTableModelListener((TableModelListener)this);
        this.setTimeState(data.getScore().getTimeState());
    }

    public boolean isRootTimeline() {
        return this.rootTimeline;
    }

    public void setRootTimeline(boolean rootTimeline) {
        this.rootTimeline = rootTimeline;
    }

    protected void setTimeState(TimeState timeState) {
        if (this.timeState != null) {
            this.timeState.removePropertyChangeListener((PropertyChangeListener)this);
        }
        Component[] components = this.getComponents();
        this.removeAll();
        for (Component component : components) {
            if (!(component instanceof PlayMarker)) continue;
            ((PlayMarker)component).cleanup();
        }
        this.timeState = timeState;
        if (this.rootTimeline) {
            this.initializeMarkers();
        }
        this.timeState.addPropertyChangeListener((PropertyChangeListener)this);
        this.repaint();
    }

    private void initializeMarkers() {
        if (this.data == null) {
            return;
        }
        MarkersList markers = this.data.getMarkersList();
        for (int i = 0; i < markers.size(); ++i) {
            Marker m = markers.getMarker(i);
            PlayMarker pm = new PlayMarker(m);
            int x = (int)(m.getTime() * (double)this.timeState.getPixelSecond());
            pm.setLocation(x, 0);
            this.add(pm);
        }
    }

    private void checkScroll(Point p) {
        JScrollPane scrollPane = (JScrollPane)this.getParent().getParent().getParent();
        Point newPoint = new Point(p.x, scrollPane.getViewport().getViewPosition().y);
        this.scrollRect.setLocation(newPoint);
        JComponent view = (JComponent)scrollPane.getViewport().getView();
        view.scrollRectToVisible(this.scrollRect);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (evt.getSource() == this.data && (prop.equals("renderStartTime") || prop.equals("renderLoopTime"))) {
            this.repaint();
        } else if (evt.getSource() == this.timeState) {
            if (prop.equals("timeDisplay") || prop.equals("timeUnit") || prop.equals("pixelSecond")) {
                if (this.rootTimeline) {
                    Component[] components = this.getComponents();
                    this.removeAll();
                    for (Component component : components) {
                        if (!(component instanceof PlayMarker)) continue;
                        ((PlayMarker)component).cleanup();
                    }
                    this.initializeMarkers();
                }
                this.repaint();
            }
        } else if (evt.getSource() == this.renderTimeManager && prop.equals("renderStart")) {
            this.renderStart = (Double)evt.getNewValue();
            this.timePointer = -1.0;
            this.repaint();
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() == -1 || e.getType() == 1) {
            Component[] components = this.getComponents();
            this.removeAll();
            for (Component component : components) {
                if (!(component instanceof PlayMarker)) continue;
                ((PlayMarker)component).cleanup();
            }
            this.initializeMarkers();
            this.repaint();
        }
    }

    public void renderInitiated() {
    }

    public void renderEnded() {
    }

    public void renderTimeUpdated(double timePointer) {
        this.timePointer = timePointer;
        this.repaint();
    }

    class PlayMarker
    extends JComponent
    implements PropertyChangeListener {
        int w = 10;
        int h = 10;
        int[] xPoints = new int[]{0, 0, this.w};
        int[] yPoints = new int[]{0, this.h, 0};
        private Marker marker;
        private int originX = -1;

        public PlayMarker(Marker marker) {
            ToolTipManager.sharedInstance().registerComponent(this);
            Dimension d = new Dimension(10, 11);
            this.setSize(d);
            this.marker = marker;
            marker.addPropertyChangeListener((PropertyChangeListener)this);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    PlayMarker.this.originX = e.getX();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    PlayMarker.this.originX = -1;
                    if (!PlayMarker.this.isVisible()) {
                        TimeBar.this.data.getMarkersList().removeMarker(PlayMarker.this.marker);
                        PlayMarker.this.cleanup();
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (PlayMarker.this.originX >= 0) {
                        PlayMarker playMarker = PlayMarker.this;
                        Container parent = playMarker.getParent();
                        Point p = SwingUtilities.convertPoint(playMarker, e.getPoint(), parent);
                        int newX = p.x - PlayMarker.this.originX;
                        if (newX < 0) {
                            newX = 0;
                        }
                        if (p.y > parent.getHeight()) {
                            PlayMarker.this.setVisible(false);
                            return;
                        }
                        PlayMarker.this.setVisible(true);
                        double newTime = (double)newX / (double)TimeBar.this.timeState.getPixelSecond();
                        playMarker.setLocation(newX, 0);
                        playMarker.marker.setTime(newTime);
                        TimeBar.this.checkScroll(p);
                    }
                }
            });
        }

        @Override
        public String getToolTipText() {
            return this.marker.getName() + " [" + this.marker.getTime() + "]";
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            BasicStroke stroke = new BasicStroke(2.0f, 1, 1);
            g2d.setStroke(stroke);
            g2d.setColor(Color.ORANGE.brighter().brighter());
            g2d.fillPolygon(this.xPoints, this.yPoints, 3);
            g2d.setColor(Color.ORANGE);
            g2d.drawPolygon(this.xPoints, this.yPoints, 3);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() == this.marker && evt.getPropertyName().equals("time")) {
                double time = (Double)evt.getNewValue();
                int x = (int)((double)TimeBar.this.timeState.getPixelSecond() * time);
                this.setLocation(x, 0);
            }
        }

        public void cleanup() {
            if (this.marker != null) {
                this.marker.removePropertyChangeListener((PropertyChangeListener)this);
            }
            this.marker = null;
        }
    }
}

