/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.orchestra.editor.blueX7;

import blue.orchestra.BlueX7;
import blue.ui.core.orchestra.editor.blueX7.BlueX7SysexReader;
import blue.ui.utilities.FileChooserManager;
import java.io.File;
import java.util.List;
import javax.swing.JOptionPane;

public class BlueX7ImportDialog {
    private static final String FILE_IMPORT = "blueX7ImportDialog";

    public static void importFromDX7File(BlueX7 blueX7) {
        List retVal = FileChooserManager.getDefault().showOpenDialog((Object)FILE_IMPORT, null);
        if (retVal.isEmpty()) {
            return;
        }
        File temp = (File)retVal.get(0);
        byte[] sysex = BlueX7SysexReader.fileToByteArray(temp);
        if (sysex == null) {
            JOptionPane.showMessageDialog(null, "Could not read file as DX7 sysex.", "Error Importing", 0);
            return;
        }
        int sysexType = BlueX7SysexReader.getSysexType(sysex);
        if (sysexType == 0) {
            BlueX7SysexReader.importFromSinglePatch(blueX7, sysex);
        } else if (sysexType == 1) {
            Object[] patches = BlueX7SysexReader.getNameListFromBank(sysex);
            Object selectedValue = JOptionPane.showInputDialog(null, "Choose Patch from Bank", "Input", 1, null, patches, patches[0]);
            int patchNum = 0;
            for (int i = 0; i < patches.length; ++i) {
                if (patches[i] != selectedValue) continue;
                patchNum = i;
                break;
            }
            BlueX7SysexReader.importFromBank(blueX7, sysex, patchNum);
            System.out.println("selected patch was: " + patchNum + " : " + (String)patches[patchNum]);
        } else {
            JOptionPane.showMessageDialog(null, "Could not read file as DX7 sysex.", "Error Importing", 0);
            return;
        }
    }

    public static void main(String[] args) {
    }

    static {
        FileChooserManager.getDefault().setDialogTitle((Object)FILE_IMPORT, "Open DX7 Sysex File");
    }
}

