/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.midi;

import blue.midi.MidiInputProcessor;
import blue.midi.MidiKeyMapping;
import blue.midi.MidiVelocityMapping;
import blue.soundObject.editor.pianoRoll.ScaleSelectionPanel;
import blue.ui.utilities.SimpleDocumentListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.util.NbBundle;

public class MidiInputProcessorPanel
extends JPanel {
    private MidiInputProcessor processor;
    private JTextField ampConstantText;
    private JComboBox ampMapComboBox;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JSeparator jSeparator1;
    private JTextField keyConstantText;
    private JComboBox keyMapComboBox;
    private ScaleSelectionPanel scaleSelectionPanel1;

    public MidiInputProcessorPanel() {
        this.initComponents();
        this.keyMapComboBox.setModel(new DefaultComboBoxModel<MidiKeyMapping>(MidiKeyMapping.values()));
        this.ampMapComboBox.setModel(new DefaultComboBoxModel<MidiVelocityMapping>(MidiVelocityMapping.values()));
        this.keyConstantText.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (MidiInputProcessorPanel.this.processor != null) {
                    MidiInputProcessorPanel.this.processor.setPitchConstant(MidiInputProcessorPanel.this.keyConstantText.getText());
                }
            }
        });
        this.ampConstantText.getDocument().addDocumentListener((DocumentListener)new SimpleDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                if (MidiInputProcessorPanel.this.processor != null) {
                    MidiInputProcessorPanel.this.processor.setAmpConstant(MidiInputProcessorPanel.this.ampConstantText.getText());
                }
            }
        });
        this.scaleSelectionPanel1.addChangeListener(e -> {
            if (this.processor != null) {
                this.processor.setScale(this.scaleSelectionPanel1.getScale());
            }
        });
    }

    public void setMidiInputProcessor(MidiInputProcessor processor) {
        this.processor = null;
        this.keyConstantText.setText(processor.getPitchConstant());
        this.ampConstantText.setText(processor.getAmpConstant());
        this.keyMapComboBox.setSelectedItem(processor.getKeyMapping());
        this.ampMapComboBox.setSelectedItem(processor.getVelMapping());
        this.scaleSelectionPanel1.setScale(processor.getScale());
        this.processor = processor;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.keyMapComboBox = new JComboBox();
        this.jLabel3 = new JLabel();
        this.keyConstantText = new JTextField();
        this.jSeparator1 = new JSeparator();
        this.ampConstantText = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.ampMapComboBox = new JComboBox();
        this.scaleSelectionPanel1 = new ScaleSelectionPanel();
        this.jLabel1.setText(NbBundle.getMessage(MidiInputProcessorPanel.class, (String)"MidiInputProcessorPanel.jLabel1.text"));
        this.jLabel2.setText(NbBundle.getMessage(MidiInputProcessorPanel.class, (String)"MidiInputProcessorPanel.jLabel2.text"));
        this.keyMapComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.keyMapComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MidiInputProcessorPanel.this.keyMapComboBoxActionPerformed(evt);
            }
        });
        this.jLabel3.setText(NbBundle.getMessage(MidiInputProcessorPanel.class, (String)"MidiInputProcessorPanel.jLabel3.text"));
        this.keyConstantText.setText(NbBundle.getMessage(MidiInputProcessorPanel.class, (String)"MidiInputProcessorPanel.keyConstantText.text"));
        this.ampConstantText.setText(NbBundle.getMessage(MidiInputProcessorPanel.class, (String)"MidiInputProcessorPanel.ampConstantText.text"));
        this.jLabel4.setText(NbBundle.getMessage(MidiInputProcessorPanel.class, (String)"MidiInputProcessorPanel.jLabel4.text"));
        this.jLabel5.setText(NbBundle.getMessage(MidiInputProcessorPanel.class, (String)"MidiInputProcessorPanel.jLabel5.text"));
        this.ampMapComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.ampMapComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MidiInputProcessorPanel.this.ampMapComboBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 229, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3).addComponent(this.jLabel1, -2, 31, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.keyMapComboBox, 0, 135, Short.MAX_VALUE).addComponent(this.keyConstantText, -1, 135, Short.MAX_VALUE).addComponent(this.scaleSelectionPanel1, -1, 135, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel5, -2, 61, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ampMapComboBox, 0, 154, Short.MAX_VALUE).addComponent(this.ampConstantText, -1, 154, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.keyMapComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.scaleSelectionPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.keyConstantText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ampMapComboBox, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ampConstantText, -2, -1, -2).addComponent(this.jLabel4)).addGap(180, 180, 180)));
    }

    private void keyMapComboBoxActionPerformed(ActionEvent evt) {
        if (this.processor != null) {
            this.processor.setKeyMapping((MidiKeyMapping)this.keyMapComboBox.getSelectedItem());
        }
    }

    private void ampMapComboBoxActionPerformed(ActionEvent evt) {
        if (this.processor != null) {
            this.processor.setVelMapping((MidiVelocityMapping)this.ampMapComboBox.getSelectedItem());
        }
    }
}

