/*
 * Decompiled with CFR 0.152.
 */
package blue.ui.core.blueLive;

import blue.utilities.MidiUtilities;
import javax.sound.midi.MidiMessage;
import javax.sound.midi.Receiver;
import javax.sound.midi.ShortMessage;

public class ScoPadReceiver
implements Receiver {
    MidiNote[] notes = new MidiNote[128];

    public ScoPadReceiver() {
        for (int i = 0; i < this.notes.length; ++i) {
            this.notes[i] = new MidiNote();
        }
    }

    public String getNotes(String noteTemplate, String instrId, double start, double duration) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < this.notes.length; ++i) {
            if (this.notes[i].velocity < 0) continue;
            String note = MidiUtilities.processNoteTemplate((String)noteTemplate, (String)instrId, (double)start, (double)duration, (int)i, (int)this.notes[i].velocity);
            buffer.append(note).append("\n");
        }
        return buffer.toString();
    }

    @Override
    public void send(MidiMessage message, long timeStamp) {
        if (message instanceof ShortMessage) {
            ShortMessage shortMsg = (ShortMessage)message;
            switch (shortMsg.getCommand()) {
                case 144: {
                    int noteNum = shortMsg.getData1();
                    int velocity = shortMsg.getData2();
                    MidiNote n = this.notes[noteNum];
                    if (velocity > 0) {
                        n.start = System.currentTimeMillis();
                        n.velocity = velocity;
                        break;
                    }
                    n.start = -1L;
                    n.velocity = -1;
                    break;
                }
                case 128: {
                    int noteNum = shortMsg.getData1();
                    int velocity = shortMsg.getData2();
                    MidiNote n = this.notes[noteNum];
                    n.start = -1L;
                    n.velocity = -1;
                }
            }
        }
    }

    @Override
    public void close() {
        for (int i = 0; i < 128; ++i) {
            this.notes[i].start = -1L;
            this.notes[i].velocity = -1;
        }
    }

    class MidiNote {
        long start = -1L;
        int velocity = -1;

        MidiNote() {
        }
    }
}

