/*
 * Decompiled with CFR 0.152.
 */
package blue.tools.scanned;

import blue.tools.scanned.MatrixGridEditor;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class MatrixMouseListener
implements MouseListener,
MouseMotionListener {
    MatrixGridEditor grid;
    boolean[] matrix = null;
    boolean isWrite = false;

    public MatrixMouseListener(MatrixGridEditor grid) {
        this.grid = grid;
    }

    public void setMatrix(boolean[] matrix) {
        this.matrix = matrix;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.processMousePressed(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.processMouseReleased(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.processMouseDragged(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.showPosition(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.matrix != null) {
            this.grid.locationLabel.setText("pos (x,x)");
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    void processMousePressed(MouseEvent e) {
        if (this.matrix != null) {
            int y;
            int x = e.getX();
            this.isWrite = !this.getMass(x, y = e.getY());
            this.setMass(x, y, this.isWrite);
            this.showPosition(e);
            this.grid.repaint();
        }
    }

    void processMouseDragged(MouseEvent e) {
        if (this.grid != null) {
            this.showPosition(e);
            this.setMass(e.getX(), e.getY(), this.isWrite);
            this.grid.repaint();
        }
    }

    void processMouseReleased(MouseEvent e) {
    }

    void showPosition(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        if (this.matrix == null) {
            return;
        }
        int yIndex = y / MatrixGridEditor.gridHeight;
        int numOfMasses = MatrixGridEditor.numberOfMasses(this.matrix.length);
        if (yIndex >= numOfMasses || yIndex < 0) {
            return;
        }
        int xIndex = x / MatrixGridEditor.gridHeight;
        if (xIndex > numOfMasses || xIndex < 0) {
            return;
        }
        this.grid.locationLabel.setText("pos (" + xIndex + "," + yIndex + ")");
    }

    public boolean getMass(int x, int y) {
        if (this.matrix == null) {
            return false;
        }
        int yIndex = y / MatrixGridEditor.gridHeight;
        int numOfMasses = MatrixGridEditor.numberOfMasses(this.matrix.length);
        if (yIndex >= numOfMasses || yIndex < 0) {
            return false;
        }
        int xIndex = x / MatrixGridEditor.gridHeight;
        if (xIndex > numOfMasses || xIndex < 0) {
            return false;
        }
        return this.matrix[yIndex * numOfMasses + xIndex];
    }

    public void setMass(int x, int y, boolean val) {
        if (this.matrix == null) {
            return;
        }
        int yIndex = y / MatrixGridEditor.gridHeight;
        int numOfMasses = MatrixGridEditor.numberOfMasses(this.matrix.length);
        if (yIndex >= numOfMasses || yIndex < 0) {
            return;
        }
        int xIndex = x / MatrixGridEditor.gridHeight;
        if (xIndex > numOfMasses || xIndex < 0) {
            return;
        }
        this.matrix[yIndex * numOfMasses + xIndex] = val;
    }
}

