/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor;

import blue.score.ScoreObject;
import blue.soundObject.PatternObject;
import blue.soundObject.editor.ScoreObjectEditor;
import blue.soundObject.editor.pattern.PatternCanvas;
import blue.soundObject.editor.pattern.PatternLayerEditPanel;
import blue.soundObject.editor.pattern.PatternObjectPropertiesPanel;
import blue.soundObject.editor.pattern.PatternScoreEditor;
import blue.soundObject.editor.pattern.PatternTimeBar;
import blue.soundObject.pattern.Pattern;
import blue.ui.components.IconFactory;
import blue.utility.GUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;

public class PatternEditor
extends ScoreObjectEditor {
    private PatternLayerEditPanel layerPanel = new PatternLayerEditPanel();
    private PatternCanvas canvas = new PatternCanvas();
    private PatternScoreEditor patternScore = new PatternScoreEditor();
    private PatternTimeBar timeBar = new PatternTimeBar();
    private PatternObject patternObj;
    private PatternObjectPropertiesPanel props = new PatternObjectPropertiesPanel();

    public PatternEditor() {
        this.setLayout(new BorderLayout());
        this.layerPanel.addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            Pattern p = this.layerPanel.getSelectedPattern();
            this.patternScore.setPattern(p);
        });
        JToggleButton setTimeButton = new JToggleButton();
        setTimeButton.setIcon(IconFactory.getLeftArrowIcon());
        setTimeButton.setSelectedIcon(IconFactory.getRightArrowIcon());
        setTimeButton.setFocusable(false);
        setTimeButton.addActionListener(e -> this.props.setVisible(!this.props.isVisible()));
        JScrollPane scroll = new JScrollPane(this.canvas);
        scroll.setColumnHeaderView(this.timeBar);
        scroll.setCorner("UPPER_RIGHT_CORNER", setTimeButton);
        scroll.getVerticalScrollBar().addAdjustmentListener(this.layerPanel);
        scroll.setHorizontalScrollBarPolicy(32);
        scroll.setVerticalScrollBarPolicy(22);
        JSplitPane topSplitPane = new JSplitPane(1);
        topSplitPane.add(this.layerPanel);
        topSplitPane.add(scroll);
        topSplitPane.setDividerLocation(200);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)topSplitPane, "Center");
        topPanel.add((Component)this.props, "East");
        JSplitPane mainSplitPane = new JSplitPane(0);
        mainSplitPane.add(topPanel);
        mainSplitPane.add(this.patternScore);
        mainSplitPane.setDividerLocation(0.8);
        this.props.setVisible(false);
        this.add((Component)mainSplitPane, "Center");
        this.layerPanel.getViewPort().addMouseWheelListener(e -> {
            if (!e.isShiftDown()) {
                for (MouseWheelListener listener : scroll.getMouseWheelListeners()) {
                    listener.mouseWheelMoved(e);
                }
            }
        });
    }

    @Override
    public void editScoreObject(ScoreObject sObj) {
        PatternObject p;
        if (sObj == null) {
            return;
        }
        if (!(sObj instanceof PatternObject)) {
            return;
        }
        this.patternObj = p = (PatternObject)sObj;
        this.layerPanel.setPatternObject(p);
        this.canvas.setPatternObject(p);
        this.timeBar.setPatternObject(p);
        this.props.setPatternObject(p);
    }

    public static void main(String[] args) {
        GUI.setBlueLookAndFeel();
        PatternEditor patternEditor = new PatternEditor();
        patternEditor.editScoreObject((ScoreObject)new PatternObject());
        GUI.showComponentAsStandalone((Component)patternEditor, (String)"Pattern Editor", (boolean)true);
    }
}

