/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor;

import blue.score.ScoreObject;
import blue.soundObject.NotationObject;
import blue.soundObject.editor.NotationOptionsMenu;
import blue.soundObject.editor.ScoreObjectEditor;
import blue.soundObject.notation.NotationEditPoint;
import blue.soundObject.notation.NotationNote;
import blue.soundObject.notation.NotationStaffRenderer;
import blue.ui.utilities.UiUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class NotationEditor
extends ScoreObjectEditor {
    NotationObject nObj = null;
    NotationStaffRenderer nStaffRenderer = new NotationStaffRenderer();
    NotationEditPoint nep = new NotationEditPoint();
    JScrollPane notationScrollPane = new JScrollPane();
    JPanel controlBar = new JPanel();
    JLabel noteTemplateLabel = new JLabel("note template: ");
    JTextField noteTemplateText = new JTextField();
    NotationOptionsMenu optionsMenu = new NotationOptionsMenu();

    public NotationEditor() {
        this.setLayout(new BorderLayout());
        this.controlBar.setLayout(new BorderLayout());
        this.controlBar.add((Component)this.noteTemplateLabel, "West");
        this.controlBar.add((Component)this.noteTemplateText, "Center");
        this.add((Component)this.nStaffRenderer, "Center");
        this.add((Component)this.controlBar, "South");
        this.nStaffRenderer.setRequestFocusEnabled(true);
        this.nStaffRenderer.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NotationEditor.this.nStaffRenderer.requestFocus();
                if (UiUtilities.isRightMouseButton((MouseEvent)e)) {
                    NotationEditor.this.showOptionsMenu(e.getX(), e.getY());
                }
            }
        });
        this.nStaffRenderer.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                System.out.println(e.getKeyCode());
                int keyCode = e.getKeyCode();
                switch (keyCode) {
                    case 37: {
                        if (NotationEditor.this.nep.getIndex() <= 0) break;
                        NotationEditor.this.nep.setIndex(NotationEditor.this.nep.getIndex() - 1);
                        NotationEditor.this.nStaffRenderer.repaint();
                        break;
                    }
                    case 38: {
                        NotationEditor.this.nep.setMidiPch(NotationEditor.this.nep.getMidiPch() + 1);
                        NotationEditor.this.nStaffRenderer.repaint();
                        break;
                    }
                    case 39: {
                        if (NotationEditor.this.nep.getIndex() >= NotationEditor.this.nObj.getNotationStaff().size()) break;
                        NotationEditor.this.nep.setIndex(NotationEditor.this.nep.getIndex() + 1);
                        NotationEditor.this.nStaffRenderer.repaint();
                        break;
                    }
                    case 40: {
                        NotationEditor.this.nep.setMidiPch(NotationEditor.this.nep.getMidiPch() - 1);
                        NotationEditor.this.nStaffRenderer.repaint();
                    }
                }
                if (keyCode > 48 && keyCode < 56) {
                    NotationNote tempNote = new NotationNote();
                    tempNote.setNoteDuration(keyCode - 48);
                    tempNote.setMidiPitch(NotationEditor.this.nep.getMidiPch());
                    NotationEditor.this.nObj.getNotationStaff().addNotationNote(tempNote);
                    NotationEditor.this.nep.setIndex(NotationEditor.this.nep.getIndex() + 1);
                    NotationEditor.this.nStaffRenderer.repaint();
                }
            }
        });
    }

    private void showOptionsMenu(int x, int y) {
        this.optionsMenu.show(this, x, y);
    }

    @Override
    public void editScoreObject(ScoreObject sObj) {
        if (sObj == null) {
            this.nObj = null;
            return;
        }
        if (!(sObj instanceof NotationObject)) {
            this.nObj = null;
            return;
        }
        this.nObj = (NotationObject)sObj;
        this.nStaffRenderer.setNotationStaff(this.nObj.getNotationStaff());
        this.nep.setIndex(0);
        this.nStaffRenderer.setNotationEditPoint(this.nep);
    }
}

