/*
 * Decompiled with CFR 0.152.
 */
package blue.soundObject.editor;

import blue.components.LineCanvas;
import blue.components.lines.Line;
import blue.components.lines.LineListTable;
import blue.event.SelectionListener;
import blue.score.ScoreObject;
import blue.soundObject.LineObject;
import blue.soundObject.editor.ScoreObjectEditor;
import blue.utility.GUI;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JSplitPane;

public class LineEditor
extends ScoreObjectEditor {
    LineListTable lineTable = this.getNewLineTable();
    LineCanvas lineCanvas = this.getNewLineCanvas();

    public LineEditor() {
        this.setLayout(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setDividerLocation(200);
        splitPane.add((Component)this.lineTable, "left");
        splitPane.add((Component)this.lineCanvas, "right");
        this.lineTable.addTableModelListener(this.lineCanvas);
        this.lineTable.addSelectionListener((SelectionListener<Line>)((SelectionListener)e -> this.lineCanvas.setSelectedLine((Line)e.getSelectedItem())));
        this.add((Component)splitPane, "Center");
    }

    protected LineListTable getNewLineTable() {
        return new LineListTable();
    }

    protected LineCanvas getNewLineCanvas() {
        return new LineCanvas();
    }

    @Override
    public void editScoreObject(ScoreObject sObj) {
        if (sObj == null) {
            return;
        }
        if (!(sObj instanceof LineObject)) {
            return;
        }
        LineObject lineObj = (LineObject)sObj;
        this.lineTable.setLineList(lineObj.getLines());
        this.lineCanvas.setLineList(lineObj.getLines());
    }

    public static void main(String[] args) {
        LineEditor lineEditor = new LineEditor();
        lineEditor.editScoreObject((ScoreObject)new LineObject());
        GUI.showComponentAsStandalone((Component)lineEditor, (String)"Test Line Editor", (boolean)true);
    }
}

