/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder.jfx;

import blue.components.lines.Line;
import blue.components.lines.LineList;
import blue.orchestra.blueSynthBuilder.BSBLineObject;
import blue.orchestra.editor.blueSynthBuilder.jfx.LineSelector;
import blue.orchestra.editor.blueSynthBuilder.jfx.LineView;
import blue.orchestra.editor.blueSynthBuilder.jfx.ResizeableView;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;

public class BSBLineObjectView
extends BorderPane
implements ResizeableView {
    BSBLineObject lines;
    LineSelector selector;

    public BSBLineObjectView(BSBLineObject lines) {
        this.lines = lines;
        this.setUserData(lines);
        this.selector = new LineSelector(lines.getLines());
        LineView lineView = new LineView(lines.getLines());
        lineView.selectedLineProperty().bind(this.selector.selectedLineProperty());
        this.setCenter((Node)lineView);
        this.setBottom((Node)this.selector);
        this.setStyle("-fx-border-color:gray;");
        ListChangeListener linesListener = e -> {
            if (!lines.getLines().contains(this.selector.selectedLineProperty().get())) {
                LineList newLines = lines.getLines();
                if (newLines.size() > 0) {
                    this.selector.setSelectedLine((Line)newLines.get(0));
                } else {
                    this.selector.setSelectedLine(null);
                }
            }
            this.selector.leftButton.setDisable(lines.getLines().size() < 2);
            this.selector.rightButton.setDisable(lines.getLines().size() < 2);
            lineView.repaint();
        };
        this.sceneProperty().addListener((obs, old, newVal) -> {
            if (newVal == null) {
                lineView.widthProperty().unbind();
                lineView.heightProperty().unbind();
                this.selector.prefWidthProperty().unbind();
                lineView.lockedProperty().unbind();
                lines.getLines().removeListener(linesListener);
            } else {
                lineView.widthProperty().bind((ObservableValue)lines.canvasWidthProperty());
                lineView.heightProperty().bind((ObservableValue)lines.canvasHeightProperty());
                this.selector.prefWidthProperty().bind((ObservableValue)lines.canvasWidthProperty());
                lineView.lockedProperty().bind((ObservableValue)lines.lockedProperty());
                lines.getLines().addListener(linesListener);
            }
        });
        this.selector.leftButton.setDisable(lines.getLines().size() < 2);
        this.selector.rightButton.setDisable(lines.getLines().size() < 2);
    }

    @Override
    public boolean canResizeWidgetWidth() {
        return true;
    }

    @Override
    public boolean canResizeWidgetHeight() {
        return true;
    }

    @Override
    public int getWidgetMinimumWidth() {
        return 40;
    }

    @Override
    public int getWidgetMinimumHeight() {
        return 40 + (int)this.selector.getHeight();
    }

    @Override
    public int getWidgetWidth() {
        return this.lines.getCanvasWidth();
    }

    @Override
    public void setWidgetWidth(int width) {
        this.lines.setCanvasWidth(Math.max(40, width));
    }

    @Override
    public int getWidgetHeight() {
        return this.lines.getCanvasHeight() + (int)this.selector.getHeight();
    }

    @Override
    public void setWidgetHeight(int height) {
        this.lines.setCanvasHeight(height - (int)this.selector.getHeight());
    }

    @Override
    public void setWidgetX(int x) {
        this.lines.setX(x);
    }

    @Override
    public int getWidgetX() {
        return this.lines.getX();
    }

    @Override
    public void setWidgetY(int y) {
        this.lines.setY(y);
    }

    @Override
    public int getWidgetY() {
        return this.lines.getY();
    }
}

