/*
 * Decompiled with CFR 0.152.
 */
package blue.orchestra.editor.blueSynthBuilder.jfx;

import blue.orchestra.blueSynthBuilder.BSBCheckBox;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.CheckBox;
import org.openide.util.Exceptions;

public class BSBCheckBoxView
extends CheckBox {
    public BSBCheckBoxView(BSBCheckBox checkBox) {
        this.setUserData(checkBox);
        boolean[] editing = new boolean[]{false};
        ChangeListener cboxToViewListener = (obs, old, newVal) -> {
            if (!editing[0]) {
                editing[0] = true;
                if (!Platform.isFxApplicationThread()) {
                    CountDownLatch latch = new CountDownLatch(1);
                    Platform.runLater(() -> {
                        try {
                            this.setSelected((boolean)newVal);
                        }
                        finally {
                            latch.countDown();
                        }
                    });
                    try {
                        latch.await();
                    }
                    catch (InterruptedException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else {
                    this.setSelected((boolean)newVal);
                }
                editing[0] = false;
            }
        };
        ChangeListener viewToCboxListener = (obs, old, newVal) -> {
            if (!editing[0]) {
                editing[0] = true;
                checkBox.setSelected(newVal.booleanValue());
                editing[0] = false;
            }
        };
        this.sceneProperty().addListener((obs, old, newVal) -> {
            if (newVal == null) {
                checkBox.selectedProperty().removeListener(cboxToViewListener);
                this.selectedProperty().removeListener(viewToCboxListener);
                this.textProperty().unbind();
            } else {
                this.setSelected(checkBox.isSelected());
                checkBox.selectedProperty().addListener(cboxToViewListener);
                this.selectedProperty().addListener(viewToCboxListener);
                this.textProperty().bind((ObservableValue)checkBox.labelProperty());
            }
        });
    }
}

