/* Any copyright is dedicated to the Public Domain.
  http://creativecommons.org/publicdomain/zero/1.0/ */

/*
 * THIS FILE IS AUTOGENERATED. DO NOT MODIFY BY HAND.
 *
 * More info in https://firefox-source-docs.mozilla.org/devtools/tests/js-object-tests.html
 */

export default [
  // undefined
  {
    "type": "undefined"
  },

  // null
  {
    "type": "null"
  },

  // true
  true,

  // false
  false,

  // NaN
  {
    "type": "NaN"
  },

  // "abc"
  "abc",

  // "鼬ú"
  "鼬ú",

  // 42
  42,

  // -42
  -42,

  // -0
  {
    "type": "-0"
  },

  // Infinity
  {
    "type": "Infinity"
  },

  // BigInt(1000000000000000000)
  {
    "type": "BigInt",
    "text": "1000000000000000000"
  },

  // 1n
  {
    "type": "BigInt",
    "text": "1"
  },

  // -2n
  {
    "type": "BigInt",
    "text": "-2"
  },

  // 0n
  {
    "type": "BigInt",
    "text": "0"
  },

  // ({})
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Object",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "Object",
      "ownProperties": {},
      "ownPropertiesLength": 0
    }
  },

  // ({ foo: "bar"})
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Object",
    "ownPropertyLength": 1,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "Object",
      "ownProperties": {
        "foo": {
          "configurable": true,
          "enumerable": true,
          "writable": true,
          "value": "bar"
        }
      },
      "ownPropertiesLength": 1
    }
  },

  // []
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Array",
    "ownPropertyLength": 1,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "ArrayLike",
      "length": 0,
      "items": []
    }
  },

  // [1]
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Array",
    "ownPropertyLength": 2,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "ArrayLike",
      "length": 1,
      "items": [
        1
      ]
    }
  },

  // ["foo"]
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Array",
    "ownPropertyLength": 2,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "ArrayLike",
      "length": 1,
      "items": [
        "foo"
      ]
    }
  },

  // new BigInt64Array()
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "BigInt64Array",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "ArrayLike",
      "length": 0,
      "items": []
    }
  },

  // const a = new BigInt64Array(1);
  // a[0] = BigInt(42);
  // a;
  //     
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "BigInt64Array",
    "ownPropertyLength": 1,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "ArrayLike",
      "length": 1,
      "items": [
        {
          "type": "BigInt",
          "text": "42"
        }
      ]
    }
  },

  // new Map(
  //           Array.from({ length: 2 }).map((el, i) => [
  //             { key: i },
  //             { object: 42 },
  //           ])
  //         )
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Map",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "MapLike",
      "size": 2,
      "entries": [
        [
          {
            "type": "object",
            "actor": "<actor-id>",
            "class": "Object",
            "ownPropertyLength": 1,
            "extensible": true,
            "frozen": false,
            "sealed": false,
            "isError": false
          },
          {
            "type": "object",
            "actor": "<actor-id>",
            "class": "Object",
            "ownPropertyLength": 1,
            "extensible": true,
            "frozen": false,
            "sealed": false,
            "isError": false
          }
        ],
        [
          {
            "type": "object",
            "actor": "<actor-id>",
            "class": "Object",
            "ownPropertyLength": 1,
            "extensible": true,
            "frozen": false,
            "sealed": false,
            "isError": false
          },
          {
            "type": "object",
            "actor": "<actor-id>",
            "class": "Object",
            "ownPropertyLength": 1,
            "extensible": true,
            "frozen": false,
            "sealed": false,
            "isError": false
          }
        ]
      ]
    }
  },

  // new Map(Array.from({ length: 20 }).map((el, i) => [Symbol(i), i]))
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Map",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "MapLike",
      "size": 20,
      "entries": [
        [
          {
            "type": "symbol",
            "actor": "<actor-id>",
            "name": "0"
          },
          0
        ],
        [
          {
            "type": "symbol",
            "actor": "<actor-id>",
            "name": "1"
          },
          1
        ],
        [
          {
            "type": "symbol",
            "actor": "<actor-id>",
            "name": "2"
          },
          2
        ],
        [
          {
            "type": "symbol",
            "actor": "<actor-id>",
            "name": "3"
          },
          3
        ],
        [
          {
            "type": "symbol",
            "actor": "<actor-id>",
            "name": "4"
          },
          4
        ],
        [
          {
            "type": "symbol",
            "actor": "<actor-id>",
            "name": "5"
          },
          5
        ],
        [
          {
            "type": "symbol",
            "actor": "<actor-id>",
            "name": "6"
          },
          6
        ],
        [
          {
            "type": "symbol",
            "actor": "<actor-id>",
            "name": "7"
          },
          7
        ],
        [
          {
            "type": "symbol",
            "actor": "<actor-id>",
            "name": "8"
          },
          8
        ],
        [
          {
            "type": "symbol",
            "actor": "<actor-id>",
            "name": "9"
          },
          9
        ]
      ]
    }
  },

  // new Map(Array.from({ length: 331 }).map((el, i) => [Symbol(i), i]))
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Map",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "MapLike",
      "size": 331,
      "entries": [
        [
          {
            "type": "symbol",
            "actor": "<actor-id>",
            "name": "0"
          },
          0
        ],
        [
          {
            "type": "symbol",
            "actor": "<actor-id>",
            "name": "1"
          },
          1
        ],
        [
          {
            "type": "symbol",
            "actor": "<actor-id>",
            "name": "2"
          },
          2
        ],
        [
          {
            "type": "symbol",
            "actor": "<actor-id>",
            "name": "3"
          },
          3
        ],
        [
          {
            "type": "symbol",
            "actor": "<actor-id>",
            "name": "4"
          },
          4
        ],
        [
          {
            "type": "symbol",
            "actor": "<actor-id>",
            "name": "5"
          },
          5
        ],
        [
          {
            "type": "symbol",
            "actor": "<actor-id>",
            "name": "6"
          },
          6
        ],
        [
          {
            "type": "symbol",
            "actor": "<actor-id>",
            "name": "7"
          },
          7
        ],
        [
          {
            "type": "symbol",
            "actor": "<actor-id>",
            "name": "8"
          },
          8
        ],
        [
          {
            "type": "symbol",
            "actor": "<actor-id>",
            "name": "9"
          },
          9
        ]
      ]
    }
  },

  // new Set(Array.from({ length: 2 }).map((el, i) => ({ value: i })))
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Set",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "ArrayLike",
      "length": 2,
      "items": [
        {
          "type": "object",
          "actor": "<actor-id>",
          "class": "Object",
          "ownPropertyLength": 1,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false
        },
        {
          "type": "object",
          "actor": "<actor-id>",
          "class": "Object",
          "ownPropertyLength": 1,
          "extensible": true,
          "frozen": false,
          "sealed": false,
          "isError": false
        }
      ]
    }
  },

  // new Set(Array.from({ length: 20 }).map((el, i) => i))
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Set",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "ArrayLike",
      "length": 20,
      "items": [
        0,
        1,
        2,
        3,
        4,
        5,
        6,
        7,
        8,
        9
      ]
    }
  },

  // new Set(Array.from({ length: 222 }).map((el, i) => i))
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Set",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "ArrayLike",
      "length": 222,
      "items": [
        0,
        1,
        2,
        3,
        4,
        5,
        6,
        7,
        8,
        9
      ]
    }
  },

  // new Temporal.Instant(355924804000000000n)
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Temporal.Instant",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "ObjectWithText",
      "text": "1981-04-12T12:00:04Z"
    }
  },

  // new Temporal.PlainDate(2021, 7, 1, "coptic")
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Temporal.PlainDate",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "ObjectWithText",
      "text": "2021-07-01[u-ca=coptic]"
    }
  },

  // new Temporal.PlainDateTime(2021, 7, 1, 0, 0, 0, 0, 0, 0, "gregory")
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Temporal.PlainDateTime",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "ObjectWithText",
      "text": "2021-07-01T00:00:00[u-ca=gregory]"
    }
  },

  // new Temporal.PlainMonthDay(7, 1, "chinese")
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Temporal.PlainMonthDay",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "ObjectWithText",
      "text": "1972-07-01[u-ca=chinese]"
    }
  },

  // new Temporal.PlainTime(4, 20)
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Temporal.PlainTime",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "ObjectWithText",
      "text": "04:20:00"
    }
  },

  // new Temporal.PlainYearMonth(2021, 7, "indian")
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Temporal.PlainYearMonth",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "ObjectWithText",
      "text": "2021-07-01[u-ca=indian]"
    }
  },

  // new Temporal.ZonedDateTime(0n, "America/New_York")
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Temporal.ZonedDateTime",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "ObjectWithText",
      "text": "1969-12-31T19:00:00-05:00[America/New_York]"
    }
  },

  // Temporal.Duration.from({ years: 1 })
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Temporal.Duration",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "ObjectWithText",
      "text": "P1Y"
    }
  },

  // new Error("foo")
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Error",
    "ownPropertyLength": 4,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": true,
    "preview": {
      "kind": "Error",
      "name": "Error",
      "message": "foo",
      "stack": "@eval:1:1\n",
      "fileName": "eval",
      "lineNumber": 1,
      "columnNumber": 1
    }
  },

  // throw new Error("Long error ".repeat(10000));
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Error",
    "ownPropertyLength": 4,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": true,
    "preview": {
      "kind": "Error",
      "name": "Error",
      "message": {
        "type": "longString",
        "actor": "<actor-id>",
        "length": 110000,
        "initial": "Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error Long error"
      },
      "stack": "@eval:1:7\n",
      "fileName": "eval",
      "lineNumber": 1,
      "columnNumber": 7
    }
  },

  // throw `“https://evil.com/?aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa“ is evil and “https://not-so-evil.com/?bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb“ is not good either`;
  //     
  "“https://evil.com/?aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa“ is evil and “https://not-so-evil.com/?bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb“ is not good either",

  // Error("bar")
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Error",
    "ownPropertyLength": 4,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": true,
    "preview": {
      "kind": "Error",
      "name": "Error",
      "message": "bar",
      "stack": "@eval:1:6\n",
      "fileName": "eval",
      "lineNumber": 1,
      "columnNumber": 6
    }
  },

  // function bar() {
  //   asdf();
  // }
  // function foo() {
  //   bar();
  // }
  // 
  // foo();
  //     
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "ReferenceError",
    "ownPropertyLength": 4,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": true,
    "preview": {
      "kind": "Error",
      "name": "ReferenceError",
      "message": "asdf is not defined",
      "stack": "bar@eval:3:9\nfoo@eval:6:9\n@eval:9:7\n",
      "fileName": "eval",
      "lineNumber": 3,
      "columnNumber": 9
    }
  },

  // eval("let a, a")
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "SyntaxError",
    "ownPropertyLength": 4,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": true,
    "preview": {
      "kind": "Error",
      "name": "SyntaxError",
      "message": "redeclaration of let a",
      "stack": "@eval:1:1\n",
      "fileName": "eval",
      "lineNumber": 1,
      "columnNumber": 8
    }
  },

  // throw "";
  "",

  // throw false;
  false,

  // throw undefined;
  {
    "type": "undefined"
  },

  // throw 0;
  0,

  // throw { vegetable: "cucumber" };
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Object",
    "ownPropertyLength": 1,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "Object",
      "ownProperties": {
        "vegetable": {
          "configurable": true,
          "enumerable": true,
          "writable": true,
          "value": "cucumber"
        }
      },
      "ownPropertiesLength": 1
    }
  },

  // throw Symbol("potato");
  {
    "type": "symbol",
    "actor": "<actor-id>",
    "name": "potato"
  },

  // var err = new Error("pineapple");
  // err.name = "JuicyError";
  // err.flavor = "delicious";
  // throw err;
  //     
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Error",
    "ownPropertyLength": 6,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": true,
    "preview": {
      "kind": "Error",
      "name": "JuicyError",
      "message": "pineapple",
      "stack": "@eval:2:17\n",
      "fileName": "eval",
      "lineNumber": 2,
      "columnNumber": 17
    }
  },

  // var originalError = new SyntaxError("original error");
  // var err = new Error("something went wrong", {
  //   cause: originalError,
  // });
  // throw err;
  //     
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Error",
    "ownPropertyLength": 5,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": true,
    "preview": {
      "kind": "Error",
      "name": "Error",
      "message": "something went wrong",
      "stack": "@eval:3:17\n",
      "fileName": "eval",
      "lineNumber": 3,
      "columnNumber": 17,
      "cause": {
        "type": "object",
        "actor": "<actor-id>",
        "class": "SyntaxError",
        "ownPropertyLength": 4,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "isError": true,
        "preview": {
          "kind": "Error",
          "name": "SyntaxError",
          "message": "original error",
          "stack": "@eval:2:27\n",
          "fileName": "eval",
          "lineNumber": 2,
          "columnNumber": 27
        }
      }
    }
  },

  // var a = new Error("err-a");
  // var b = new Error("err-b", { cause: a });
  // var c = new Error("err-c", { cause: b });
  // var d = new Error("err-d", { cause: c });
  // throw d;
  //     
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Error",
    "ownPropertyLength": 5,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": true,
    "preview": {
      "kind": "Error",
      "name": "Error",
      "message": "err-d",
      "stack": "@eval:5:15\n",
      "fileName": "eval",
      "lineNumber": 5,
      "columnNumber": 15,
      "cause": {
        "type": "object",
        "actor": "<actor-id>",
        "class": "Error",
        "ownPropertyLength": 5,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "isError": true,
        "preview": {
          "kind": "Error",
          "name": "Error",
          "message": "err-c",
          "stack": "@eval:4:15\n",
          "fileName": "eval",
          "lineNumber": 4,
          "columnNumber": 15,
          "cause": {
            "type": "object",
            "actor": "<actor-id>",
            "class": "Error",
            "ownPropertyLength": 5,
            "extensible": true,
            "frozen": false,
            "sealed": false,
            "isError": true,
            "preview": {
              "kind": "Error",
              "name": "Error",
              "message": "err-b",
              "stack": "@eval:3:15\n",
              "fileName": "eval",
              "lineNumber": 3,
              "columnNumber": 15,
              "cause": {
                "type": "object",
                "actor": "<actor-id>",
                "class": "Error",
                "ownPropertyLength": 4,
                "extensible": true,
                "frozen": false,
                "sealed": false,
                "isError": true,
                "preview": {
                  "kind": "Error",
                  "name": "Error",
                  "message": "err-a",
                  "stack": "@eval:2:15\n",
                  "fileName": "eval",
                  "lineNumber": 2,
                  "columnNumber": 15
                }
              }
            }
          }
        }
      }
    }
  },

  // var a = new Error("err-a", { cause: b });
  // var b = new Error("err-b", { cause: a });
  // throw b;
  //     
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Error",
    "ownPropertyLength": 5,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": true,
    "preview": {
      "kind": "Error",
      "name": "Error",
      "message": "err-b",
      "stack": "@eval:3:15\n",
      "fileName": "eval",
      "lineNumber": 3,
      "columnNumber": 15,
      "cause": {
        "type": "object",
        "actor": "<actor-id>",
        "class": "Error",
        "ownPropertyLength": 5,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "isError": true,
        "preview": {
          "kind": "Error",
          "name": "Error",
          "message": "err-a",
          "stack": "@eval:2:15\n",
          "fileName": "eval",
          "lineNumber": 2,
          "columnNumber": 15,
          "cause": {
            "type": "object",
            "actor": "<actor-id>",
            "class": "Error",
            "ownPropertyLength": 5,
            "extensible": true,
            "frozen": false,
            "sealed": false,
            "isError": true,
            "preview": {
              "kind": "Error",
              "name": "Error",
              "message": "err-b",
              "stack": "@eval:3:15\n",
              "fileName": "eval",
              "lineNumber": 3,
              "columnNumber": 15,
              "cause": {
                "type": "object",
                "actor": "<actor-id>",
                "class": "Error",
                "ownPropertyLength": 4,
                "extensible": true,
                "frozen": false,
                "sealed": false,
                "isError": true,
                "preview": {
                  "kind": "Error",
                  "name": "Error",
                  "message": "err-a",
                  "stack": "@eval:2:15\n",
                  "fileName": "eval",
                  "lineNumber": 2,
                  "columnNumber": 15
                }
              }
            }
          }
        }
      }
    }
  },

  // throw new Error("null cause", { cause: null });
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Error",
    "ownPropertyLength": 5,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": true,
    "preview": {
      "kind": "Error",
      "name": "Error",
      "message": "null cause",
      "stack": "@eval:1:7\n",
      "fileName": "eval",
      "lineNumber": 1,
      "columnNumber": 7,
      "cause": {
        "type": "null"
      }
    }
  },

  // throw new Error("number cause", { cause: 0 });
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Error",
    "ownPropertyLength": 5,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": true,
    "preview": {
      "kind": "Error",
      "name": "Error",
      "message": "number cause",
      "stack": "@eval:1:7\n",
      "fileName": "eval",
      "lineNumber": 1,
      "columnNumber": 7,
      "cause": 0
    }
  },

  // throw new Error("string cause", { cause: "cause message" });
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Error",
    "ownPropertyLength": 5,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": true,
    "preview": {
      "kind": "Error",
      "name": "Error",
      "message": "string cause",
      "stack": "@eval:1:7\n",
      "fileName": "eval",
      "lineNumber": 1,
      "columnNumber": 7,
      "cause": "cause message"
    }
  },

  // throw new Error("object cause", {
  //   cause: { code: 234, message: "ERR_234" },
  // });
  //     
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Error",
    "ownPropertyLength": 5,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": true,
    "preview": {
      "kind": "Error",
      "name": "Error",
      "message": "object cause",
      "stack": "@eval:2:13\n",
      "fileName": "eval",
      "lineNumber": 2,
      "columnNumber": 13,
      "cause": {
        "type": "object",
        "actor": "<actor-id>",
        "class": "Object",
        "ownPropertyLength": 2,
        "extensible": true,
        "frozen": false,
        "sealed": false,
        "isError": false
      }
    }
  },

  // Promise.reject("")
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Promise",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "Object",
      "ownProperties": {
        "<state>": {
          "value": "rejected"
        },
        "<reason>": {
          "value": ""
        }
      },
      "ownPropertiesLength": 2
    }
  },

  // Promise.reject("tomato")
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Promise",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "Object",
      "ownProperties": {
        "<state>": {
          "value": "rejected"
        },
        "<reason>": {
          "value": "tomato"
        }
      },
      "ownPropertiesLength": 2
    }
  },

  // Promise.reject(false)
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Promise",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "Object",
      "ownProperties": {
        "<state>": {
          "value": "rejected"
        },
        "<reason>": {
          "value": false
        }
      },
      "ownPropertiesLength": 2
    }
  },

  // Promise.reject(0)
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Promise",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "Object",
      "ownProperties": {
        "<state>": {
          "value": "rejected"
        },
        "<reason>": {
          "value": 0
        }
      },
      "ownPropertiesLength": 2
    }
  },

  // Promise.reject(null)
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Promise",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "Object",
      "ownProperties": {
        "<state>": {
          "value": "rejected"
        },
        "<reason>": {
          "value": {
            "type": "null"
          }
        }
      },
      "ownPropertiesLength": 2
    }
  },

  // Promise.reject(undefined)
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Promise",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "Object",
      "ownProperties": {
        "<state>": {
          "value": "rejected"
        },
        "<reason>": {
          "value": {
            "type": "undefined"
          }
        }
      },
      "ownPropertiesLength": 2
    }
  },

  // Promise.reject(Symbol("potato"))
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Promise",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "Object",
      "ownProperties": {
        "<state>": {
          "value": "rejected"
        },
        "<reason>": {
          "value": {
            "type": "symbol",
            "actor": "<actor-id>",
            "name": "potato"
          }
        }
      },
      "ownPropertiesLength": 2
    }
  },

  // Promise.reject({vegetable: "cucumber"})
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Promise",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "Object",
      "ownProperties": {
        "<state>": {
          "value": "rejected"
        },
        "<reason>": {
          "value": {
            "type": "object",
            "actor": "<actor-id>",
            "class": "Object",
            "ownPropertyLength": 1,
            "extensible": true,
            "frozen": false,
            "sealed": false,
            "isError": false
          }
        }
      },
      "ownPropertiesLength": 2
    }
  },

  // Promise.reject(new Error("pumpkin"))
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Promise",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "Object",
      "ownProperties": {
        "<state>": {
          "value": "rejected"
        },
        "<reason>": {
          "value": {
            "type": "object",
            "actor": "<actor-id>",
            "class": "Error",
            "ownPropertyLength": 4,
            "extensible": true,
            "frozen": false,
            "sealed": false,
            "isError": true,
            "preview": {
              "kind": "Error",
              "name": "Error",
              "message": "pumpkin",
              "stack": "@eval:1:16\n",
              "fileName": "eval",
              "lineNumber": 1,
              "columnNumber": 16
            }
          }
        }
      },
      "ownPropertiesLength": 2
    }
  },

  // var err = new Error("pineapple");
  // err.name = "JuicyError";
  // err.flavor = "delicious";
  // Promise.reject(err);
  //     
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Promise",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "Object",
      "ownProperties": {
        "<state>": {
          "value": "rejected"
        },
        "<reason>": {
          "value": {
            "type": "object",
            "actor": "<actor-id>",
            "class": "Error",
            "ownPropertyLength": 6,
            "extensible": true,
            "frozen": false,
            "sealed": false,
            "isError": true,
            "preview": {
              "kind": "Error",
              "name": "JuicyError",
              "message": "pineapple",
              "stack": "@eval:2:17\n",
              "fileName": "eval",
              "lineNumber": 2,
              "columnNumber": 17
            }
          }
        }
      },
      "ownPropertiesLength": 2
    }
  },

  // Promise.resolve().then(() => {
  //         try {
  //           unknownFunc();
  //         } catch(e) {
  //           throw new Error("something went wrong", { cause: e })
  //         }
  //       })
  {
    "type": "object",
    "actor": "<actor-id>",
    "class": "Promise",
    "ownPropertyLength": 0,
    "extensible": true,
    "frozen": false,
    "sealed": false,
    "isError": false,
    "preview": {
      "kind": "Object",
      "ownProperties": {
        "<state>": {
          "value": "pending"
        }
      },
      "ownPropertiesLength": 1
    }
  },
];