/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPerformanceMeasureOptions.h"

#include "JSDOMConvertAny.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include <JavaScriptCore/JSCInlines.h>
#include <variant>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<PerformanceMeasureOptions>> convertDictionary<PerformanceMeasureOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    PerformanceMeasureOptions result;
    JSValue detailValue;
    if (isNullOrUndefined)
        detailValue = jsUndefined();
    else {
        detailValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "detail"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto detailConversionResult = convertOptionalWithDefault<IDLAny>(lexicalGlobalObject, detailValue, [&]() -> ConversionResult<IDLAny> { return Converter<IDLAny>::ReturnType { jsUndefined() }; });
    if (UNLIKELY(detailConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.detail = detailConversionResult.releaseReturnValue();
    JSValue durationValue;
    if (isNullOrUndefined)
        durationValue = jsUndefined();
    else {
        durationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "duration"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!durationValue.isUndefined()) {
        auto durationConversionResult = convert<IDLDouble>(lexicalGlobalObject, durationValue);
        if (UNLIKELY(durationConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.duration = durationConversionResult.releaseReturnValue();
    }
    JSValue endValue;
    if (isNullOrUndefined)
        endValue = jsUndefined();
    else {
        endValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "end"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!endValue.isUndefined()) {
        auto endConversionResult = convert<IDLUnion<IDLDOMString, IDLDouble>>(lexicalGlobalObject, endValue);
        if (UNLIKELY(endConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.end = endConversionResult.releaseReturnValue();
    }
    JSValue startValue;
    if (isNullOrUndefined)
        startValue = jsUndefined();
    else {
        startValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "start"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!startValue.isUndefined()) {
        auto startConversionResult = convert<IDLUnion<IDLDOMString, IDLDouble>>(lexicalGlobalObject, startValue);
        if (UNLIKELY(startConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.start = startConversionResult.releaseReturnValue();
    }
    return result;
}

} // namespace WebCore
