/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013-2016 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from CombinedDomains.json by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

#include "config.h"
#include "InspectorFrontendDispatchers.h"

#include "InspectorFrontendRouter.h"

namespace Inspector {

void AnimationFrontendDispatcher::animationCreated(Ref<Protocol::Animation::Animation>&& animation)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Animation.animationCreated"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setObject("animation"_s, WTFMove(animation));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void AnimationFrontendDispatcher::nameChanged(const String& animationId, const String& opt_name)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Animation.nameChanged"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("animationId"_s, animationId);
    if (!!opt_name)
        protocol_paramsObject->setString("name"_s, opt_name);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void AnimationFrontendDispatcher::effectChanged(const String& animationId, RefPtr<Protocol::Animation::Effect>&& opt_effect)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Animation.effectChanged"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("animationId"_s, animationId);
    if (!!opt_effect)
        protocol_paramsObject->setObject("effect"_s, opt_effect.releaseNonNull());
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void AnimationFrontendDispatcher::targetChanged(const String& animationId)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Animation.targetChanged"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("animationId"_s, animationId);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void AnimationFrontendDispatcher::animationDestroyed(const String& animationId)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Animation.animationDestroyed"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("animationId"_s, animationId);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void AnimationFrontendDispatcher::trackingStart(double timestamp)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Animation.trackingStart"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void AnimationFrontendDispatcher::trackingUpdate(double timestamp, Ref<Protocol::Animation::TrackingUpdate>&& event)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Animation.trackingUpdate"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_paramsObject->setObject("event"_s, WTFMove(event));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void AnimationFrontendDispatcher::trackingComplete(double timestamp)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Animation.trackingComplete"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void ApplicationCacheFrontendDispatcher::applicationCacheStatusUpdated(const String& frameId, const String& manifestURL, int status)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "ApplicationCache.applicationCacheStatusUpdated"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("frameId"_s, frameId);
    protocol_paramsObject->setString("manifestURL"_s, manifestURL);
    protocol_paramsObject->setInteger("status"_s, status);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void ApplicationCacheFrontendDispatcher::networkStateUpdated(bool isNowOnline)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "ApplicationCache.networkStateUpdated"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setBoolean("isNowOnline"_s, isNowOnline);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void BrowserFrontendDispatcher::extensionsEnabled(Ref<JSON::ArrayOf<Protocol::Browser::Extension>>&& extensions)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Browser.extensionsEnabled"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setArray("extensions"_s, WTFMove(extensions));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void BrowserFrontendDispatcher::extensionsDisabled(Ref<JSON::ArrayOf<String>>&& extensionIds)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Browser.extensionsDisabled"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setArray("extensionIds"_s, WTFMove(extensionIds));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
void CPUProfilerFrontendDispatcher::trackingStart(double timestamp)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "CPUProfiler.trackingStart"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void CPUProfilerFrontendDispatcher::trackingUpdate(Ref<Protocol::CPUProfiler::Event>&& event)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "CPUProfiler.trackingUpdate"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setObject("event"_s, WTFMove(event));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void CPUProfilerFrontendDispatcher::trackingComplete(double timestamp)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "CPUProfiler.trackingComplete"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

void CSSFrontendDispatcher::mediaQueryResultChanged()
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "CSS.mediaQueryResultChanged"_s);

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void CSSFrontendDispatcher::styleSheetChanged(const String& styleSheetId)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "CSS.styleSheetChanged"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("styleSheetId"_s, styleSheetId);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void CSSFrontendDispatcher::styleSheetAdded(Ref<Protocol::CSS::CSSStyleSheetHeader>&& header)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "CSS.styleSheetAdded"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setObject("header"_s, WTFMove(header));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void CSSFrontendDispatcher::styleSheetRemoved(const String& styleSheetId)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "CSS.styleSheetRemoved"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("styleSheetId"_s, styleSheetId);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void CSSFrontendDispatcher::nodeLayoutFlagsChanged(int nodeId, RefPtr<JSON::ArrayOf<String>>&& opt_layoutFlags)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "CSS.nodeLayoutFlagsChanged"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setInteger("nodeId"_s, nodeId);
    if (!!opt_layoutFlags)
        protocol_paramsObject->setArray("layoutFlags"_s, opt_layoutFlags.releaseNonNull());
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void CanvasFrontendDispatcher::canvasAdded(Ref<Protocol::Canvas::Canvas>&& canvas)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Canvas.canvasAdded"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setObject("canvas"_s, WTFMove(canvas));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void CanvasFrontendDispatcher::canvasRemoved(const String& canvasId)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Canvas.canvasRemoved"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("canvasId"_s, canvasId);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void CanvasFrontendDispatcher::canvasSizeChanged(const String& canvasId, double width, double height)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Canvas.canvasSizeChanged"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("canvasId"_s, canvasId);
    protocol_paramsObject->setDouble("width"_s, width);
    protocol_paramsObject->setDouble("height"_s, height);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void CanvasFrontendDispatcher::canvasMemoryChanged(const String& canvasId, double memoryCost)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Canvas.canvasMemoryChanged"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("canvasId"_s, canvasId);
    protocol_paramsObject->setDouble("memoryCost"_s, memoryCost);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void CanvasFrontendDispatcher::extensionEnabled(const String& canvasId, const String& extension)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Canvas.extensionEnabled"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("canvasId"_s, canvasId);
    protocol_paramsObject->setString("extension"_s, extension);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void CanvasFrontendDispatcher::clientNodesChanged(const String& canvasId)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Canvas.clientNodesChanged"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("canvasId"_s, canvasId);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void CanvasFrontendDispatcher::recordingStarted(const String& canvasId, Protocol::Recording::Initiator initiator)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Canvas.recordingStarted"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("canvasId"_s, canvasId);
    protocol_paramsObject->setString("initiator"_s, Protocol::Helpers::getEnumConstantValue(initiator));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void CanvasFrontendDispatcher::recordingProgress(const String& canvasId, Ref<JSON::ArrayOf<Protocol::Recording::Frame>>&& frames, int bufferUsed)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Canvas.recordingProgress"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("canvasId"_s, canvasId);
    protocol_paramsObject->setArray("frames"_s, WTFMove(frames));
    protocol_paramsObject->setInteger("bufferUsed"_s, bufferUsed);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void CanvasFrontendDispatcher::recordingFinished(const String& canvasId, RefPtr<Protocol::Recording::Recording>&& opt_recording)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Canvas.recordingFinished"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("canvasId"_s, canvasId);
    if (!!opt_recording)
        protocol_paramsObject->setObject("recording"_s, opt_recording.releaseNonNull());
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
void CanvasFrontendDispatcher::programCreated(Ref<Protocol::Canvas::ShaderProgram>&& shaderProgram)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Canvas.programCreated"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setObject("shaderProgram"_s, WTFMove(shaderProgram));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL

#if defined(ENABLE_WEBGL) && ENABLE_WEBGL
void CanvasFrontendDispatcher::programDeleted(const String& programId)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Canvas.programDeleted"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("programId"_s, programId);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}
#endif // defined(ENABLE_WEBGL) && ENABLE_WEBGL

void ConsoleFrontendDispatcher::messageAdded(Ref<Protocol::Console::ConsoleMessage>&& message)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Console.messageAdded"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setObject("message"_s, WTFMove(message));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void ConsoleFrontendDispatcher::messageRepeatCountUpdated(int count, std::optional<double>&& opt_timestamp)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Console.messageRepeatCountUpdated"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setInteger("count"_s, count);
    if (!!opt_timestamp)
        protocol_paramsObject->setDouble("timestamp"_s, *opt_timestamp);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void ConsoleFrontendDispatcher::messagesCleared(Protocol::Console::ClearReason reason)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Console.messagesCleared"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("reason"_s, Protocol::Helpers::getEnumConstantValue(reason));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void ConsoleFrontendDispatcher::heapSnapshot(double timestamp, const String& snapshotData, const String& opt_title)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Console.heapSnapshot"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_paramsObject->setString("snapshotData"_s, snapshotData);
    if (!!opt_title)
        protocol_paramsObject->setString("title"_s, opt_title);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::documentUpdated()
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "DOM.documentUpdated"_s);

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::inspect(int nodeId)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "DOM.inspect"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setInteger("nodeId"_s, nodeId);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::setChildNodes(int parentId, Ref<JSON::ArrayOf<Protocol::DOM::Node>>&& nodes)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "DOM.setChildNodes"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setInteger("parentId"_s, parentId);
    protocol_paramsObject->setArray("nodes"_s, WTFMove(nodes));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::attributeModified(int nodeId, const String& name, const String& value)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "DOM.attributeModified"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setInteger("nodeId"_s, nodeId);
    protocol_paramsObject->setString("name"_s, name);
    protocol_paramsObject->setString("value"_s, value);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::attributeRemoved(int nodeId, const String& name)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "DOM.attributeRemoved"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setInteger("nodeId"_s, nodeId);
    protocol_paramsObject->setString("name"_s, name);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::inlineStyleInvalidated(Ref<JSON::ArrayOf<int>>&& nodeIds)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "DOM.inlineStyleInvalidated"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setArray("nodeIds"_s, WTFMove(nodeIds));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::characterDataModified(int nodeId, const String& characterData)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "DOM.characterDataModified"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setInteger("nodeId"_s, nodeId);
    protocol_paramsObject->setString("characterData"_s, characterData);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::childNodeCountUpdated(int nodeId, int childNodeCount)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "DOM.childNodeCountUpdated"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setInteger("nodeId"_s, nodeId);
    protocol_paramsObject->setInteger("childNodeCount"_s, childNodeCount);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::childNodeInserted(int parentNodeId, int previousNodeId, Ref<Protocol::DOM::Node>&& node)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "DOM.childNodeInserted"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setInteger("parentNodeId"_s, parentNodeId);
    protocol_paramsObject->setInteger("previousNodeId"_s, previousNodeId);
    protocol_paramsObject->setObject("node"_s, WTFMove(node));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::childNodeRemoved(int parentNodeId, int nodeId)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "DOM.childNodeRemoved"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setInteger("parentNodeId"_s, parentNodeId);
    protocol_paramsObject->setInteger("nodeId"_s, nodeId);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::willDestroyDOMNode(int nodeId)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "DOM.willDestroyDOMNode"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setInteger("nodeId"_s, nodeId);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::shadowRootPushed(int hostId, Ref<Protocol::DOM::Node>&& root)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "DOM.shadowRootPushed"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setInteger("hostId"_s, hostId);
    protocol_paramsObject->setObject("root"_s, WTFMove(root));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::shadowRootPopped(int hostId, int rootId)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "DOM.shadowRootPopped"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setInteger("hostId"_s, hostId);
    protocol_paramsObject->setInteger("rootId"_s, rootId);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::customElementStateChanged(int nodeId, Protocol::DOM::CustomElementState customElementState)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "DOM.customElementStateChanged"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setInteger("nodeId"_s, nodeId);
    protocol_paramsObject->setString("customElementState"_s, Protocol::Helpers::getEnumConstantValue(customElementState));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::pseudoElementAdded(int parentId, Ref<Protocol::DOM::Node>&& pseudoElement)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "DOM.pseudoElementAdded"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setInteger("parentId"_s, parentId);
    protocol_paramsObject->setObject("pseudoElement"_s, WTFMove(pseudoElement));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::pseudoElementRemoved(int parentId, int pseudoElementId)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "DOM.pseudoElementRemoved"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setInteger("parentId"_s, parentId);
    protocol_paramsObject->setInteger("pseudoElementId"_s, pseudoElementId);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::didAddEventListener(int nodeId)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "DOM.didAddEventListener"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setInteger("nodeId"_s, nodeId);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::willRemoveEventListener(int nodeId)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "DOM.willRemoveEventListener"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setInteger("nodeId"_s, nodeId);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DOMFrontendDispatcher::didFireEvent(int nodeId, const String& eventName, double timestamp, RefPtr<JSON::Object>&& opt_data)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "DOM.didFireEvent"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setInteger("nodeId"_s, nodeId);
    protocol_paramsObject->setString("eventName"_s, eventName);
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    if (!!opt_data)
        protocol_paramsObject->setObject("data"_s, opt_data.releaseNonNull());
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

#if defined(ENABLE_VIDEO) && ENABLE_VIDEO
void DOMFrontendDispatcher::powerEfficientPlaybackStateChanged(int nodeId, double timestamp, bool isPowerEfficient)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "DOM.powerEfficientPlaybackStateChanged"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setInteger("nodeId"_s, nodeId);
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_paramsObject->setBoolean("isPowerEfficient"_s, isPowerEfficient);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}
#endif // defined(ENABLE_VIDEO) && ENABLE_VIDEO

void DOMStorageFrontendDispatcher::domStorageItemsCleared(Ref<Protocol::DOMStorage::StorageId>&& storageId)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "DOMStorage.domStorageItemsCleared"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setObject("storageId"_s, WTFMove(storageId));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DOMStorageFrontendDispatcher::domStorageItemRemoved(Ref<Protocol::DOMStorage::StorageId>&& storageId, const String& key)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "DOMStorage.domStorageItemRemoved"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setObject("storageId"_s, WTFMove(storageId));
    protocol_paramsObject->setString("key"_s, key);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DOMStorageFrontendDispatcher::domStorageItemAdded(Ref<Protocol::DOMStorage::StorageId>&& storageId, const String& key, const String& newValue)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "DOMStorage.domStorageItemAdded"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setObject("storageId"_s, WTFMove(storageId));
    protocol_paramsObject->setString("key"_s, key);
    protocol_paramsObject->setString("newValue"_s, newValue);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DOMStorageFrontendDispatcher::domStorageItemUpdated(Ref<Protocol::DOMStorage::StorageId>&& storageId, const String& key, const String& oldValue, const String& newValue)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "DOMStorage.domStorageItemUpdated"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setObject("storageId"_s, WTFMove(storageId));
    protocol_paramsObject->setString("key"_s, key);
    protocol_paramsObject->setString("oldValue"_s, oldValue);
    protocol_paramsObject->setString("newValue"_s, newValue);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DatabaseFrontendDispatcher::addDatabase(Ref<Protocol::Database::Database>&& database)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Database.addDatabase"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setObject("database"_s, WTFMove(database));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DebuggerFrontendDispatcher::globalObjectCleared()
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Debugger.globalObjectCleared"_s);

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DebuggerFrontendDispatcher::scriptParsed(const String& scriptId, const String& url, int startLine, int startColumn, int endLine, int endColumn, std::optional<bool>&& opt_isContentScript, const String& opt_sourceURL, const String& opt_sourceMapURL, std::optional<bool>&& opt_module)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Debugger.scriptParsed"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("scriptId"_s, scriptId);
    protocol_paramsObject->setString("url"_s, url);
    protocol_paramsObject->setInteger("startLine"_s, startLine);
    protocol_paramsObject->setInteger("startColumn"_s, startColumn);
    protocol_paramsObject->setInteger("endLine"_s, endLine);
    protocol_paramsObject->setInteger("endColumn"_s, endColumn);
    if (!!opt_isContentScript)
        protocol_paramsObject->setBoolean("isContentScript"_s, *opt_isContentScript);
    if (!!opt_sourceURL)
        protocol_paramsObject->setString("sourceURL"_s, opt_sourceURL);
    if (!!opt_sourceMapURL)
        protocol_paramsObject->setString("sourceMapURL"_s, opt_sourceMapURL);
    if (!!opt_module)
        protocol_paramsObject->setBoolean("module"_s, *opt_module);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DebuggerFrontendDispatcher::scriptFailedToParse(const String& url, const String& scriptSource, int startLine, int errorLine, const String& errorMessage)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Debugger.scriptFailedToParse"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("url"_s, url);
    protocol_paramsObject->setString("scriptSource"_s, scriptSource);
    protocol_paramsObject->setInteger("startLine"_s, startLine);
    protocol_paramsObject->setInteger("errorLine"_s, errorLine);
    protocol_paramsObject->setString("errorMessage"_s, errorMessage);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DebuggerFrontendDispatcher::breakpointResolved(const String& breakpointId, Ref<Protocol::Debugger::Location>&& location)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Debugger.breakpointResolved"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("breakpointId"_s, breakpointId);
    protocol_paramsObject->setObject("location"_s, WTFMove(location));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DebuggerFrontendDispatcher::paused(Ref<JSON::ArrayOf<Protocol::Debugger::CallFrame>>&& callFrames, const String& reason, RefPtr<JSON::Object>&& opt_data, RefPtr<Protocol::Console::StackTrace>&& opt_asyncStackTrace)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Debugger.paused"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setArray("callFrames"_s, WTFMove(callFrames));
    protocol_paramsObject->setString("reason"_s, reason);
    if (!!opt_data)
        protocol_paramsObject->setObject("data"_s, opt_data.releaseNonNull());
    if (!!opt_asyncStackTrace)
        protocol_paramsObject->setObject("asyncStackTrace"_s, opt_asyncStackTrace.releaseNonNull());
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DebuggerFrontendDispatcher::resumed()
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Debugger.resumed"_s);

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DebuggerFrontendDispatcher::didSampleProbe(Ref<Protocol::Debugger::ProbeSample>&& sample)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Debugger.didSampleProbe"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setObject("sample"_s, WTFMove(sample));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void DebuggerFrontendDispatcher::playBreakpointActionSound(int breakpointActionId)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Debugger.playBreakpointActionSound"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setInteger("breakpointActionId"_s, breakpointActionId);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void HeapFrontendDispatcher::garbageCollected(Ref<Protocol::Heap::GarbageCollection>&& collection)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Heap.garbageCollected"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setObject("collection"_s, WTFMove(collection));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void HeapFrontendDispatcher::trackingStart(double timestamp, const String& snapshotData)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Heap.trackingStart"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_paramsObject->setString("snapshotData"_s, snapshotData);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void HeapFrontendDispatcher::trackingComplete(double timestamp, const String& snapshotData)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Heap.trackingComplete"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_paramsObject->setString("snapshotData"_s, snapshotData);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void InspectorFrontendDispatcher::evaluateForTestInFrontend(const String& script)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Inspector.evaluateForTestInFrontend"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("script"_s, script);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void InspectorFrontendDispatcher::inspect(Ref<Protocol::Runtime::RemoteObject>&& object, Ref<JSON::Object>&& hints)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Inspector.inspect"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setObject("object"_s, WTFMove(object));
    protocol_paramsObject->setObject("hints"_s, WTFMove(hints));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void LayerTreeFrontendDispatcher::layerTreeDidChange()
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "LayerTree.layerTreeDidChange"_s);

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

#if defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE
void MemoryFrontendDispatcher::memoryPressure(double timestamp, const String& severity)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Memory.memoryPressure"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_paramsObject->setString("severity"_s, severity);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void MemoryFrontendDispatcher::trackingStart(double timestamp)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Memory.trackingStart"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void MemoryFrontendDispatcher::trackingUpdate(Ref<Protocol::Memory::Event>&& event)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Memory.trackingUpdate"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setObject("event"_s, WTFMove(event));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void MemoryFrontendDispatcher::trackingComplete(double timestamp)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Memory.trackingComplete"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}
#endif // defined(ENABLE_RESOURCE_USAGE) && ENABLE_RESOURCE_USAGE

void NetworkFrontendDispatcher::requestWillBeSent(const String& requestId, const String& frameId, const String& loaderId, const String& documentURL, Ref<Protocol::Network::Request>&& request, double timestamp, double walltime, Ref<Protocol::Network::Initiator>&& initiator, RefPtr<Protocol::Network::Response>&& opt_redirectResponse, std::optional<Protocol::Page::ResourceType>&& opt_type, const String& opt_targetId)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Network.requestWillBeSent"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("requestId"_s, requestId);
    protocol_paramsObject->setString("frameId"_s, frameId);
    protocol_paramsObject->setString("loaderId"_s, loaderId);
    protocol_paramsObject->setString("documentURL"_s, documentURL);
    protocol_paramsObject->setObject("request"_s, WTFMove(request));
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_paramsObject->setDouble("walltime"_s, walltime);
    protocol_paramsObject->setObject("initiator"_s, WTFMove(initiator));
    if (!!opt_redirectResponse)
        protocol_paramsObject->setObject("redirectResponse"_s, opt_redirectResponse.releaseNonNull());
    if (!!opt_type)
        protocol_paramsObject->setString("type"_s, Protocol::Helpers::getEnumConstantValue(*opt_type));
    if (!!opt_targetId)
        protocol_paramsObject->setString("targetId"_s, opt_targetId);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::responseReceived(const String& requestId, const String& frameId, const String& loaderId, double timestamp, Protocol::Page::ResourceType type, Ref<Protocol::Network::Response>&& response)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Network.responseReceived"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("requestId"_s, requestId);
    protocol_paramsObject->setString("frameId"_s, frameId);
    protocol_paramsObject->setString("loaderId"_s, loaderId);
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_paramsObject->setString("type"_s, Protocol::Helpers::getEnumConstantValue(type));
    protocol_paramsObject->setObject("response"_s, WTFMove(response));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::dataReceived(const String& requestId, double timestamp, int dataLength, int encodedDataLength)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Network.dataReceived"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("requestId"_s, requestId);
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_paramsObject->setInteger("dataLength"_s, dataLength);
    protocol_paramsObject->setInteger("encodedDataLength"_s, encodedDataLength);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::loadingFinished(const String& requestId, double timestamp, const String& opt_sourceMapURL, RefPtr<Protocol::Network::Metrics>&& opt_metrics)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Network.loadingFinished"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("requestId"_s, requestId);
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    if (!!opt_sourceMapURL)
        protocol_paramsObject->setString("sourceMapURL"_s, opt_sourceMapURL);
    if (!!opt_metrics)
        protocol_paramsObject->setObject("metrics"_s, opt_metrics.releaseNonNull());
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::loadingFailed(const String& requestId, double timestamp, const String& errorText, std::optional<bool>&& opt_canceled)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Network.loadingFailed"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("requestId"_s, requestId);
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_paramsObject->setString("errorText"_s, errorText);
    if (!!opt_canceled)
        protocol_paramsObject->setBoolean("canceled"_s, *opt_canceled);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::requestServedFromMemoryCache(const String& requestId, const String& frameId, const String& loaderId, const String& documentURL, double timestamp, Ref<Protocol::Network::Initiator>&& initiator, Ref<Protocol::Network::CachedResource>&& resource)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Network.requestServedFromMemoryCache"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("requestId"_s, requestId);
    protocol_paramsObject->setString("frameId"_s, frameId);
    protocol_paramsObject->setString("loaderId"_s, loaderId);
    protocol_paramsObject->setString("documentURL"_s, documentURL);
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_paramsObject->setObject("initiator"_s, WTFMove(initiator));
    protocol_paramsObject->setObject("resource"_s, WTFMove(resource));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::requestIntercepted(const String& requestId, Ref<Protocol::Network::Request>&& request)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Network.requestIntercepted"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("requestId"_s, requestId);
    protocol_paramsObject->setObject("request"_s, WTFMove(request));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::responseIntercepted(const String& requestId, Ref<Protocol::Network::Response>&& response)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Network.responseIntercepted"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("requestId"_s, requestId);
    protocol_paramsObject->setObject("response"_s, WTFMove(response));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::webSocketWillSendHandshakeRequest(const String& requestId, double timestamp, double walltime, Ref<Protocol::Network::WebSocketRequest>&& request)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Network.webSocketWillSendHandshakeRequest"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("requestId"_s, requestId);
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_paramsObject->setDouble("walltime"_s, walltime);
    protocol_paramsObject->setObject("request"_s, WTFMove(request));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::webSocketHandshakeResponseReceived(const String& requestId, double timestamp, Ref<Protocol::Network::WebSocketResponse>&& response)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Network.webSocketHandshakeResponseReceived"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("requestId"_s, requestId);
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_paramsObject->setObject("response"_s, WTFMove(response));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::webSocketCreated(const String& requestId, const String& url)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Network.webSocketCreated"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("requestId"_s, requestId);
    protocol_paramsObject->setString("url"_s, url);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::webSocketClosed(const String& requestId, double timestamp)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Network.webSocketClosed"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("requestId"_s, requestId);
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::webSocketFrameReceived(const String& requestId, double timestamp, Ref<Protocol::Network::WebSocketFrame>&& response)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Network.webSocketFrameReceived"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("requestId"_s, requestId);
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_paramsObject->setObject("response"_s, WTFMove(response));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::webSocketFrameError(const String& requestId, double timestamp, const String& errorMessage)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Network.webSocketFrameError"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("requestId"_s, requestId);
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_paramsObject->setString("errorMessage"_s, errorMessage);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void NetworkFrontendDispatcher::webSocketFrameSent(const String& requestId, double timestamp, Ref<Protocol::Network::WebSocketFrame>&& response)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Network.webSocketFrameSent"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("requestId"_s, requestId);
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_paramsObject->setObject("response"_s, WTFMove(response));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void PageFrontendDispatcher::domContentEventFired(double timestamp)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Page.domContentEventFired"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void PageFrontendDispatcher::loadEventFired(double timestamp)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Page.loadEventFired"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void PageFrontendDispatcher::frameNavigated(Ref<Protocol::Page::Frame>&& frame)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Page.frameNavigated"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setObject("frame"_s, WTFMove(frame));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void PageFrontendDispatcher::frameDetached(const String& frameId)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Page.frameDetached"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("frameId"_s, frameId);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void PageFrontendDispatcher::frameStartedLoading(const String& frameId)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Page.frameStartedLoading"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("frameId"_s, frameId);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void PageFrontendDispatcher::frameStoppedLoading(const String& frameId)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Page.frameStoppedLoading"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("frameId"_s, frameId);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void PageFrontendDispatcher::frameScheduledNavigation(const String& frameId, double delay)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Page.frameScheduledNavigation"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("frameId"_s, frameId);
    protocol_paramsObject->setDouble("delay"_s, delay);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void PageFrontendDispatcher::frameClearedScheduledNavigation(const String& frameId)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Page.frameClearedScheduledNavigation"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("frameId"_s, frameId);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void PageFrontendDispatcher::defaultUserPreferencesDidChange(Ref<JSON::ArrayOf<Protocol::Page::UserPreference>>&& preferences)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Page.defaultUserPreferencesDidChange"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setArray("preferences"_s, WTFMove(preferences));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void RuntimeFrontendDispatcher::executionContextCreated(Ref<Protocol::Runtime::ExecutionContextDescription>&& context)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Runtime.executionContextCreated"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setObject("context"_s, WTFMove(context));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void ScriptProfilerFrontendDispatcher::trackingStart(double timestamp)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "ScriptProfiler.trackingStart"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void ScriptProfilerFrontendDispatcher::trackingUpdate(Ref<Protocol::ScriptProfiler::Event>&& event)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "ScriptProfiler.trackingUpdate"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setObject("event"_s, WTFMove(event));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void ScriptProfilerFrontendDispatcher::trackingComplete(double timestamp, RefPtr<Protocol::ScriptProfiler::Samples>&& opt_samples)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "ScriptProfiler.trackingComplete"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setDouble("timestamp"_s, timestamp);
    if (!!opt_samples)
        protocol_paramsObject->setObject("samples"_s, opt_samples.releaseNonNull());
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void TargetFrontendDispatcher::targetCreated(Ref<Protocol::Target::TargetInfo>&& targetInfo)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Target.targetCreated"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setObject("targetInfo"_s, WTFMove(targetInfo));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void TargetFrontendDispatcher::targetDestroyed(const String& targetId)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Target.targetDestroyed"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("targetId"_s, targetId);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void TargetFrontendDispatcher::didCommitProvisionalTarget(const String& oldTargetId, const String& newTargetId)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Target.didCommitProvisionalTarget"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("oldTargetId"_s, oldTargetId);
    protocol_paramsObject->setString("newTargetId"_s, newTargetId);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void TargetFrontendDispatcher::dispatchMessageFromTarget(const String& targetId, const String& message)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Target.dispatchMessageFromTarget"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("targetId"_s, targetId);
    protocol_paramsObject->setString("message"_s, message);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void TimelineFrontendDispatcher::eventRecorded(Ref<Protocol::Timeline::TimelineEvent>&& record)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Timeline.eventRecorded"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setObject("record"_s, WTFMove(record));
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void TimelineFrontendDispatcher::recordingStarted(double startTime)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Timeline.recordingStarted"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setDouble("startTime"_s, startTime);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void TimelineFrontendDispatcher::recordingStopped(double endTime)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Timeline.recordingStopped"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setDouble("endTime"_s, endTime);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void TimelineFrontendDispatcher::autoCaptureStarted()
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Timeline.autoCaptureStarted"_s);

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void WorkerFrontendDispatcher::workerCreated(const String& workerId, const String& url, const String& name)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Worker.workerCreated"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("workerId"_s, workerId);
    protocol_paramsObject->setString("url"_s, url);
    protocol_paramsObject->setString("name"_s, name);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void WorkerFrontendDispatcher::workerTerminated(const String& workerId)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Worker.workerTerminated"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("workerId"_s, workerId);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

void WorkerFrontendDispatcher::dispatchMessageFromWorker(const String& workerId, const String& message)
{
    auto protocol_jsonMessage = JSON::Object::create();
    protocol_jsonMessage->setString("method"_s, "Worker.dispatchMessageFromWorker"_s);
    auto protocol_paramsObject = JSON::Object::create();
    protocol_paramsObject->setString("workerId"_s, workerId);
    protocol_paramsObject->setString("message"_s, message);
    protocol_jsonMessage->setObject("params"_s, WTFMove(protocol_paramsObject));

    m_frontendRouter.sendEvent(protocol_jsonMessage->toJSONString());
}

} // namespace Inspector
