/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber.extensions.inputevt;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import net.java.sip.communicator.impl.protocol.jabber.extensions.inputevt.RemoteControlExtensionProvider;
import org.jivesoftware.smack.packet.PacketExtension;

public class RemoteControlExtension
implements PacketExtension {
    private final ComponentEvent event;
    private final Dimension videoPanelSize;

    public RemoteControlExtension() {
        this.videoPanelSize = null;
        this.event = null;
    }

    public RemoteControlExtension(Dimension videoPanelSize) {
        this.videoPanelSize = videoPanelSize;
        this.event = null;
    }

    public RemoteControlExtension(ComponentEvent event) {
        this.event = event;
        this.videoPanelSize = null;
    }

    public RemoteControlExtension(InputEvent event, Dimension videoPanelSize) {
        this.videoPanelSize = videoPanelSize;
        this.event = event;
    }

    public ComponentEvent getEvent() {
        return this.event;
    }

    public String getElementName() {
        return "remote-control";
    }

    public String getNamespace() {
        return "http://jitsi.org/protocol/inputevt";
    }

    public String toXML() {
        String ret = null;
        if (this.event == null) {
            return null;
        }
        if (this.event instanceof MouseEvent) {
            MouseEvent e = (MouseEvent)this.event;
            switch (e.getID()) {
                case 503: 
                case 506: {
                    if (this.videoPanelSize == null) break;
                    Point p = e.getPoint();
                    double x = p.getX() / (double)this.videoPanelSize.width;
                    double y = p.getY() / (double)this.videoPanelSize.height;
                    ret = RemoteControlExtensionProvider.getMouseMovedXML(x, y);
                    break;
                }
                case 507: {
                    MouseWheelEvent ew = (MouseWheelEvent)e;
                    ret = RemoteControlExtensionProvider.getMouseWheelXML(ew.getWheelRotation());
                    break;
                }
                case 501: {
                    ret = RemoteControlExtensionProvider.getMousePressedXML(e.getModifiers());
                    break;
                }
                case 502: {
                    ret = RemoteControlExtensionProvider.getMouseReleasedXML(e.getModifiers());
                    break;
                }
            }
        } else if (this.event instanceof KeyEvent) {
            KeyEvent e = (KeyEvent)this.event;
            int keycode = e.getKeyCode();
            char key = e.getKeyChar();
            keycode = key != '\uffff' ? (int)e.getKeyChar() : e.getKeyCode();
            if (keycode == 0) {
                return null;
            }
            switch (e.getID()) {
                case 401: {
                    ret = RemoteControlExtensionProvider.getKeyPressedXML(keycode);
                    break;
                }
                case 402: {
                    ret = RemoteControlExtensionProvider.getKeyReleasedXML(keycode);
                    break;
                }
                case 400: {
                    ret = RemoteControlExtensionProvider.getKeyTypedXML(keycode);
                    break;
                }
            }
        }
        return ret;
    }
}

