/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.service.argdelegation.UriHandler;
import net.java.sip.communicator.service.gui.ExportedWindow;
import net.java.sip.communicator.service.protocol.AccountID;
import net.java.sip.communicator.service.protocol.AccountManager;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationNotSupportedException;
import net.java.sip.communicator.service.protocol.OperationSetMultiUserChat;
import net.java.sip.communicator.service.protocol.OperationSetPersistentPresence;
import net.java.sip.communicator.service.protocol.OperationSetPresence;
import net.java.sip.communicator.service.protocol.ProtocolProviderFactory;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.service.protocol.RegistrationState;
import net.java.sip.communicator.service.protocol.event.AccountManagerEvent;
import net.java.sip.communicator.service.protocol.event.AccountManagerListener;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusChangeEvent;
import net.java.sip.communicator.service.protocol.event.ProviderPresenceStatusListener;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeEvent;
import net.java.sip.communicator.service.protocol.event.RegistrationStateChangeListener;
import net.java.sip.communicator.util.Logger;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class UriHandlerJabberImpl
implements UriHandler,
ServiceListener,
AccountManagerListener {
    private static final Logger logger = Logger.getLogger(UriHandlerJabberImpl.class);
    private final ProtocolProviderFactory protoFactory;
    private ServiceRegistration ourServiceRegistration = null;
    private final Object registrationLock = new Object();
    private AccountManager accountManager;
    private final boolean[] storedAccountsAreLoaded = new boolean[1];
    private List<String> uris;
    private boolean networkFailReceived = false;

    public UriHandlerJabberImpl(ProtocolProviderFactory protoFactory) throws NullPointerException {
        if (protoFactory == null) {
            throw new NullPointerException("The ProtocolProviderFactory that a UriHandler is created with  cannot be null.");
        }
        this.protoFactory = protoFactory;
        this.hookStoredAccounts();
        this.protoFactory.getBundleContext().addServiceListener((ServiceListener)this);
        this.registerHandlerService();
    }

    public void dispose() {
        this.protoFactory.getBundleContext().removeServiceListener((ServiceListener)this);
        this.unregisterHandlerService();
        this.unhookStoredAccounts();
    }

    private void hookStoredAccounts() {
        if (this.accountManager == null) {
            BundleContext bundleContext = this.protoFactory.getBundleContext();
            this.accountManager = (AccountManager)bundleContext.getService(bundleContext.getServiceReference(AccountManager.class.getName()));
            this.accountManager.addListener((AccountManagerListener)this);
        }
    }

    private void unhookStoredAccounts() {
        if (this.accountManager != null) {
            this.accountManager.removeListener((AccountManagerListener)this);
            this.accountManager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleAccountManagerEvent(AccountManagerEvent event) {
        if (1 != event.getType() || this.protoFactory != event.getFactory()) return;
        List<String> uris = null;
        boolean[] blArray = this.storedAccountsAreLoaded;
        synchronized (this.storedAccountsAreLoaded) {
            this.storedAccountsAreLoaded[0] = true;
            if (this.uris != null) {
                uris = this.uris;
                this.uris = null;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            this.unhookStoredAccounts();
            if (uris == null) return;
            Iterator<String> uriIter = uris.iterator();
            while (uriIter.hasNext()) {
                this.handleUri(uriIter.next());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerHandlerService() {
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.ourServiceRegistration != null) {
                return;
            }
            Hashtable<String, String> registrationProperties = new Hashtable<String, String>();
            for (String protocol : this.getProtocol()) {
                registrationProperties.put("ProtocolName", protocol);
            }
            this.ourServiceRegistration = JabberActivator.bundleContext.registerService(UriHandler.class.getName(), (Object)this, registrationProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHandlerService() {
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.ourServiceRegistration != null) {
                this.ourServiceRegistration.unregister();
                this.ourServiceRegistration = null;
            }
        }
    }

    public String[] getProtocol() {
        return new String[]{"xmpp"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleUri(String uri) {
        boolean[] blArray = this.storedAccountsAreLoaded;
        synchronized (this.storedAccountsAreLoaded) {
            block21: {
                ProtocolProviderService provider;
                if (!this.storedAccountsAreLoaded[0]) {
                    if (this.uris == null) {
                        this.uris = new LinkedList<String>();
                    }
                    this.uris.add(uri);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                try {
                    provider = this.selectHandlingProvider(uri);
                }
                catch (OperationFailedException exc) {
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("User canceled handling of uri " + uri));
                    }
                    return;
                }
                if (provider == null) {
                    this.showErrorMessage("You need to configure at least one XMPP account \nto be able to call " + uri, null);
                    return;
                }
                if (!uri.contains("?")) {
                    OperationSetPersistentPresence presenceOpSet = (OperationSetPersistentPresence)provider.getOperationSet(OperationSetPersistentPresence.class);
                    String contactId = uri.substring(uri.indexOf(58) + 1);
                    Pattern p = Pattern.compile(".+@.+\\.[a-z]+");
                    if (!p.matcher(contactId).matches()) {
                        this.showErrorMessage("Wrong contact id : " + uri, null);
                        return;
                    }
                    Contact contact = presenceOpSet.findContactByID(contactId);
                    if (contact == null) {
                        Integer result = JabberActivator.getUIService().getPopupDialog().showConfirmPopupDialog((Object)("Do you want to add the contact : " + contactId + " ?"), "Add contact", 0);
                        if (((Object)result).equals(0)) {
                            ExportedWindow ex = JabberActivator.getUIService().getExportedWindow(ExportedWindow.ADD_CONTACT_WINDOW, (Object[])new String[]{contactId});
                            ex.setVisible(true);
                        }
                        return;
                    }
                    JabberActivator.getUIService().getChat(contact).setChatVisible(true);
                } else {
                    String croom = uri.replaceFirst(this.getProtocol() + ":", "");
                    int ix = croom.indexOf("?");
                    String param = croom.substring(ix + 1, croom.length());
                    croom = croom.substring(0, ix);
                    if (param.equalsIgnoreCase("join")) {
                        OperationSetMultiUserChat mchatOpSet = (OperationSetMultiUserChat)provider.getOperationSet(OperationSetMultiUserChat.class);
                        try {
                            ChatRoom room = mchatOpSet.findRoom(croom);
                            if (room != null) {
                                room.join();
                            }
                        }
                        catch (OperationFailedException exc) {
                            if (exc.getErrorCode() == 2 && !this.networkFailReceived) {
                                this.networkFailReceived = true;
                                OperationSetPresence presenceOpSet = (OperationSetPresence)provider.getOperationSet(OperationSetPresence.class);
                                presenceOpSet.addProviderPresenceStatusListener((ProviderPresenceStatusListener)new ProviderStatusListener(uri, presenceOpSet));
                                break block21;
                            }
                            this.showErrorMessage("Error joining to  " + croom, (Exception)((Object)exc));
                        }
                        catch (OperationNotSupportedException exc) {
                            this.showErrorMessage("Join to " + croom + ", not supported!", (Exception)((Object)exc));
                        }
                    } else {
                        this.showErrorMessage("Unknown param : " + param, null);
                    }
                }
            }
            return;
        }
    }

    private void promptForRegistration(String uri, ProtocolProviderService provider) {
        int answer = JabberActivator.getUIService().getPopupDialog().showConfirmPopupDialog((Object)"You need to be online in order to chat and your account is currently offline. Do you want to connect now?", "Account is currently offline", 0);
        if (answer == 0) {
            new ProtocolRegistrationThread(uri, provider).start();
        }
    }

    public void serviceChanged(ServiceEvent event) {
        Object sourceService = JabberActivator.bundleContext.getService(event.getServiceReference());
        if (sourceService != this.protoFactory) {
            return;
        }
        switch (event.getType()) {
            case 1: {
                this.registerHandlerService();
                break;
            }
            case 4: {
                this.unregisterHandlerService();
                break;
            }
        }
    }

    private void showErrorMessage(String message, Exception exc) {
        JabberActivator.getUIService().getPopupDialog().showMessagePopupDialog((Object)message, "Failed to create chat!", 0);
        logger.error((Object)message, (Throwable)exc);
    }

    public ProtocolProviderService selectHandlingProvider(String uri) throws OperationFailedException {
        ArrayList registeredAccounts = this.protoFactory.getRegisteredAccounts();
        if (registeredAccounts.size() == 0) {
            return null;
        }
        if (registeredAccounts.size() == 1) {
            ServiceReference providerReference = this.protoFactory.getProviderForAccount((AccountID)registeredAccounts.get(0));
            ProtocolProviderService provider = (ProtocolProviderService)JabberActivator.bundleContext.getService(providerReference);
            return provider;
        }
        ArrayList<ProviderComboBoxEntry> providers = new ArrayList<ProviderComboBoxEntry>();
        for (AccountID accountID : registeredAccounts) {
            ServiceReference providerReference = this.protoFactory.getProviderForAccount(accountID);
            ProtocolProviderService provider = (ProtocolProviderService)JabberActivator.bundleContext.getService(providerReference);
            providers.add(new ProviderComboBoxEntry(provider));
        }
        Object result = JabberActivator.getUIService().getPopupDialog().showInputPopupDialog((Object)("Please select the account that you would like \nto use to chat with " + uri), "Account Selection", 2, providers.toArray(), providers.get(0));
        if (result == null) {
            throw new OperationFailedException("Operation cancelled", 16);
        }
        return ((ProviderComboBoxEntry)result).provider;
    }

    private class ProviderStatusListener
    implements ProviderPresenceStatusListener {
        private final String uri;
        private final OperationSetPresence parentOpSet;

        public ProviderStatusListener(String uri, OperationSetPresence parentOpSet) {
            this.uri = uri;
            this.parentOpSet = parentOpSet;
        }

        public void providerStatusChanged(ProviderPresenceStatusChangeEvent ev) {
            if (ev.getNewStatus().isOnline()) {
                this.parentOpSet.removeProviderPresenceStatusListener((ProviderPresenceStatusListener)this);
                UriHandlerJabberImpl.this.handleUri(this.uri);
            }
        }

        public void providerStatusMessageChanged(PropertyChangeEvent ev) {
        }
    }

    private static class ProviderComboBoxEntry {
        public final ProtocolProviderService provider;

        public ProviderComboBoxEntry(ProtocolProviderService provider) {
            this.provider = provider;
        }

        public String toString() {
            return this.provider.getAccountID().getAccountAddress();
        }
    }

    private class ProtocolRegistrationThread
    extends Thread
    implements RegistrationStateChangeListener {
        private ProtocolProviderService handlerProvider;
        private String uri;

        public ProtocolRegistrationThread(String uri, ProtocolProviderService handlerProvider) {
            super("UriHandlerProviderRegistrationThread:uri=" + uri);
            this.handlerProvider = null;
            this.uri = null;
            this.uri = uri;
            this.handlerProvider = handlerProvider;
        }

        @Override
        public void run() {
            this.handlerProvider.addRegistrationStateChangeListener((RegistrationStateChangeListener)this);
            try {
                this.handlerProvider.register(JabberActivator.getUIService().getDefaultSecurityAuthority(this.handlerProvider));
            }
            catch (OperationFailedException exc) {
                logger.error((Object)"Failed to manually register provider.");
                logger.warn((Object)exc.getMessage(), (Throwable)exc);
            }
        }

        public void registrationStateChanged(RegistrationStateChangeEvent evt) {
            if (evt.getNewState() == RegistrationState.REGISTERED) {
                Thread uriRehandleThread = new Thread(){

                    @Override
                    public void run() {
                        UriHandlerJabberImpl.this.handleUri(ProtocolRegistrationThread.this.uri);
                    }
                };
                uriRehandleThread.setName("UriRehandleThread:uri=" + this.uri);
                uriRehandleThread.start();
            }
            if (evt.getNewState() == RegistrationState.REGISTERING) {
                return;
            }
            this.handlerProvider.removeRegistrationStateChangeListener((RegistrationStateChangeListener)this);
        }
    }
}

