/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.protocol.jabber;

import java.awt.Dimension;
import java.awt.Point;
import java.text.ParseException;
import net.java.sip.communicator.impl.protocol.jabber.AbstractCallJabberGTalkImpl;
import net.java.sip.communicator.impl.protocol.jabber.AbstractCallPeerJabberGTalkImpl;
import net.java.sip.communicator.impl.protocol.jabber.AbstractCallPeerMediaHandlerJabberGTalkImpl;
import net.java.sip.communicator.impl.protocol.jabber.CallJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.JabberActivator;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetBasicTelephonyJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.OperationSetVideoTelephonyJabberImpl;
import net.java.sip.communicator.impl.protocol.jabber.ProtocolProviderServiceJabberImpl;
import net.java.sip.communicator.service.protocol.Call;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.OperationSetDesktopStreaming;
import net.java.sip.communicator.service.protocol.media.MediaAwareCall;
import net.java.sip.communicator.service.protocol.media.ProtocolMediaActivator;
import org.jitsi.service.neomedia.MediaService;
import org.jitsi.service.neomedia.MediaType;
import org.jitsi.service.neomedia.MediaUseCase;
import org.jitsi.service.neomedia.VideoMediaStream;
import org.jitsi.service.neomedia.device.MediaDevice;
import org.jitsi.service.neomedia.format.MediaFormat;
import org.jitsi.service.neomedia.format.VideoMediaFormat;

public class OperationSetDesktopStreamingJabberImpl
extends OperationSetVideoTelephonyJabberImpl
implements OperationSetDesktopStreaming {
    protected Dimension size = null;
    protected Point origin = null;

    public OperationSetDesktopStreamingJabberImpl(OperationSetBasicTelephonyJabberImpl basicTelephony) {
        super(basicTelephony);
    }

    public MediaUseCase getMediaUseCase() {
        return MediaUseCase.DESKTOP;
    }

    public Call createVideoCall(String uri, MediaDevice mediaDevice) throws OperationFailedException, ParseException {
        return this.createOutgoingVideoCall(uri, mediaDevice);
    }

    public Call createVideoCall(Contact callee, MediaDevice mediaDevice) throws OperationFailedException {
        return this.createOutgoingVideoCall(callee.getAddress(), mediaDevice);
    }

    @Override
    public Call createVideoCall(String uri) throws OperationFailedException {
        Call call = this.createOutgoingVideoCall(uri);
        MediaDevice device = ((MediaAwareCall)call).getDefaultDevice(MediaType.VIDEO);
        this.size = ((VideoMediaFormat)device.getFormat()).getSize();
        this.origin = OperationSetDesktopStreamingJabberImpl.getOriginForMediaDevice(device);
        return call;
    }

    @Override
    public Call createVideoCall(Contact callee) throws OperationFailedException {
        return this.createVideoCall(callee.getAddress());
    }

    @Override
    public void setLocalVideoAllowed(Call call, boolean allowed) throws OperationFailedException {
        this.setLocalVideoAllowed(call, null, allowed);
    }

    public void setLocalVideoAllowed(Call call, MediaDevice mediaDevice, boolean allowed) throws OperationFailedException {
        AbstractCallJabberGTalkImpl callImpl = (AbstractCallJabberGTalkImpl)call;
        MediaUseCase useCase = this.getMediaUseCase();
        if (mediaDevice == null) {
            MediaService mediaService = ProtocolMediaActivator.getMediaService();
            mediaDevice = mediaService.getDefaultDevice(MediaType.VIDEO, useCase);
        }
        callImpl.setVideoDevice(mediaDevice, useCase);
        callImpl.setLocalVideoAllowed(allowed, useCase);
        MediaFormat mediaDeviceFormat = mediaDevice.getFormat();
        this.size = mediaDeviceFormat == null ? null : ((VideoMediaFormat)mediaDeviceFormat).getSize();
        callImpl.modifyVideoContent();
        this.origin = OperationSetDesktopStreamingJabberImpl.getOriginForMediaDevice(mediaDevice);
    }

    public boolean isLocalVideoAllowed(Call call) {
        return ((MediaAwareCall)call).isLocalVideoAllowed(MediaUseCase.DESKTOP);
    }

    protected Call createOutgoingVideoCall(String calleeAddress, MediaDevice videoDevice) throws OperationFailedException {
        if (((ProtocolProviderServiceJabberImpl)this.parentProvider).getConnection() == null) {
            throw new OperationFailedException("Failed to create OutgoingJingleSession.\nwe don't have a valid XMPPConnection.", 4);
        }
        CallJabberImpl call = new CallJabberImpl((OperationSetBasicTelephonyJabberImpl)this.basicTelephony);
        MediaUseCase useCase = this.getMediaUseCase();
        if (videoDevice != null) {
            call.setVideoDevice(videoDevice, useCase);
        }
        call.setLocalVideoAllowed(true, useCase);
        ((OperationSetBasicTelephonyJabberImpl)this.basicTelephony).createOutgoingCall(call, calleeAddress);
        this.origin = OperationSetDesktopStreamingJabberImpl.getOriginForMediaDevice(videoDevice);
        return call;
    }

    public boolean isPartialStreaming(Call call) {
        MediaAwareCall callImpl = (MediaAwareCall)call;
        MediaDevice device = callImpl.getDefaultDevice(MediaType.VIDEO);
        return device == null ? false : JabberActivator.getMediaService().isPartialStreaming(device);
    }

    public void movePartialDesktopStreaming(Call call, int x, int y) {
        AbstractCallJabberGTalkImpl callImpl = (AbstractCallJabberGTalkImpl)call;
        AbstractCallPeerJabberGTalkImpl callPeerImpl = (AbstractCallPeerJabberGTalkImpl)((Object)callImpl.getCallPeers().next());
        VideoMediaStream videoStream = (VideoMediaStream)((AbstractCallPeerMediaHandlerJabberGTalkImpl)callPeerImpl.getMediaHandler()).getStream(MediaType.VIDEO);
        if (videoStream != null) {
            videoStream.movePartialDesktopStreaming(x, y);
            if (this.origin != null) {
                this.origin.x = x;
                this.origin.y = y;
            } else {
                this.origin = new Point(x, y);
            }
        }
    }

    protected static Point getOriginForMediaDevice(MediaDevice device) {
        MediaService mediaService = JabberActivator.getMediaService();
        return mediaService.getOriginForDesktopStreamingDevice(device);
    }
}

