/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.impl.osdependent.jdic;

import net.java.sip.communicator.impl.osdependent.OsDependentActivator;
import net.java.sip.communicator.service.protocol.OperationFailedException;
import net.java.sip.communicator.service.protocol.ProtocolProviderService;
import net.java.sip.communicator.util.Logger;

public class ProviderRegistration
extends Thread {
    private ProtocolProviderService protocolProvider;
    private Logger logger = Logger.getLogger((String)ProviderRegistration.class.getName());

    public ProviderRegistration(ProtocolProviderService protocolProvider) {
        this.protocolProvider = protocolProvider;
    }

    @Override
    public void run() {
        try {
            this.protocolProvider.register(OsDependentActivator.getUIService().getDefaultSecurityAuthority(this.protocolProvider));
        }
        catch (OperationFailedException ex) {
            int errorCode = ex.getErrorCode();
            if (errorCode == 1) {
                this.logger.error((Object)"Provider could not be registered due to the following general error: ", (Throwable)ex);
            }
            if (errorCode == 4) {
                this.logger.error((Object)"Provider could not be registered due to the following internal error: ", (Throwable)ex);
            }
            if (errorCode == 2) {
                this.logger.error((Object)("Provider could not be registered due to a network failure: " + (Object)((Object)ex)));
            }
            if (errorCode == 7) {
                this.logger.error((Object)"Provider could not be registered due to an invalid account property: ", (Throwable)ex);
            }
            this.logger.error((Object)"Provider could not be registered.", (Throwable)ex);
        }
    }
}

